/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.shared.common.error.StandardException;

public class StatementTablePermission
extends StatementPermission {
    UUID tableUUID;
    int privType;

    public StatementTablePermission(UUID tableUUID, int privType) {
        this.tableUUID = tableUUID;
        this.privType = privType;
    }

    public int getPrivType() {
        return this.privType;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            StatementTablePermission other = (StatementTablePermission)obj;
            return this.privType == other.privType && this.tableUUID.equals(other.tableUUID);
        }
        return false;
    }

    public int hashCode() {
        return this.privType + this.tableUUID.hashCode();
    }

    @Override
    public void check(LanguageConnectionContext lcc, boolean forGrant, Activation activation) throws StandardException {
        ExecPreparedStatement ps = activation.getPreparedStatement();
        if (!this.hasPermissionOnTable(lcc, activation, forGrant, ps)) {
            DataDictionary dd = lcc.getDataDictionary();
            TableDescriptor td = this.getTableDescriptor(dd);
            throw StandardException.newException(forGrant ? "42501" : "42500", lcc.getCurrentUserId(activation), this.getPrivName(), td.getSchemaName(), td.getName());
        }
    }

    protected TableDescriptor getTableDescriptor(DataDictionary dd) throws StandardException {
        TableDescriptor td = dd.getTableDescriptor(this.tableUUID);
        if (td == null) {
            throw StandardException.newException("4250E", "table");
        }
        return td;
    }

    protected boolean hasPermissionOnTable(LanguageConnectionContext lcc, Activation activation, boolean forGrant, ExecPreparedStatement ps) throws StandardException {
        String role;
        boolean result;
        DataDictionary dd = lcc.getDataDictionary();
        String currentUserId = lcc.getCurrentUserId(activation);
        boolean bl = result = this.oneAuthHasPermissionOnTable(dd, "PUBLIC", forGrant) || this.oneAuthHasPermissionOnTable(dd, currentUserId, forGrant);
        if (!result && (role = lcc.getCurrentRoleId(activation)) != null) {
            String dbo = dd.getAuthorizationDatabaseOwner();
            RoleGrantDescriptor rd = dd.getRoleGrantDescriptor(role, currentUserId, dbo);
            if (rd == null) {
                rd = dd.getRoleGrantDescriptor(role, "PUBLIC", dbo);
            }
            if (rd == null) {
                lcc.setCurrentRole(activation, null);
            } else {
                String r;
                RoleClosureIterator rci = dd.createRoleClosureIterator(activation.getTransactionController(), role, true);
                while (!result && (r = rci.next()) != null) {
                    result = this.oneAuthHasPermissionOnTable(dd, r, forGrant);
                }
                if (result) {
                    DependencyManager dm = dd.getDependencyManager();
                    RoleGrantDescriptor rgd = dd.getRoleDefinitionDescriptor(role);
                    ContextManager cm = lcc.getContextManager();
                    dm.addDependency(ps, rgd, cm);
                    dm.addDependency(activation, rgd, cm);
                }
            }
        }
        return result;
    }

    protected boolean oneAuthHasPermissionOnTable(DataDictionary dd, String authorizationId, boolean forGrant) throws StandardException {
        TablePermsDescriptor perms = dd.getTablePermissions(this.tableUUID, authorizationId);
        if (perms == null) {
            return false;
        }
        String priv = null;
        switch (this.privType) {
            case 0: 
            case 8: {
                priv = perms.getSelectPriv();
                break;
            }
            case 1: {
                priv = perms.getUpdatePriv();
                break;
            }
            case 2: {
                priv = perms.getReferencesPriv();
                break;
            }
            case 3: {
                priv = perms.getInsertPriv();
                break;
            }
            case 4: {
                priv = perms.getDeletePriv();
                break;
            }
            case 5: {
                priv = perms.getTriggerPriv();
            }
        }
        return "Y".equals(priv) || !forGrant && "y".equals(priv);
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        if (this.oneAuthHasPermissionOnTable(dd, authid, false)) {
            return dd.getTablePermissions(this.tableUUID, authid);
        }
        return null;
    }

    public String getPrivName() {
        switch (this.privType) {
            case 0: 
            case 8: {
                return "SELECT";
            }
            case 1: {
                return "UPDATE";
            }
            case 2: {
                return "REFERENCES";
            }
            case 3: {
                return "INSERT";
            }
            case 4: {
                return "DELETE";
            }
            case 5: {
                return "TRIGGER";
            }
        }
        return "?";
    }

    public String toString() {
        return "StatementTablePermission: " + this.getPrivName() + " " + String.valueOf(this.tableUUID);
    }
}

