/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;

public final class DoubleProperties
extends Properties {
    private final Properties read;
    private final Properties write;

    public DoubleProperties(Properties read, Properties write) {
        this.read = read;
        this.write = write;
    }

    @Override
    public Object put(Object key, Object value) {
        return this.write.put(key, value);
    }

    @Override
    public String getProperty(String key) {
        return this.read.getProperty(key, this.write.getProperty(key));
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.read.getProperty(key, this.write.getProperty(key, defaultValue));
    }

    public Enumeration<Object> propertyNames() {
        HashSet<Object> names = new HashSet<Object>();
        DoubleProperties.addAllNames(this.write, names);
        DoubleProperties.addAllNames(this.read, names);
        return Collections.enumeration(names);
    }

    private static void addAllNames(Properties src, HashSet<Object> dest) {
        if (src != null) {
            Enumeration<?> e = src.propertyNames();
            while (e.hasMoreElements()) {
                dest.add(e.nextElement());
            }
        }
    }
}

