/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DMLVTIResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.VTIResultSet;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.vti.DeferModification;

class InsertVTIResultSet
extends DMLVTIResultSet {
    private PreparedStatement ps;
    private VTIResultSet vtiRS;
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public InsertVTIResultSet(NoPutResultSet source, NoPutResultSet vtiRS, Activation activation) throws StandardException {
        super(source, activation);
        this.vtiRS = (VTIResultSet)vtiRS;
    }

    @Override
    protected void openCore() throws StandardException {
        if (this.ps == null) {
            this.ps = (PreparedStatement)this.vtiRS.getVTIConstructor().invoke(this.activation);
        }
        if (this.ps instanceof DeferModification) {
            try {
                ((DeferModification)((Object)this.ps)).modificationNotify(1, this.constants.deferred);
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        ExecRow row = this.getNextRowCore(this.sourceResultSet);
        try {
            this.rs = this.ps.executeQuery();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.firstExecute && this.constants.deferred) {
            Properties properties = new Properties();
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, properties, this.resultDescription);
        }
        while (row != null) {
            if (this.constants.deferred) {
                this.rowHolder.insert(row);
            } else {
                this.insertIntoVTI(this.rs, row);
            }
            ++this.rowCount;
            if (this.constants.singleRowSource) {
                row = null;
                continue;
            }
            row = this.getNextRowCore(this.sourceResultSet);
        }
        if (this.constants.deferred) {
            CursorResultSet tempRS = this.rowHolder.getResultSet();
            try {
                tempRS.open();
                while ((row = tempRS.getNextRow()) != null) {
                    this.insertIntoVTI(this.rs, row);
                }
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                tempRS.close();
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }

    private void insertIntoVTI(ResultSet target, ExecRow row) throws StandardException {
        try {
            target.moveToInsertRow();
            DataValueDescriptor[] rowArray = row.getRowArray();
            for (int index = 0; index < rowArray.length; ++index) {
                DataValueDescriptor dvd = rowArray[index];
                try {
                    if (dvd.isNull()) {
                        target.updateNull(index + 1);
                        continue;
                    }
                    dvd.setInto(target, index + 1);
                    continue;
                }
                catch (Throwable t) {
                    target.updateObject(index + 1, dvd.getObject());
                }
            }
            target.insertRow();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    @Override
    public void cleanUp() throws StandardException {
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
            this.rs = null;
        }
        if (!this.vtiRS.isReuseablePs() && this.ps != null) {
            try {
                this.ps.close();
                this.ps = null;
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        super.cleanUp();
    }

    @Override
    public void close() throws StandardException {
        this.close(false);
    }

    @Override
    public void finish() throws StandardException {
        if (this.ps != null && !this.vtiRS.isReuseablePs()) {
            try {
                this.ps.close();
                this.ps = null;
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        super.finish();
    }
}

