/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURBaseTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURDataModelSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SURQueryMixTest
extends SURBaseTest {
    private final String query;
    private final String cursorName;
    private final boolean positioned;
    private boolean checkRowUpdated;
    private boolean checkRowDeleted;
    private static final String[] selectConditions = new String[]{"WHERE c like 'T%'", " ", "WHERE b > 5", "WHERE id >= a", "WHERE id > 1 and id < 900", "WHERE id = 1", "WHERE id in (1,3,4,600,900,955,966,977,978)", "WHERE a in (1,3,4,600,9200,955,966,977,978)", "WHERE a>2 and a<9000"};
    private static final String[] projectConditions = new String[]{"id,c,a,b", "id,c", "a,b", "*", "id,a,b,c", "id,a", "a,b,c", "a,c"};

    public SURQueryMixTest(String model, String query, String cursorName, boolean positioned) {
        super("SURQueryMixTest{Model=" + model + ",Query=" + query + ",Cursor=" + cursorName + ",Positioned=" + positioned + "}");
        this.query = query;
        this.cursorName = cursorName;
        this.positioned = positioned;
        this.checkRowUpdated = false;
        this.checkRowDeleted = false;
    }

    public void runTest() throws SQLException {
        SURQueryMixTest.println(this.query);
        DatabaseMetaData dbMeta = this.getConnection().getMetaData();
        if (dbMeta.ownDeletesAreVisible(1004)) {
            this.checkRowDeleted = true;
        }
        Statement s = this.createStatement(1004, 1008);
        s.setCursorName(this.cursorName);
        ResultSet rs = s.executeQuery(this.query);
        this.checkRowUpdated = dbMeta.ownUpdatesAreVisible(rs.getType());
        this.checkRowDeleted = dbMeta.ownDeletesAreVisible(rs.getType());
        Map<Integer, String> rows = this.createRowMap(rs);
        HashSet<Integer> updatedRows = new HashSet<Integer>();
        HashSet<Integer> deletedRows = new HashSet<Integer>();
        this.testNavigation(rs, rows, updatedRows, deletedRows);
        if (rs.getConcurrency() == 1008) {
            this.updateRandomSampleOfNRecords(rs, rows, updatedRows, 2);
            this.testNavigation(rs, rows, updatedRows, deletedRows);
            this.updateRandomSampleOfNRecords(rs, rows, updatedRows, 5);
            this.testNavigation(rs, rows, updatedRows, deletedRows);
            this.updateRandomSampleOfNRecords(rs, rows, updatedRows, 10);
            this.testNavigation(rs, rows, updatedRows, deletedRows);
            this.deleteRandomSampleOfNRecords(rs, rows, deletedRows, 2);
            this.testNavigation(rs, rows, updatedRows, deletedRows);
            this.deleteRandomSampleOfNRecords(rs, rows, deletedRows, 5);
            this.testNavigation(rs, rows, updatedRows, deletedRows);
            this.deleteRandomSampleOfNRecords(rs, rows, deletedRows, 10);
            this.testNavigation(rs, rows, updatedRows, deletedRows);
        } else {
            SURQueryMixTest.assertTrue((String)"ResultSet concurrency downgraded to CONCUR_READ_ONLY", (boolean)false);
        }
        rs.close();
        s.close();
    }

    private Map<Integer, String> createRowMap(ResultSet rs) throws SQLException {
        HashMap<Integer, String> rows = new HashMap<Integer, String>();
        rs.beforeFirst();
        SURQueryMixTest.assertTrue((String)"Unexpected return from isBeforeFirst()", (boolean)rs.isBeforeFirst());
        int i = 0;
        int sum = 0;
        int expectedSum = 0;
        boolean checkSum = true;
        while (rs.next()) {
            expectedSum += i;
            String row = this.getRowString(rs);
            SURQueryMixTest.println(row);
            rows.put(++i, row);
            sum += rs.getInt(1);
            if (rs.getInt(1) >= 0) continue;
            checkSum = false;
        }
        if (i < 10) {
            checkSum = false;
        }
        SURQueryMixTest.assertTrue((String)"Unexpected return from isAfterLast()", (boolean)rs.isAfterLast());
        if (checkSum) {
            SURQueryMixTest.assertEquals((String)"Sum for column 1 is not correct", (int)expectedSum, (int)sum);
        }
        return rows;
    }

    private List createRandomSample(Map<Integer, String> rows, int k) {
        Random r = new Random();
        ArrayList<Integer> sampledKeys = new ArrayList<Integer>();
        int n = 0;
        for (Integer key : rows.keySet()) {
            double p;
            if (++n <= k) {
                sampledKeys.add(key);
                continue;
            }
            double d = r.nextDouble();
            if (!(d < (p = (double)k / (double)n))) continue;
            int keyToReplace = r.nextInt(k);
            sampledKeys.set(keyToReplace, key);
        }
        return sampledKeys;
    }

    private void deleteRandomSampleOfNRecords(ResultSet rs, Map<Integer, String> rows, Set<Integer> deletedRows, int k) throws SQLException {
        List sampledKeys = this.createRandomSample(rows, k);
        SURQueryMixTest.println("Sampled keys:" + String.valueOf(sampledKeys));
        ResultSetMetaData meta = rs.getMetaData();
        for (Integer key : sampledKeys) {
            rs.absolute(key);
            if (rs.rowDeleted()) continue;
            if (this.positioned) {
                this.createStatement().executeUpdate("DELETE FROM T1 WHERE CURRENT OF \"" + this.cursorName + "\"");
            } else {
                rs.deleteRow();
            }
            rs.relative(0);
            SURQueryMixTest.println("Deleted row " + key);
            rows.put(key, this.getRowString(rs));
            deletedRows.add(key);
        }
    }

    private void updateRandomSampleOfNRecords(ResultSet rs, Map<Integer, String> rows, Set<Integer> updatedRows, int k) throws SQLException {
        List sampledKeys = this.createRandomSample(rows, k);
        SURQueryMixTest.println("Sampled keys:" + String.valueOf(sampledKeys));
        ResultSetMetaData meta = rs.getMetaData();
        for (Integer key : sampledKeys) {
            rs.absolute(key);
            if (this.positioned) {
                this.updatePositioned(rs, meta);
                rs.relative(0);
            } else {
                this.updateRow(rs, meta);
            }
            rows.put(key, this.getRowString(rs));
            updatedRows.add(key);
        }
    }

    private void updateRow(ResultSet rs, ResultSetMetaData meta) throws SQLException {
        for (int column = 1; column <= meta.getColumnCount(); ++column) {
            if (meta.getColumnType(column) == 4) {
                rs.updateInt(column, -rs.getInt(column));
                continue;
            }
            rs.updateString(column, "UPDATED_" + rs.getString(column));
        }
        rs.updateRow();
    }

    private void updatePositioned(ResultSet rs, ResultSetMetaData meta) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE T1 SET ");
        for (int column = 1; column <= meta.getColumnCount(); ++column) {
            sb.append(meta.getColumnName(column));
            sb.append("=?");
            if (column >= meta.getColumnCount()) continue;
            sb.append(",");
        }
        sb.append(" WHERE CURRENT OF \"");
        sb.append(this.cursorName);
        sb.append("\"");
        SURQueryMixTest.println(sb.toString());
        PreparedStatement ps = this.prepareStatement(sb.toString());
        for (int column = 1; column <= meta.getColumnCount(); ++column) {
            if (meta.getColumnType(column) == 4) {
                ps.setInt(column, -rs.getInt(column));
                continue;
            }
            ps.setString(column, "UPDATED_" + rs.getString(column));
        }
        SURQueryMixTest.assertEquals((String)"Expected one row to be updated", (int)1, (int)ps.executeUpdate());
    }

    private void testNavigation(ResultSet rs, Map rows, Set updatedRows, Set deletedRows) throws SQLException {
        String rowString;
        rs.afterLast();
        int i = rows.size();
        while (rs.previous()) {
            rowString = this.getRowString(rs);
            SURQueryMixTest.assertEquals((String)"Navigating with rs.previous(). The row is different compared to the value when navigating forward.", rows.get(i), (Object)rowString);
            if (this.checkRowUpdated && updatedRows.contains(i)) {
                SURQueryMixTest.assertTrue((String)("Expected rs.rowUpdated() to return true on updated row " + rowString), (boolean)rs.rowUpdated());
            }
            if (this.checkRowDeleted && deletedRows.contains(i)) {
                SURQueryMixTest.assertTrue((String)("Expected rs.rowDeleted() to return true on deleted row " + rowString), (boolean)rs.rowDeleted());
            }
            --i;
        }
        for (i = 1; i <= rows.size(); ++i) {
            SURQueryMixTest.assertTrue((String)"Unexpected return from absolute()", (boolean)rs.absolute(i));
            rowString = this.getRowString(rs);
            SURQueryMixTest.assertEquals((String)"Navigating with rs.absolute(). The row is different compared to the value when navigating forward.", rows.get(i), (Object)rowString);
            if (this.checkRowUpdated && updatedRows.contains(i)) {
                SURQueryMixTest.assertTrue((String)("Expected rs.rowUpdated() to return true on updated row " + rowString), (boolean)rs.rowUpdated());
            }
            if (!this.checkRowDeleted || !deletedRows.contains(i)) continue;
            SURQueryMixTest.assertTrue((String)("Expected rs.rowDeleted() to return true on deleted row " + rowString), (boolean)rs.rowDeleted());
        }
        SURQueryMixTest.assertFalse((String)"Unexpected return from absolute()", (boolean)rs.absolute(0));
        SURQueryMixTest.assertTrue((String)"Unexpected return from isBeforeFirst()", (boolean)rs.isBeforeFirst());
        SURQueryMixTest.assertFalse((String)"Unexpected return from absolute()", (boolean)rs.absolute(rows.size() + 1));
        SURQueryMixTest.assertTrue((String)"Unexpected return from isAfterLast()", (boolean)rs.isAfterLast());
        SURQueryMixTest.assertTrue((String)"Unexpected return from absolute()", (boolean)rs.absolute(-1));
        SURQueryMixTest.assertTrue((String)"Unexpected return from isLast()", (boolean)rs.isLast());
        SURQueryMixTest.assertTrue((String)"Unexpected return from absolute()", (boolean)rs.absolute(1));
        SURQueryMixTest.assertTrue((String)"Unexpected return from isFirst()", (boolean)rs.isFirst());
        rs.beforeFirst();
        SURQueryMixTest.assertTrue((String)"Unexptected return from isBeforeFirst()", (boolean)rs.isBeforeFirst());
        int relativePos = rows.size();
        SURQueryMixTest.assertTrue((String)"Unexpected return from relative()", (boolean)rs.relative(relativePos));
        SURQueryMixTest.assertTrue((String)"Unexptected return from isLast()", (boolean)rs.isLast());
        SURQueryMixTest.assertEquals((String)"Navigating with rs.relative(+). A tuple was different compared to the value when navigating forward.", rows.get(relativePos), (Object)this.getRowString(rs));
        SURQueryMixTest.assertTrue((String)"Unexpected return from relative()", (boolean)rs.relative(-relativePos + 1));
        SURQueryMixTest.assertTrue((String)"Unexptected return from isFirst()", (boolean)rs.isFirst());
        SURQueryMixTest.assertEquals((String)"Navigating with rs.relative(-). A tuple was different compared to the value when navigating forward.", rows.get(1), (Object)this.getRowString(rs));
        rs.afterLast();
        SURQueryMixTest.assertTrue((String)"Unexpected return from isAfterLast()", (boolean)rs.isAfterLast());
        SURQueryMixTest.assertTrue((String)"Unexpected return from previous()", (boolean)rs.previous());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isLast()", (boolean)rs.isLast());
        SURQueryMixTest.assertFalse((String)"Unexpected return from next()", (boolean)rs.next());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isAfterLast()", (boolean)rs.isAfterLast());
        rs.last();
        SURQueryMixTest.assertTrue((String)"Unexpected return from isLast()", (boolean)rs.isLast());
        SURQueryMixTest.assertFalse((String)"Unexpected return from next()", (boolean)rs.next());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isAfterLast()", (boolean)rs.isAfterLast());
        rs.beforeFirst();
        SURQueryMixTest.assertTrue((String)"Unexpected return from isBeforeFirst()", (boolean)rs.isBeforeFirst());
        SURQueryMixTest.assertTrue((String)"Unexpected return from next()", (boolean)rs.next());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isFirst", (boolean)rs.isFirst());
        SURQueryMixTest.assertFalse((String)"Unexpected return from previous()", (boolean)rs.previous());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isBeforeFirst()", (boolean)rs.isBeforeFirst());
        rs.first();
        SURQueryMixTest.assertTrue((String)"Unexpected return from isFirst", (boolean)rs.isFirst());
        SURQueryMixTest.assertFalse((String)"Unexpected return from previous()", (boolean)rs.previous());
        SURQueryMixTest.assertTrue((String)"Unexpected return from isBeforeFirst()", (boolean)rs.isBeforeFirst());
    }

    private String getRowString(ResultSet rs) throws SQLException {
        int numberOfColumns = rs.getMetaData().getColumnCount();
        StringBuffer sb = new StringBuffer();
        if (rs.rowDeleted()) {
            return "";
        }
        for (int i = 1; i <= numberOfColumns; ++i) {
            sb.append(rs.getString(i));
            if (i >= numberOfColumns) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private static BaseTestSuite createTestCases(String modelName) {
        BaseTestSuite suite = new BaseTestSuite();
        for (int doPos = 0; doPos < 2; ++doPos) {
            boolean positioned = doPos > 0;
            for (int i = 0; i < selectConditions.length; ++i) {
                for (int j = 0; j < projectConditions.length; ++j) {
                    String cursorName = "cursor_" + i + "_" + j;
                    String stmtString = "SELECT " + projectConditions[j] + " FROM T1 " + selectConditions[i];
                    suite.addTest((Test)new SURQueryMixTest(modelName, stmtString, cursorName, positioned));
                }
            }
        }
        return suite;
    }

    public static Test suite() {
        BaseTestSuite mainSuite = new BaseTestSuite("SURQueryMixTest suite");
        mainSuite.addTest(SURQueryMixTest.baseSuite("SURQueryMixTest:embedded"));
        mainSuite.addTest(TestConfiguration.clientServerDecorator(SURQueryMixTest.baseSuite("SURQueryMixTest:client")));
        return mainSuite;
    }

    private static Test baseSuite(String name) {
        BaseTestSuite mainSuite = new BaseTestSuite(name);
        for (SURDataModelSetup.SURDataModel model : SURDataModelSetup.SURDataModel.values()) {
            BaseTestSuite suite = SURQueryMixTest.createTestCases(model.toString());
            SURDataModelSetup decorator = new SURDataModelSetup((Test)suite, model);
            mainSuite.addTest((Test)decorator);
        }
        return mainSuite;
    }
}

