/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DeclareGlobalTempTableJavaJDBC30Test
extends BaseJDBCTestCase {
    public DeclareGlobalTempTableJavaJDBC30Test(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite();
        suite.addTest(TestConfiguration.embeddedSuite(DeclareGlobalTempTableJavaJDBC30Test.class));
        suite.addTest(TestConfiguration.clientServerDecorator(DeclareGlobalTempTableJavaJDBC30Test.getClientSuite()));
        return suite;
    }

    private static Test getClientSuite() {
        BaseTestSuite suite = new BaseTestSuite("Client/Server");
        suite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testOnCommitPreserveRowsWithHoldability"));
        suite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testSavepointRollbackbehaviour7"));
        suite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testSavepointRollbackbehaviour8"));
        suite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testSavepointRollbackbehaviour11"));
        suite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testSavepointRollbackbehaviour12"));
        suite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testTest4"));
        suite.addTest((Test)new DeclareGlobalTempTableJavaJDBC30Test("testPooledConnectionClosed"));
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testOnCommitDeleteRowsWithHoldableOpenCursor() throws SQLException {
        Statement s1 = this.getConnection().createStatement(1003, 1007, 1);
        s1.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit delete rows not logged");
        s1.executeUpdate("insert into session.t1 values(11, 1)");
        s1.executeUpdate("insert into session.t1 values(12, 2)");
        JDBC.assertSingleValueResultSet(s1.executeQuery("select count(*) from SESSION.t1"), "2");
        ResultSet rs1 = s1.executeQuery("select * from SESSION.t1");
        rs1.next();
        Statement s2 = this.getConnection().createStatement(1003, 1007, 1);
        s2.executeUpdate("declare global temporary table SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        s2.executeUpdate("insert into session.t2 values(21, 1)");
        s2.executeUpdate("insert into session.t2 values(22, 2)");
        JDBC.assertSingleValueResultSet(s2.executeQuery("select count(*) from SESSION.t2"), "2");
        s2.executeUpdate("declare global temporary table SESSION.t3(c31 int, c32 int) on commit delete rows not logged");
        s2.executeUpdate("insert into session.t3 values(31, 1)");
        s2.executeUpdate("insert into session.t3 values(32, 2)");
        JDBC.assertSingleValueResultSet(s2.executeQuery("select count(*) from SESSION.t3"), "2");
        ResultSet rs23 = s2.executeQuery("select * from SESSION.t2, SESSION.t3 where c22=c32");
        rs23.next();
        Statement s3 = this.getConnection().createStatement(1003, 1007, 1);
        s3.executeUpdate("declare global temporary table SESSION.t4(c41 int, c42 int) on commit delete rows not logged");
        s3.executeUpdate("insert into session.t4 values(41, 1)");
        s3.executeUpdate("insert into session.t4 values(42, 2)");
        ResultSet rs4 = s3.executeQuery("select count(*) from SESSION.t4");
        JDBC.assertSingleValueResultSet(rs4, "2");
        rs4 = s3.executeQuery("select * from SESSION.t4");
        rs4.next();
        rs4.close();
        this.commit();
        JDBC.assertSingleValueResultSet(s1.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(s2.executeQuery("select count(*) from SESSION.t2"), "2");
        JDBC.assertSingleValueResultSet(s2.executeQuery("select count(*) from SESSION.t3"), "2");
        JDBC.assertSingleValueResultSet(s3.executeQuery("select count(*) from SESSION.t4"), "0");
        s1.executeUpdate("drop table SESSION.t1");
        s2.executeUpdate("drop table SESSION.t2");
        s3.executeUpdate("drop table SESSION.t3");
        s3.executeUpdate("drop table SESSION.t4");
        rs1.close();
        rs23.close();
        rs4.close();
        this.commit();
        s1.close();
        s2.close();
        s3.close();
    }

    public void testOnCommitDeleteRowsHoldabilityWithPreparedStatements() throws SQLException {
        Statement s1 = this.createStatement();
        s1.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit delete rows not logged");
        s1.executeUpdate("insert into session.t1 values(11, 1)");
        s1.executeUpdate("insert into session.t1 values(12, 2)");
        PreparedStatement ps1 = this.getConnection().prepareStatement("select count(*) from SESSION.t1", 1003, 1007, 1);
        ResultSet rs1 = ps1.executeQuery();
        JDBC.assertSingleValueResultSet(rs1, "2");
        PreparedStatement ps2 = this.getConnection().prepareStatement("select * from SESSION.t1", 1003, 1007, 1);
        ResultSet rs11 = ps2.executeQuery();
        rs11.next();
        s1.executeUpdate("declare global temporary table SESSION.t2(c21 int, c22 int) on commit delete rows not logged");
        s1.executeUpdate("insert into session.t2 values(21, 1)");
        s1.executeUpdate("insert into session.t2 values(22, 2)");
        PreparedStatement ps3 = this.getConnection().prepareStatement("select count(*) from SESSION.t2", 1003, 1007, 1);
        ResultSet rs2 = ps3.executeQuery();
        JDBC.assertSingleValueResultSet(rs2, "2");
        PreparedStatement ps4 = this.getConnection().prepareStatement("select * from SESSION.t2", 1003, 1007, 1);
        rs2 = ps4.executeQuery();
        rs2.next();
        rs2.close();
        this.commit();
        JDBC.assertSingleValueResultSet(s1.executeQuery("select count(*) from SESSION.t1"), "2");
        rs11.close();
        rs1.close();
        JDBC.assertSingleValueResultSet(s1.executeQuery("select count(*) from SESSION.t2"), "0");
        s1.executeUpdate("drop table SESSION.t1");
        s1.executeUpdate("drop table SESSION.t2");
    }

    public void testOnCommitPreserveRowsWithHoldability() throws SQLException {
        Statement s1 = this.getConnection().createStatement(1003, 1007, 1);
        s1.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged");
        s1.executeUpdate("insert into session.t1 values(11, 1)");
        s1.executeUpdate("insert into session.t1 values(12, 2)");
        JDBC.assertSingleValueResultSet(s1.executeQuery("select count(*) from SESSION.t1"), "2");
        ResultSet rs1 = s1.executeQuery("select * from SESSION.t1");
        rs1.next();
        Statement s2 = this.createStatement();
        s1.executeUpdate("declare global temporary table SESSION.t2(c11 int, c12 int) on commit preserve rows not logged");
        s1.executeUpdate("insert into session.t2 values(11, 1)");
        s1.executeUpdate("insert into session.t2 values(12, 2)");
        JDBC.assertSingleValueResultSet(s2.executeQuery("select count(*) from SESSION.t2"), "2");
        ResultSet rs2 = s2.executeQuery("select * from SESSION.t2");
        rs2.next();
        this.commit();
        JDBC.assertSingleValueResultSet(s1.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(s2.executeQuery("select count(*) from SESSION.t2"), "2");
        s1.executeUpdate("drop table SESSION.t1");
        s2.executeUpdate("drop table SESSION.t2");
    }

    public void testSavepointRollbackbehaviour1() throws SQLException {
        Statement s = this.createStatement();
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged");
        PreparedStatement pStmt = this.prepareStatement("insert into SESSION.t1 values (?, ?)");
        pStmt.setInt(1, 11);
        pStmt.setInt(2, 1);
        pStmt.execute();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "1");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        s.executeUpdate("drop table SESSION.t1");
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", s, "select * from SESSION.t1");
        this.getConnection().rollback(savepoint2);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        this.getConnection().rollback(savepoint1);
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", s, "select * from SESSION.t1");
    }

    public void testSavepointRollbackbehaviour2() throws SQLException {
        Statement s = this.createStatement();
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        s.executeUpdate("declare global temporary table SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        this.getConnection().releaseSavepoint(savepoint1);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "0");
        s.executeUpdate("drop table SESSION.t2");
        this.rollback();
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", s, "select * from SESSION.t1");
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", s, "select * from SESSION.t2");
    }

    public void testSavepointRollbackbehaviour3() throws SQLException {
        Statement s = this.createStatement();
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        s.executeUpdate("declare global temporary table SESSION.t2(c21 int, c22 int) on commit preserve rows  not logged");
        this.getConnection().releaseSavepoint(savepoint1);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "0");
        Savepoint savepoint3 = this.getConnection().setSavepoint();
        this.getConnection().rollback(savepoint3);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "0");
        this.rollback();
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", s, "select * from SESSION.t1");
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", s, "select * from SESSION.t2");
    }

    public void testSavepointRollbackbehaviour4() throws SQLException {
        Statement s = this.createStatement();
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        s.executeUpdate("drop table SESSION.t1");
        this.getConnection().rollback(savepoint2);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        this.commit();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        s.executeUpdate("drop table SESSION.t1");
    }

    public void testSavepointRollbackbehaviour5() throws SQLException {
        Statement s = this.createStatement();
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        s.executeUpdate("drop table SESSION.t1");
        this.getConnection().rollback(savepoint1);
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", s, "select * from SESSION.t1");
    }

    public void testSavepointRollbackbehaviour6() throws SQLException {
        String[] s1 = new String[]{"C11", "C12"};
        String[] s2 = new String[]{"C11", "C12", "C13"};
        Statement s = this.createStatement();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged");
        s.executeUpdate("insert into SESSION.t1 values(11, 11)");
        ResultSet rs1 = s.executeQuery("select * from SESSION.t1");
        JDBC.assertColumnNames(rs1, s1);
        this.getConnection().commit();
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("drop table SESSION.t1");
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int, c13 int not null) on commit preserve rows not logged");
        s.executeUpdate("insert into SESSION.t1 values(22, 22, 22)");
        rs1 = s.executeQuery("select * from SESSION.t1");
        JDBC.assertColumnNames(rs1, s2);
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        s.executeUpdate("drop table SESSION.t1");
        this.rollback();
        rs1 = s.executeQuery("select * from SESSION.t1");
        JDBC.assertColumnNames(rs1, s1);
        s.executeUpdate("drop table SESSION.t1");
    }

    public void testSavepointRollbackbehaviour7() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged");
        s.executeUpdate("insert into SESSION.t1 values(11, 1)");
        s.executeUpdate("insert into session.t2 values(21, 1)");
        this.commit();
        s.executeUpdate("insert into SESSION.t1 values(12, 2)");
        s.executeUpdate("insert into SESSION.t2 values(22, 2)");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "2");
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("UPDATE SESSION.t1 SET c12 = 3 where c12>1");
        s.executeUpdate("UPDATE SESSION.t2 SET c22 = 3 where c22>2");
        this.getConnection().rollback(savepoint1);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "0");
        this.commit();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        s.executeUpdate("drop table SESSION.t1");
        s.executeUpdate("drop table SESSION.t2");
    }

    public void testSavepointRollbackbehaviour8() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows  not logged on rollback delete rows");
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows  not logged on rollback delete rows");
        s.executeUpdate("insert into SESSION.t1 values(11, 1)");
        s.executeUpdate("insert into session.t2 values(21, 1)");
        this.commit();
        s.executeUpdate("insert into SESSION.t1 values(12, 2)");
        s.executeUpdate("insert into session.t2 values(22, 2)");
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("UPDATE SESSION.t1 SET c12 = 3 where c12>1");
        s.executeUpdate("UPDATE SESSION.t2 SET c22 = 3 where c22>3");
        this.getConnection().rollback(savepoint1);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        this.rollback();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        s.executeUpdate("drop table SESSION.t1");
        s.executeUpdate("drop table SESSION.t2");
    }

    public void testSavepointRollbackbehaviour9() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t4(c41 int, c42 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("insert into SESSION.t1 values(11, 1)");
        s.executeUpdate("insert into SESSION.t2 values(21, 1)");
        s.executeUpdate("insert into SESSION.t3 values(31, 1)");
        s.executeUpdate("insert into SESSION.t4 values(41, 1)");
        this.commit();
        s.executeUpdate("insert into SESSION.t1 values(12, 2)");
        s.executeUpdate("insert into session.t2 values(22, 2)");
        s.executeUpdate("insert into session.t3 values(32, 2)");
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("DELETE FROM SESSION.t1 where c12>1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "1");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        s.executeUpdate("DELETE FROM SESSION.t2 where c22>1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "1");
        this.getConnection().releaseSavepoint(savepoint2);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "1");
        this.getConnection().rollback(savepoint1);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t3"), "2");
        this.rollback();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t3"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t4"), "1");
        s.executeUpdate("drop table SESSION.t1");
        s.executeUpdate("drop table SESSION.t2");
        s.executeUpdate("drop table SESSION.t3");
        s.executeUpdate("drop table SESSION.t4");
    }

    public void testSavepointRollbackbehaviour10() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t3(c31 int, c32 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t4(c41 int, c42 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("insert into SESSION.t1 values(11, 1)");
        s.executeUpdate("insert into SESSION.t1 values(12, 2)");
        s.executeUpdate("insert into SESSION.t2 values(21, 1)");
        s.executeUpdate("insert into SESSION.t2 values(22, 2)");
        s.executeUpdate("insert into SESSION.t3 values(31, 1)");
        s.executeUpdate("insert into SESSION.t4 values(41, 1)");
        this.commit();
        s.executeUpdate("insert into SESSION.t3 values(31, 2)");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t3"), "2");
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("DELETE FROM SESSION.t1 where c12>1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "1");
        s.executeUpdate("DELETE FROM SESSION.t2 where c22>3");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "2");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        s.executeUpdate("DELETE FROM SESSION.t2 where c22>1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "1");
        this.rollback();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t3"), "0");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t4"), "1");
        s.executeUpdate("drop table SESSION.t1");
        s.executeUpdate("drop table SESSION.t2");
        s.executeUpdate("drop table SESSION.t3");
        s.executeUpdate("drop table SESSION.t4");
    }

    public void testSavepointRollbackbehaviour11() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) on commit preserve rows not logged on rollback delete rows");
        s.executeUpdate("insert into SESSION.t1 values(11, 1)");
        s.executeUpdate("insert into SESSION.t2 values(21, 1)");
        this.commit();
        s.executeUpdate("insert into SESSION.t1 values(12, 2)");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "2");
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("insert into SESSION.t2 values(22, 2)");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "2");
        this.getConnection().rollback(savepoint1);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "0");
        this.commit();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "0");
        s.executeUpdate("drop table SESSION.t1");
        s.executeUpdate("drop table SESSION.t2");
    }

    public void testSavepointRollbackbehaviour12() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit preserve rows not logged");
        s.executeUpdate("insert into SESSION.t1 values(11, 1)");
        s.executeUpdate("insert into SESSION.t1 values(12, 2)");
        this.commit();
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        s.executeUpdate("insert into SESSION.t1 values(13, 3)");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "3");
        this.getConnection().releaseSavepoint(savepoint1);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "3");
        this.rollback();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t1"), "0");
        s.executeUpdate("drop table SESSION.t1");
    }

    public void testSavepointRollbackbehaviour13() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.t2(c21 int, c22 int) not logged on commit preserve rows");
        PreparedStatement pStmtInsert = this.prepareStatement("insert into SESSION.t2 values (?, ?)");
        pStmtInsert.setInt(1, 21);
        pStmtInsert.setInt(2, 1);
        pStmtInsert.execute();
        pStmtInsert.setInt(1, 22);
        pStmtInsert.setInt(2, 2);
        pStmtInsert.execute();
        pStmtInsert.setInt(1, 23);
        pStmtInsert.setInt(2, 2);
        pStmtInsert.execute();
        PreparedStatement pStmtUpdate = this.prepareStatement("UPDATE SESSION.t2 SET c22 = 3 where c21=?");
        pStmtUpdate.setInt(1, 23);
        pStmtUpdate.execute();
        PreparedStatement pStmtDelete = this.prepareStatement("DELETE FROM SESSION.t2 where c21 = ?");
        pStmtDelete.setInt(1, 23);
        pStmtDelete.execute();
        this.commit();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "2");
        Savepoint savepoint1 = this.getConnection().setSavepoint();
        pStmtInsert.setInt(1, 23);
        pStmtInsert.setInt(2, 2);
        pStmtInsert.execute();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "3");
        Savepoint savepoint2 = this.getConnection().setSavepoint();
        pStmtUpdate.setInt(1, 23);
        pStmtUpdate.execute();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "3");
        this.getConnection().rollback(savepoint2);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "0");
        Savepoint savepoint3 = this.getConnection().setSavepoint();
        pStmtInsert.setInt(1, 21);
        pStmtInsert.setInt(2, 1);
        pStmtInsert.execute();
        pStmtInsert.setInt(1, 22);
        pStmtInsert.setInt(2, 2);
        pStmtInsert.execute();
        pStmtInsert.setInt(1, 23);
        pStmtInsert.setInt(2, 333);
        pStmtInsert.execute();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "3");
        Savepoint savepoint4 = this.getConnection().setSavepoint();
        pStmtUpdate.setInt(1, 23);
        pStmtUpdate.execute();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "3");
        this.getConnection().releaseSavepoint(savepoint4);
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "3");
        pStmtDelete.setInt(1, 23);
        pStmtDelete.execute();
        this.commit();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.t2"), "2");
        s.executeUpdate("drop table SESSION.t2");
    }

    public void testTest4() throws SQLException {
        Statement s1 = this.getConnection().createStatement(1003, 1007, 1);
        try {
            s1.executeUpdate("drop table t1");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaJDBC30Test.assertSQLState("42Y55", e);
        }
        s1.executeUpdate("create table t1(c11 int, c12 int)");
        s1.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit delete rows not logged");
        s1.executeUpdate("insert into session.t1 values(11, 1)");
        s1.executeUpdate("insert into session.t1 values(12, 2)");
        JDBC.assertSingleValueResultSet(s1.executeQuery("select count(*) from SESSION.t1"), "2");
        JDBC.assertSingleValueResultSet(s1.executeQuery("select count(*) from t1"), "0");
        s1.executeUpdate("INSERT INTO T1 SELECT * FROM SESSION.T1");
        this.commit();
        JDBC.assertSingleValueResultSet(s1.executeQuery("select count(*) from SESSION.t1"), "0");
        JDBC.assertSingleValueResultSet(s1.executeQuery("select count(*) from t1"), "2");
        s1.executeUpdate("drop table SESSION.t1");
        s1.executeUpdate("drop table t1");
    }

    public void testPooledConnectionClosed() throws SQLException {
        ConnectionPoolDataSource dscsp = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pc = dscsp.getPooledConnection();
        Connection pcon = pc.getConnection();
        Statement s = pcon.createStatement();
        try {
            s.executeUpdate("CREATE schema SESSION");
        }
        catch (SQLException e) {
            DeclareGlobalTempTableJavaJDBC30Test.assertSQLState("X0Y68", e);
        }
        s.executeUpdate("CREATE TABLE SESSION.tx(c21 int)");
        s.executeUpdate("insert into SESSION.tx values(11)");
        s.executeUpdate("insert into SESSION.tx values(12)");
        s.executeUpdate("insert into SESSION.tx values(13)");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.tx"), "3");
        s.executeUpdate("declare global temporary table SESSION.tx(c11 int, c12 int) on commit preserve rows not logged");
        s.executeUpdate("insert into SESSION.tx values(11,1)");
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.tx"), "1");
        this.commit();
        this.getConnection().close();
        s = this.getConnection().createStatement();
        JDBC.assertSingleValueResultSet(s.executeQuery("select count(*) from SESSION.tx"), "3");
        s.executeUpdate("drop table SESSION.tx");
    }

    public void test_derby_6189() throws Exception {
        Connection conn = this.getConnection();
        conn.prepareStatement("DECLARE GLOBAL TEMPORARY TABLE SESSION.t6189( c21 int, c22 int) not logged on commit preserve rows").execute();
        PreparedStatement pStmtInsert = conn.prepareStatement("insert into SESSION.t6189 values (23, 1)");
        pStmtInsert.execute();
        conn.rollback();
        DeclareGlobalTempTableJavaJDBC30Test.assertStatementError("42X05", pStmtInsert);
    }
}

