/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Changes10_13
extends UpgradeChange {
    private static final String SYNTAX_ERROR = "42X01";
    private static final String UPGRADE_REQUIRED = "XCL47";
    private static final String CANNOT_ALTER_NON_IDENTITY_COLUMN = "42Z29";
    private static final String CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN = "42Z23";
    private static final String NO_SUCH_METHOD_ALIAS = "42Y03";

    public Changes10_13(String name) {
        super(name);
    }

    public static Test suite(int phase) {
        return new BaseTestSuite(Changes10_13.class, "Upgrade test for 10.13");
    }

    public void testAlterTableSetGenerated() throws SQLException {
        Statement s = this.createStatement();
        if (!this.oldAtLeast(10, 1)) {
            return;
        }
        boolean atLeast10_11 = this.oldAtLeast(10, 11);
        switch (this.getPhase()) {
            case 0: {
                s.execute("create table t_always_6882(a int generated always as identity, b int)");
                s.execute("create table t_default_6882(a int generated by default as identity, b int)");
                s.execute("create table t_none_6882(a int, b int)");
                s.execute("insert into t_always_6882(b) values (100)");
                s.execute("insert into t_default_6882(b) values (100)");
                this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into t_always_6882(a, b) values (-1, -100)");
                s.execute("insert into t_default_6882(a, b) values (-1, -100)");
                break;
            }
            case 1: {
                if (atLeast10_11) {
                    this.assertCompileError(CANNOT_ALTER_NON_IDENTITY_COLUMN, "alter table t_none_6882 alter column a set generated by default");
                    s.execute("alter table t_always_6882 alter column a set generated by default");
                    s.execute("alter table t_default_6882 alter column a set generated always");
                    s.execute("insert into t_always_6882(a, b) values (-2, -200)");
                    this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into t_default_6882(a, b) values (-2, -200)");
                    s.execute("insert into t_always_6882(b) values (200)");
                    s.execute("insert into t_default_6882(b) values (200)");
                    JDBC.assertFullResultSet(s.executeQuery("select * from t_always_6882 order by a"), new String[][]{{"-2", "-200"}, {"1", "100"}, {"2", "200"}});
                    JDBC.assertFullResultSet(s.executeQuery("select * from t_default_6882 order by a"), new String[][]{{"-1", "-100"}, {"1", "100"}, {"2", "200"}});
                    break;
                }
                this.assertCompileError(UPGRADE_REQUIRED, "alter table t_none_6882 alter column a set generated by default");
                this.assertCompileError(UPGRADE_REQUIRED, "alter table t_always_6882 alter column a set generated by default");
                this.assertCompileError(UPGRADE_REQUIRED, "alter table t_default_6882 alter column a set generated always");
                break;
            }
            case 3: {
                String[][] defaultResults;
                String[][] alwaysResults;
                this.assertCompileError(CANNOT_ALTER_NON_IDENTITY_COLUMN, "alter table t_none_6882 alter column a set generated by default");
                s.execute("alter table t_always_6882 alter column a set generated always");
                s.execute("alter table t_default_6882 alter column a set generated by default");
                this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into t_always_6882(a, b) values (-3, -300)");
                s.execute("insert into t_default_6882(a, b) values (-3, -300)");
                s.execute("insert into t_always_6882(b) values (300)");
                s.execute("insert into t_default_6882(b) values (300)");
                if (atLeast10_11) {
                    alwaysResults = new String[][]{{"-2", "-200"}, {"1", "100"}, {"2", "200"}, {"3", "300"}};
                    defaultResults = new String[][]{{"-3", "-300"}, {"-1", "-100"}, {"1", "100"}, {"2", "200"}, {"3", "300"}};
                } else {
                    alwaysResults = new String[][]{{"1", "100"}, {"2", "300"}};
                    defaultResults = new String[][]{{"-3", "-300"}, {"-1", "-100"}, {"1", "100"}, {"2", "300"}};
                }
                JDBC.assertFullResultSet(s.executeQuery("select * from t_always_6882 order by a"), alwaysResults);
                JDBC.assertFullResultSet(s.executeQuery("select * from t_default_6882 order by a"), defaultResults);
            }
        }
    }

    public void testDerby6892SkipHeaderLines() throws SQLException {
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                s.execute("create table ex_pet(petName varchar(50), kindOfAnimal varchar(50) , age int)");
                s.execute("create table imp_pet(petName varchar(50), kindOfAnimal varchar(50) , age int)");
                s.execute("insert into ex_pet values('Rover', 'Dog' , 4)");
                s.execute("insert into ex_pet values('Spot', 'Cat' , 2)");
                s.execute("insert into ex_pet values('Squawky','Parrot',37)");
                SupportFilesSetup.deleteFile("pet.dat");
                s.execute("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (null, 'EX_PET', 'pet.dat' , null, null, null) ");
                this.assertCompileError(NO_SUCH_METHOD_ALIAS, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE_BULK(null, 'IMP_PET' , 'pet.dat' , null, null, null, 0 , 1) ");
                break;
            }
            case 1: {
                this.assertCompileError(NO_SUCH_METHOD_ALIAS, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE_BULK(null, 'IMP_PET', 'pet.dat' , null, null, null, 0 , 1) ");
                break;
            }
            case 2: {
                this.assertCompileError(NO_SUCH_METHOD_ALIAS, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE_BULK(null, 'IMP_PET', 'pet.dat' , null, null, null, 0 , 1) ");
                break;
            }
            case 3: {
                s.execute("delete from imp_pet");
                s.execute("call SYSCS_UTIL.SYSCS_IMPORT_TABLE_BULK(null, 'IMP_PET', 'pet.dat', null, null, null, 0, 1)");
                JDBC.assertFullResultSet(s.executeQuery("select * from IMP_PET"), new String[][]{{"Spot", "Cat", "2"}, {"Squawky", "Parrot", "37"}});
            }
        }
    }

    public void testDerby6893SkipHeaderLines() throws SQLException {
        Statement s = this.createStatement();
        switch (this.getPhase()) {
            case 0: {
                s.execute("create table exp_pet(petName varchar(50), kindOfAnimal varchar(50) , age int)");
                s.execute("create table im_pet(petName varchar(50), kindOfAnimal varchar(50) , age int)");
                s.execute("insert into exp_pet values('Rover', 'Dog' , 4)");
                s.execute("insert into exp_pet values('Spot', 'Cat' , 2)");
                s.execute("insert into exp_pet values('Squawky','Parrot',37)");
                SupportFilesSetup.deleteFile("pet.dat");
                s.execute("call SYSCS_UTIL.SYSCS_EXPORT_TABLE(null, 'EXP_PET', 'pet.dat' , null, null, null) ");
                this.assertCompileError(NO_SUCH_METHOD_ALIAS, "call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'IM_PET', null, '1,2,3',  'pet.dat' , null, null, null, 0 , 1) ");
                break;
            }
            case 1: {
                this.assertCompileError(NO_SUCH_METHOD_ALIAS, "call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'IM_PET', null, '1,2,3',  'pet.dat' , null, null, null, 0 , 1) ");
                break;
            }
            case 2: {
                this.assertCompileError(NO_SUCH_METHOD_ALIAS, "call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'IM_PET', null, '1,2,3',  'pet.dat' , null, null, null, 0 , 1) ");
                break;
            }
            case 3: {
                s.execute("delete from im_pet");
                s.execute("call SYSCS_UTIL.SYSCS_IMPORT_DATA_BULK(null, 'IM_PET', null, '1,2,3',  'pet.dat' , null, null, null, 0 , 1) ");
                JDBC.assertFullResultSet(s.executeQuery("select * from IM_PET"), new String[][]{{"Spot", "Cat", "2"}, {"Squawky", "Parrot", "37"}});
            }
        }
    }
}

