/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Wrapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetListener;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class VerifySignatures
extends BaseTestCase {
    private static final Class[] JDBC_INTERFACES = new Class[]{Array.class, Blob.class, CallableStatement.class, Clob.class, Connection.class, DatabaseMetaData.class, Driver.class, NClob.class, ParameterMetaData.class, PreparedStatement.class, Ref.class, ResultSet.class, ResultSetMetaData.class, RowId.class, Savepoint.class, SQLData.class, SQLInput.class, SQLOutput.class, SQLXML.class, Statement.class, Struct.class, Wrapper.class, CommonDataSource.class, ConnectionEventListener.class, ConnectionPoolDataSource.class, DataSource.class, PooledConnection.class, RowSet.class, RowSetInternal.class, RowSetListener.class, RowSetMetaData.class, RowSetReader.class, RowSetWriter.class, StatementEventListener.class, XAConnection.class, XADataSource.class};

    public VerifySignatures(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(VerifySignatures.class);
    }

    public void testAllJDBCObjects() throws NoSuchMethodException, SQLException {
        HashSet<ClassInfo> hashSet = new HashSet<ClassInfo>();
        VerifySignatures.collectClassesFromDataSource(hashSet);
        VerifySignatures.collectClassesFromConnectionPoolDataSource(hashSet);
        VerifySignatures.collectClassesFromXADataSource(hashSet);
        VerifySignatures.addClass(hashSet, DriverManager.getDriver(TestConfiguration.getCurrent().getJDBCUrl()).getClass(), Driver.class);
        HashSet<Class> hashSet2 = new HashSet<Class>();
        for (ClassInfo classInfo : hashSet) {
            HashSet<Method> hashSet3 = new HashSet<Method>();
            for (Class clazz : VerifySignatures.getAllInterfaces(classInfo.jdbcInterface)) {
                hashSet2.add(clazz);
                for (Method method : clazz.getMethods()) {
                    hashSet3.add(method);
                }
            }
            for (Method method : hashSet3) {
                VerifySignatures.checkImplementationMethod(classInfo.derbyImplementation, method);
            }
        }
        Set<Class> set = VerifySignatures.getInterfacesToCheck();
        set.removeAll(hashSet2);
        VerifySignatures.assertTrue((String)("Unchecked interfaces: " + String.valueOf(set)), (boolean)set.isEmpty());
    }

    private static void collectClassesFromDataSource(Set<ClassInfo> set) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "create=true");
        VerifySignatures.addClass(set, dataSource.getClass(), DataSource.class);
        VerifySignatures.collectClassesFromConnection(dataSource.getConnection(TestConfiguration.getCurrent().getUserName(), TestConfiguration.getCurrent().getUserPassword()), set);
    }

    private static void collectClassesFromConnectionPoolDataSource(Set<ClassInfo> set) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        VerifySignatures.addClass(set, connectionPoolDataSource.getClass(), ConnectionPoolDataSource.class);
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection(TestConfiguration.getCurrent().getUserName(), TestConfiguration.getCurrent().getUserPassword());
        VerifySignatures.addClass(set, pooledConnection.getClass(), PooledConnection.class);
        VerifySignatures.collectClassesFromConnection(pooledConnection.getConnection(), set);
        pooledConnection.close();
    }

    private static void collectClassesFromXADataSource(Set<ClassInfo> set) throws SQLException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        VerifySignatures.addClass(set, xADataSource.getClass(), XADataSource.class);
        XAConnection xAConnection = xADataSource.getXAConnection(TestConfiguration.getCurrent().getUserName(), TestConfiguration.getCurrent().getUserPassword());
        VerifySignatures.addClass(set, xAConnection.getClass(), XAConnection.class);
        VerifySignatures.collectClassesFromConnection(xAConnection.getConnection(), set);
    }

    private static void collectClassesFromConnection(Connection connection, Set<ClassInfo> set) throws SQLException {
        connection.setAutoCommit(false);
        VerifySignatures.addClass(set, connection.getClass(), Connection.class);
        Savepoint savepoint = connection.setSavepoint();
        VerifySignatures.addClass(set, savepoint.getClass(), Savepoint.class);
        connection.releaseSavepoint(savepoint);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        VerifySignatures.addClass(set, databaseMetaData.getClass(), DatabaseMetaData.class);
        VerifySignatures.collectClassesFromStatement(connection, set);
        VerifySignatures.collectClassesFromPreparedStatement(connection, set);
        VerifySignatures.collectClassesFromCallableStatement(connection, set);
        connection.rollback();
        connection.close();
    }

    private static void collectClassesFromStatement(Connection connection, Set<ClassInfo> set) throws SQLException {
        Statement statement = connection.createStatement();
        VerifySignatures.addClass(set, statement.getClass(), Statement.class);
        statement.execute("CREATE TABLE t (id INT PRIMARY KEY, b BLOB(10), c CLOB(10))");
        statement.execute("INSERT INTO t (id, b, c) VALUES (1, CAST (" + TestUtil.stringToHexLiteral("101010001101") + "AS BLOB(10)), CAST ('hello' AS CLOB(10)))");
        ResultSet resultSet = statement.executeQuery("SELECT id, b, c FROM t");
        VerifySignatures.addClass(set, resultSet.getClass(), ResultSet.class);
        resultSet.next();
        Blob blob = resultSet.getBlob(2);
        VerifySignatures.addClass(set, blob.getClass(), Blob.class);
        Clob clob = resultSet.getClob(3);
        VerifySignatures.addClass(set, clob.getClass(), Clob.class);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        VerifySignatures.addClass(set, resultSetMetaData.getClass(), ResultSetMetaData.class);
        resultSet.close();
        statement.close();
        connection.rollback();
    }

    private static void collectClassesFromPreparedStatement(Connection connection, Set<ClassInfo> set) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("VALUES(1)");
        VerifySignatures.addClass(set, preparedStatement.getClass(), PreparedStatement.class);
        ResultSet resultSet = preparedStatement.executeQuery();
        VerifySignatures.addClass(set, resultSet.getClass(), ResultSet.class);
        resultSet.close();
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        VerifySignatures.addClass(set, parameterMetaData.getClass(), ParameterMetaData.class);
        preparedStatement.close();
    }

    private static void collectClassesFromCallableStatement(Connection connection, Set<ClassInfo> set) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        VerifySignatures.addClass(set, callableStatement.getClass(), CallableStatement.class);
        ParameterMetaData parameterMetaData = callableStatement.getParameterMetaData();
        VerifySignatures.addClass(set, parameterMetaData.getClass(), ParameterMetaData.class);
        callableStatement.close();
    }

    private static void addClass(Set<ClassInfo> set, Class clazz, Class clazz2) {
        set.add(new ClassInfo(clazz, clazz2));
    }

    private static Set<Class> getAllInterfaces(Class clazz) {
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(clazz);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            hashSet.add(clazz2);
            hashSet.addAll(VerifySignatures.getAllInterfaces(clazz2));
        }
        return hashSet;
    }

    private static void checkImplementationMethod(Class<?> clazz, Method method) throws NoSuchMethodException {
        int n;
        VerifySignatures.assertFalse((String)"Implementation class is interface", (boolean)clazz.isInterface());
        Method method2 = clazz.getMethod(method.getName(), method.getParameterTypes());
        StringBuilder stringBuilder = new StringBuilder();
        Class<?>[] classArray = method.getParameterTypes();
        stringBuilder.append("(");
        for (n = 0; n < classArray.length; ++n) {
            stringBuilder.append(classArray[n].getName());
            if (n >= classArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        VerifySignatures.assertEquals((String)("Incorrect return type for " + method.getName() + stringBuilder.toString()), method.getReturnType(), method2.getReturnType());
        n = method2.getModifiers();
        VerifySignatures.assertTrue((String)"Non-public method", (boolean)Modifier.isPublic(n));
        VerifySignatures.assertFalse((String)"Abstract method", (boolean)Modifier.isAbstract(n));
        VerifySignatures.assertFalse((String)"Static method", (boolean)Modifier.isStatic(n));
        Class[] classArray2 = method.getExceptionTypes();
        for (Class<?> clazz2 : method2.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(clazz2)) continue;
            VerifySignatures.assertNotNull((String)"Incompatible throws clause", (Object)VerifySignatures.findCompatibleClass(clazz2, classArray2));
        }
    }

    private static Class findCompatibleClass(Class clazz, Class[] classArray) {
        for (Class clazz2 : classArray) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return clazz2;
        }
        return null;
    }

    private static Set<Class> getInterfacesToCheck() {
        HashSet<Class> hashSet = new HashSet<Class>(Arrays.asList(JDBC_INTERFACES));
        hashSet.remove(Array.class);
        hashSet.remove(NClob.class);
        hashSet.remove(Ref.class);
        hashSet.remove(SQLData.class);
        hashSet.remove(SQLInput.class);
        hashSet.remove(SQLOutput.class);
        hashSet.remove(SQLXML.class);
        hashSet.remove(Struct.class);
        hashSet.remove(RowSet.class);
        hashSet.remove(RowSetInternal.class);
        hashSet.remove(RowSetListener.class);
        hashSet.remove(RowSetMetaData.class);
        hashSet.remove(RowSetReader.class);
        hashSet.remove(RowSetWriter.class);
        hashSet.remove(RowId.class);
        hashSet.remove(ConnectionEventListener.class);
        hashSet.remove(StatementEventListener.class);
        return hashSet;
    }

    private static class ClassInfo {
        Class derbyImplementation;
        Class jdbcInterface;

        ClassInfo(Class clazz, Class clazz2) {
            this.derbyImplementation = clazz;
            this.jdbcInterface = clazz2;
        }

        public boolean equals(Object object) {
            if (object instanceof ClassInfo) {
                ClassInfo classInfo = (ClassInfo)object;
                return this.derbyImplementation.equals(classInfo.derbyImplementation) && this.jdbcInterface.equals(classInfo.jdbcInterface);
            }
            return false;
        }

        public int hashCode() {
            return this.derbyImplementation.hashCode() ^ this.jdbcInterface.hashCode();
        }
    }
}

