/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.sql.DataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.ConcurrentAutoloadTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.JDBCDriversAllTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.JDBCDriversClientTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.JDBCDriversEmbeddedTest;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AutoloadTest
extends BaseJDBCTestCase {
    private Class<?> spawnedTestClass;

    public AutoloadTest(String string) {
        super(string);
    }

    private AutoloadTest(Class<?> clazz) {
        this("spawnProcess");
        this.spawnedTestClass = clazz;
    }

    public String getName() {
        Object object = super.getName();
        if (this.spawnedTestClass != null) {
            object = (String)object + ":" + this.spawnedTestClass.getSimpleName();
        }
        return object;
    }

    public static Test suite() {
        String string;
        if (!JDBC.vmSupportsJDBC3()) {
            return new BaseTestSuite("empty: no java.sql.DriverManager");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (JDBC.vmSupportsJDBC4() && TestConfiguration.loadingFromJars()) {
            bl3 = true;
        }
        if ((string = AutoloadTest.getSystemProperty("jdbc.drivers")) == null) {
            string = "";
        }
        bl = string.contains("org.apache.derby.jdbc.EmbeddedDriver");
        bl2 = string.contains("org.apache.derby.jdbc.ClientDriver");
        if (bl3 || bl || bl2) {
            BaseTestSuite baseTestSuite = new BaseTestSuite("AutoloadTest");
            if (bl3 && !bl) {
                baseTestSuite.addTest((Test)new AutoloadTest("testEmbeddedNotStarted"));
            }
            if (bl3 || bl) {
                baseTestSuite.addTest(AutoloadTest.baseAutoLoadSuite("embedded"));
            }
            if (bl3 || bl2) {
                baseTestSuite.addTest(TestConfiguration.clientServerDecorator(AutoloadTest.baseAutoLoadSuite("client")));
            }
            if (bl3 || bl) {
                baseTestSuite.addTest((Test)new AutoloadTest("testAssertShutdownOK"));
                baseTestSuite.addTest((Test)new AutoloadTest("testShutdownDeRegister"));
                baseTestSuite.addTest((Test)new AutoloadTest("testExplicitReload"));
            }
            return baseTestSuite;
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("AutoloadTest: no autoloading expected");
        baseTestSuite.addTest((Test)new AutoloadTest("testEmbeddedNotStarted"));
        baseTestSuite.addTest((Test)new AutoloadTest("noloadTestNodriverLoaded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)new AutoloadTest("noloadTestNodriverLoaded")));
        return baseTestSuite;
    }

    private static Test baseAutoLoadSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("AutoloadTest: " + string);
        baseTestSuite.addTest((Test)new AutoloadTest("testRegisteredDriver"));
        if ("embedded".equals(string) && Derby.hasServer()) {
            baseTestSuite.addTest((Test)new AutoloadTest("testAutoNetworkServerBoot"));
        }
        baseTestSuite.addTest((Test)new AutoloadTest("testSuccessfulConnect"));
        if ("embedded".equals(string)) {
            baseTestSuite.addTest((Test)new AutoloadTest("testEmbeddedStarted"));
        }
        baseTestSuite.addTest((Test)new AutoloadTest("testUnsuccessfulConnect"));
        baseTestSuite.addTest((Test)new AutoloadTest("testExplicitLoad"));
        if ("embedded".equals(string)) {
            baseTestSuite.addTest((Test)new AutoloadTest("testAutoloadDriverUnregister"));
        }
        return baseTestSuite;
    }

    static Test fullAutoloadSuite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("AutoloadTest:All");
        baseTestSuite.addTest((Test)new AutoloadTest(AutoloadTest.class));
        baseTestSuite.addTest((Test)new AutoloadTest(JDBCDriversEmbeddedTest.class));
        baseTestSuite.addTest((Test)new AutoloadTest(JDBCDriversClientTest.class));
        baseTestSuite.addTest((Test)new AutoloadTest(JDBCDriversAllTest.class));
        baseTestSuite.addTest((Test)new AutoloadTest(ConcurrentAutoloadTest.class));
        return new TestSetup((Test)baseTestSuite){

            protected void setUp() {
                TestConfiguration.getCurrent().shutdownEngine();
            }
        };
    }

    public void spawnProcess() throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("-Dderby.system.durability=" + AutoloadTest.getSystemProperty("derby.system.durability"));
        arrayList.add("-Dderby.tests.trace=" + AutoloadTest.getSystemProperty("derby.tests.trace"));
        arrayList.add("-Dderby.system.debug=" + AutoloadTest.getSystemProperty("derby.tests.debug"));
        if (!TestConfiguration.isDefaultBasePort()) {
            arrayList.add("-Dderby.tests.basePort=" + TestConfiguration.getBasePort());
        }
        arrayList.add("junit.textui.TestRunner");
        arrayList.add(this.spawnedTestClass.getName());
        String[] stringArray = arrayList.toArray(new String[0]);
        SpawnedProcess spawnedProcess = new SpawnedProcess(AutoloadTest.execJavaCmd(stringArray), this.spawnedTestClass.getName());
        spawnedProcess.suppressOutputOnComplete();
        boolean bl = spawnedProcess.waitForExit(120000L, 1000L);
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            stringBuilder.append("\n\n\n[Subprocess ");
            stringBuilder.append(spawnedProcess.getPid());
            stringBuilder.append(" hanging, jstack result:");
            stringBuilder.append(spawnedProcess.jstack());
            stringBuilder.append("End of jstack output]\n\n");
        }
        int n = spawnedProcess.complete(0L);
        String string = spawnedProcess.getFullServerOutput();
        String string2 = spawnedProcess.getFullServerError();
        String string3 = "\n[ (stdout subprocess) ".replace("out", "err");
        String string4 = "\n[ (stdout subprocess) ".replace('[', ' ');
        String string5 = string4.replace("out", "err");
        if (n != 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("subprocess run failed: exit code==");
            stringBuilder2.append(n);
            stringBuilder2.append("\n");
            stringBuilder2.append("\n[ (stdout subprocess) ");
            stringBuilder2.append(string.replaceAll("\n", string4));
            stringBuilder2.append("]\n");
            stringBuilder2.append(string3);
            stringBuilder2.append(string2.replaceAll("\n", string5));
            stringBuilder2.append("]\n");
            stringBuilder2.append((CharSequence)stringBuilder);
            AutoloadTest.fail((String)stringBuilder2.toString());
        }
        if (Boolean.parseBoolean(AutoloadTest.getSystemProperty("derby.tests.trace")) || Boolean.parseBoolean(AutoloadTest.getSystemProperty("derby.tests.debug"))) {
            System.out.println("\n[ (stdout subprocess) " + string.replace("\n", string4) + "]\n");
            System.out.println(string3 + string2.replace("\n", string5) + "]\n");
        }
    }

    public void testAutoloadDriverUnregister() throws Exception {
        if (AutoloadTest.usingEmbedded()) {
            String string = this.getAutoloadedDriverName();
            String string2 = "org.apache.derby.jdbc.Driver40";
            String string3 = "org.apache.derby.jdbc.Driver30";
            String string4 = "org.apache.derby.jdbc.Driver20";
            String string5 = this.getTestConfiguration().getJDBCUrl();
            string5 = string5.concat(";create=true");
            String string6 = this.getTestConfiguration().getUserName();
            String string7 = this.getTestConfiguration().getUserPassword();
            DriverManager.getConnection(string5, string6, string7);
            AutoloadTest.assertTrue((boolean)this.getRegisteredDrivers(string));
            TestConfiguration.getCurrent().shutdownEngine();
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(string));
            String string8 = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
            Class<?> clazz = Class.forName(string8);
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            string5 = this.getTestConfiguration().getJDBCUrl();
            string6 = this.getTestConfiguration().getUserName();
            string7 = this.getTestConfiguration().getUserPassword();
            DriverManager.getConnection(string5, string6, string7);
            AutoloadTest.assertTrue((boolean)this.getRegisteredDrivers(string));
            TestConfiguration.getCurrent().shutdownEngine();
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(string));
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(string2));
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(string3));
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(string4));
        }
    }

    private String getAutoloadedDriverName() {
        return "org.apache.derby.iapi.jdbc.AutoloadedDriver";
    }

    private String getClientDriverName() {
        return "org.apache.derby.client.ClientAutoloadedDriver";
    }

    public void testRegisteredDriver() throws SQLException {
        String string = this.getTestConfiguration().getJDBCClient().getUrlBase();
        AutoloadTest.println("Test case '" + this.getName() + "'. Looking up driver for protocol " + string);
        Driver driver = DriverManager.getDriver(string);
        AutoloadTest.assertNotNull((String)"Expected registered driver", (Object)driver);
    }

    public void testShutdownDeRegister() throws SQLException {
        AutoloadTest.assertTrue((boolean)this.isEmbeddedDriverRegistered());
        TestConfiguration.getCurrent().shutdownEngine();
        AutoloadTest.assertFalse((boolean)this.isEmbeddedDriverRegistered());
    }

    private boolean isEmbeddedDriverRegistered() {
        String string = this.getClientDriverName();
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            Driver driver = enumeration.nextElement();
            String string2 = driver.getClass().getName();
            if (!string2.startsWith("org.apache.derby.") || string2.equals(string)) continue;
            AutoloadTest.println("Found " + string2);
            return true;
        }
        return false;
    }

    public void testSuccessfulConnect() throws SQLException {
        AutoloadTest.println("We ARE autoloading...");
        String string = this.getTestConfiguration().getJDBCUrl();
        string = string.concat(";create=true");
        String string2 = this.getTestConfiguration().getUserName();
        String string3 = this.getTestConfiguration().getUserPassword();
        DriverManager.getConnection(string, string2, string3).close();
    }

    public void testUnsuccessfulConnect() throws SQLException {
        String string = this.getTestConfiguration().getJDBCUrl("nonexistentDatabase");
        String string2 = this.getTestConfiguration().getUserName();
        String string3 = this.getTestConfiguration().getUserPassword();
        try {
            DriverManager.getConnection(string, string2, string3).close();
            AutoloadTest.fail((String)"connected to nonexistentDatabase");
        }
        catch (SQLException sQLException) {
            String string4 = AutoloadTest.usingEmbedded() ? "XJ004" : "08004";
            AutoloadTest.assertSQLState(string4, sQLException);
        }
    }

    public void testExplicitLoad() throws Exception {
        this.explicitLoad(false);
    }

    public void testExplicitReload() throws Exception {
        this.explicitLoad(true);
    }

    private void explicitLoad(boolean bl) throws Exception {
        String string = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
        if (!bl) {
            Class.forName(string);
            this.testSuccessfulConnect();
            this.testUnsuccessfulConnect();
        }
        Class<?> clazz = Class.forName(string);
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.testSuccessfulConnect();
        this.testUnsuccessfulConnect();
    }

    public void noloadTestNodriverLoaded() {
        try {
            this.testRegisteredDriver();
            AutoloadTest.fail((String)"Derby junit setup code is loading driver!");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testAutoNetworkServerBoot() throws Exception {
        boolean bl = "true".equalsIgnoreCase(AutoloadTest.getSystemProperty("derby.drda.startNetworkServer"));
        boolean bl2 = bl && this.fullEngineAutoBoot();
        String string = this.getTestConfiguration().getUserName();
        String string2 = this.getTestConfiguration().getUserPassword();
        int n = TestConfiguration.getBasePort();
        InetAddress inetAddress = InetAddress.getByName(TestConfiguration.getCurrent().getHostName());
        NetworkServerControl networkServerControl = new NetworkServerControl(inetAddress, n, string, string2);
        if (!bl2) {
            Thread.sleep(5000L);
        }
        boolean bl3 = NetworkServerTestSetup.pingForServerUp(networkServerControl, null, bl2);
        AutoloadTest.assertEquals((String)"Network Server state incorrect", (boolean)bl2, (boolean)bl3);
        if (bl3) {
            networkServerControl.shutdown();
        }
    }

    private boolean fullEngineAutoBoot() {
        String string = AutoloadTest.getSystemProperty("jdbc.drivers");
        return string.contains("org.apache.derby.jdbc.EmbeddedDriver");
    }

    public void testEmbeddedNotStarted() {
        AutoloadTest.assertFalse((boolean)this.hasDerbyThreadGroup());
    }

    public void testEmbeddedStarted() {
        AutoloadTest.assertTrue((boolean)this.hasDerbyThreadGroup());
    }

    private boolean getRegisteredDrivers(String string) {
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            Driver driver = enumeration.nextElement();
            if (!driver.getClass().getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void testAssertShutdownOK() throws SQLException {
        String string = this.getAutoloadedDriverName();
        Connection connection = this.getConnection();
        if (AutoloadTest.usingEmbedded()) {
            DataSource dataSource = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(dataSource, "shutdownDatabase", "shutdown");
            try {
                dataSource.getConnection();
                AutoloadTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException sQLException) {
                AutoloadTest.assertSQLState("08006", sQLException);
            }
            AutoloadTest.assertTrue((boolean)connection.isClosed());
        } else if (AutoloadTest.usingDerbyNetClient()) {
            DataSource dataSource = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "shutdown=true;deregiste=false");
            try {
                dataSource.getConnection();
                AutoloadTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException sQLException) {
                AutoloadTest.assertSQLState("08006", sQLException);
            }
            JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "shutdown=true;deregister=false");
            try {
                dataSource.getConnection();
                AutoloadTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException sQLException) {
                AutoloadTest.assertSQLState("08006", sQLException);
            }
            AutoloadTest.assertTrue((boolean)this.getRegisteredDrivers(string));
            String string2 = this.getTestConfiguration().getJDBCUrl();
            connection = DriverManager.getConnection(string2);
            Statement statement = connection.createStatement();
            statement.executeUpdate("values 1");
            JDBCDataSource.setBeanProperty(dataSource, "connectonAttributes", "shutdown=true;deregister=true");
            try {
                dataSource.getConnection();
                AutoloadTest.fail((String)"expected shutdown to fail");
            }
            catch (SQLException sQLException) {
                AutoloadTest.assertSQLState("08006", sQLException);
            }
            AutoloadTest.assertFalse((boolean)this.getRegisteredDrivers(string));
        }
    }

    private boolean hasDerbyThreadGroup() {
        int n;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        ThreadGroup[] threadGroupArray = new ThreadGroup[threadGroup.activeGroupCount()];
        while ((n = threadGroup.enumerate(threadGroupArray, true)) >= threadGroupArray.length) {
            threadGroupArray = new ThreadGroup[threadGroupArray.length * 2];
        }
        for (int i = 0; i < n; ++i) {
            if (!threadGroupArray[i].getName().startsWith("derby.")) continue;
            return true;
        }
        return false;
    }
}

