/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.TestInputStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;

public final class BLOBDataModelSetup
extends BaseJDBCTestSetup {
    static final int size = 0x100000;
    static final int regularBlobs = 10;
    static final int bigSize = 0x4000000;
    static final int bigVal = 11;
    private static final String tableName = "TESTBLOBTABLE";

    public BLOBDataModelSetup(Test test) {
        super(test);
    }

    protected final void setUp() throws Exception {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE TESTBLOBTABLE ( val INTEGER, length INTEGER,  data BLOB(2G) NOT NULL)");
        statement.close();
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO TESTBLOBTABLE(val, length, data) VALUES (?,?, ?)");
        int n = 0;
        while (n < 10) {
            int n2 = n++;
            TestInputStream testInputStream = new TestInputStream(0x100000L, n2);
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, 0x100000);
            preparedStatement.setBinaryStream(3, (InputStream)testInputStream, 0x100000);
            preparedStatement.executeUpdate();
        }
        BaseJDBCTestCase.println("Insert BLOB with size = 67108864");
        preparedStatement.setInt(1, 11);
        preparedStatement.setInt(2, 0x4000000);
        TestInputStream testInputStream = new TestInputStream(0x4000000L, 11);
        preparedStatement.setBinaryStream(3, (InputStream)testInputStream, 0x4000000);
        BaseJDBCTestCase.println("Execute update");
        preparedStatement.executeUpdate();
        preparedStatement.close();
        BaseJDBCTestCase.println("Commit");
        connection.commit();
    }

    @Override
    protected final void tearDown() throws Exception {
        try {
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            statement.execute("DROP TABLE TESTBLOBTABLE");
            statement.close();
            connection.commit();
        }
        catch (SQLException sQLException) {
            BaseJDBCTestCase.printStackTrace(sQLException);
        }
        super.tearDown();
    }

    public static final String getBlobTableName() {
        return tableName;
    }
}

