/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SetTransactionIsolationTest
extends BaseJDBCTestCase {
    public static int[] isoLevels = new int[]{1, 4, 2, 8};

    public SetTransactionIsolationTest(String string) {
        super(string);
    }

    public void testIsolation() throws SQLException {
        Connection connection = this.getConnection();
        Connection connection2 = this.openDefaultConnection();
        connection.setAutoCommit(false);
        for (int i = 0; i < isoLevels.length; ++i) {
            this.checkIsolationLevelNoTimeout(connection, isoLevels[i]);
        }
        Statement statement = connection.createStatement();
        statement.executeUpdate("insert into t1 values(4,'Fourth Hello')");
        for (int i = 0; i < isoLevels.length; ++i) {
            this.checkIsolationLevelTimeout(connection2, isoLevels[i]);
        }
        statement.close();
        connection.rollback();
    }

    private void checkIsolationLevelTimeout(Connection connection, int n) throws SQLException {
        block5: {
            RuntimeStatisticsParser runtimeStatisticsParser;
            block4: {
                runtimeStatisticsParser = null;
                connection.setTransactionIsolation(n);
                try {
                    runtimeStatisticsParser = SQLUtilities.executeAndGetRuntimeStatistics(connection, "select * from t1");
                    SetTransactionIsolationTest.assertEquals((int)1, (int)runtimeStatisticsParser.getIsolationLevel());
                }
                catch (SQLException sQLException) {
                    if (n == 1) break block4;
                    SetTransactionIsolationTest.assertSQLState("expected lock timeout", "40XL1", sQLException);
                }
            }
            try {
                runtimeStatisticsParser = SQLUtilities.executeAndGetRuntimeStatistics(connection, "insert into t1copy (select * from t1)");
                SetTransactionIsolationTest.assertEquals((int)1, (int)runtimeStatisticsParser.getIsolationLevel());
            }
            catch (SQLException sQLException) {
                if (n == 1) break block5;
                SetTransactionIsolationTest.assertSQLState("expected lock timeout", "40XL1", sQLException);
            }
        }
    }

    private void checkIsolationLevelNoTimeout(Connection connection, int n) throws SQLException {
        connection.setTransactionIsolation(n);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.executeAndGetRuntimeStatistics(connection, "select * from t1");
        SetTransactionIsolationTest.assertEquals((int)n, (int)runtimeStatisticsParser.getIsolationLevel());
        runtimeStatisticsParser = SQLUtilities.executeAndGetRuntimeStatistics(connection, "insert into t1copy (select * from t1)");
        SetTransactionIsolationTest.assertEquals((int)n, (int)runtimeStatisticsParser.getIsolationLevel());
    }

    public void testSetTransactionIsolationCommitRollback() throws SQLException {
        Connection connection = this.getConnection();
        connection.rollback();
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(8);
        Statement statement = connection.createStatement();
        statement.executeUpdate("delete from t3");
        statement.executeUpdate("insert into t3 values(1)");
        connection.commit();
        statement.executeUpdate("insert into t3 values(2)");
        connection.setTransactionIsolation(8);
        connection.rollback();
        ResultSet resultSet = statement.executeQuery("select count(*) from t3");
        resultSet.next();
        int n = resultSet.getInt(1);
        SetTransactionIsolationTest.assertEquals((int)1, (int)n);
        resultSet.close();
        statement.close();
    }

    public void testSetTransactionIsolationInHoldCursor() throws SQLException {
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * from TAB1");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            connection.setTransactionIsolation(8);
            resultSet.next();
        }
        catch (SQLException sQLException) {
            SetTransactionIsolationTest.assertSQLState("Expected Exception if held cursor is open", "X0X03", sQLException);
            return;
        }
        SetTransactionIsolationTest.fail((String)"FAIL: setTransactionIsolation() did not throw exception with open hold cursor");
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(SetTransactionIsolationTest.class);
        Test test = DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 1, 3);
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                int n;
                Connection connection = this.getConnection();
                statement.executeUpdate("CREATE TABLE TAB1 (c11 int, c12 varchar(400))");
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO TAB1 VALUES(?,?)");
                StringBuffer stringBuffer = new StringBuffer(400);
                for (n = 0; n < 400; ++n) {
                    stringBuffer.append(" ");
                }
                for (n = 1; n <= 100; ++n) {
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, stringBuffer.toString());
                    preparedStatement.executeUpdate();
                }
                preparedStatement.close();
                statement.execute("create table t1(I int, B char(15))");
                statement.execute("create table t1copy(I int, B char(15))");
                statement.executeUpdate("INSERT INTO T1 VALUES(1,'First Hello')");
                statement.executeUpdate("INSERT INTO T1 VALUES(2,'Second Hello')");
                statement.executeUpdate("INSERT INTO T1 VALUES(3,'Third Hello')");
                statement.executeUpdate("create table t3 (i integer)");
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SetTransactionIsolation");
        baseTestSuite.addTest(SetTransactionIsolationTest.baseSuite("SetTransactionIsolation:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(SetTransactionIsolationTest.baseSuite("SetTransactionIsolation:client")));
        return baseTestSuite;
    }
}

