/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class DBInJarTest
extends BaseJDBCTestCase {
    public DBInJarTest(String string) {
        super(string);
    }

    public void testConnectDBInJar() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:derby:testjardb;create=true");
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE TAB (I INT)");
        statement.executeUpdate("INSERT INTO TAB VALUES(1)");
        this.shutdownDB("jdbc:derby:testjardb;shutdown=true");
        Statement statement2 = this.createStatement();
        statement2.executeUpdate("CALL CREATEARCHIVE('testjardb.jar', 'testjardb','testjardb')");
        Connection connection2 = DriverManager.getConnection("jdbc:derby:jar:(testjardb.jar)testjardb");
        Statement statement3 = connection2.createStatement();
        ResultSet resultSet = statement3.executeQuery("SELECT * from TAB");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        resultSet = connection2.getMetaData().getSchemas();
        String[][] stringArray = new String[][]{{"APP", null}, {"NULLID", null}, {"SQLJ", null}, {"SYS", null}, {"SYSCAT", null}, {"SYSCS_DIAG", null}, {"SYSCS_UTIL", null}, {"SYSFUN", null}, {"SYSIBM", null}, {"SYSPROC", null}, {"SYSSTAT", null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        this.shutdownDB("jdbc:derby:jar:(testjardb.jar)testjardb;shutdown=true");
        File file = new File(System.getProperty("derby.system.home") + "/testjardb.jar");
        DBInJarTest.assertTrue((String)("failed deleting " + file.getPath()), (boolean)file.delete());
        DBInJarTest.removeDirectory(new File(System.getProperty("derby.system.home") + "/testjardb"));
    }

    private void shutdownDB(String string) {
        try {
            DriverManager.getConnection(string);
            DBInJarTest.fail((String)"Expected exception on shutdown");
        }
        catch (SQLException sQLException) {
            DBInJarTest.assertSQLState("08006", sQLException);
        }
    }

    public void testConnectParenDBInJar() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:derby:testparjardb;create=true");
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE PARTAB (I INT)");
        statement.executeUpdate("INSERT INTO PARTAB VALUES(1)");
        this.shutdownDB("jdbc:derby:testparjardb;shutdown=true");
        Statement statement2 = this.createStatement();
        statement2.executeUpdate("CALL CREATEARCHIVE('test)jardb.jar', 'testparjardb','testparjardb')");
        Connection connection2 = DriverManager.getConnection("jdbc:derby:jar:(test)jardb.jar)testparjardb");
        Statement statement3 = connection2.createStatement();
        ResultSet resultSet = statement3.executeQuery("SELECT * from PARTAB");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        this.shutdownDB("jdbc:derby:jar:(test)jardb.jar)testparjardb;shutdown=true");
        File file = new File(System.getProperty("derby.system.home") + "/test)jardb.jar");
        DBInJarTest.assertTrue((String)("failed deleting " + file.getPath()), (boolean)file.delete());
        DBInJarTest.removeDirectory(new File(System.getProperty("derby.system.home") + "/testparjardb"));
    }

    public void testSpillHashToDisk() throws SQLException {
        this.createDerby2354Database();
        Connection connection = DriverManager.getConnection("jdbc:derby:jar:(d2354db.jar)d2354db");
        Statement statement = connection.createStatement();
        JDBC.assertDrainResults(statement.executeQuery("select distinct x from d2354"), 40000);
        JDBC.assertEmpty(statement.executeQuery("select * from --DERBY-PROPERTIES joinOrder = FIXED\nsysibm.sysdummy1 t1(x),\nd2354 t2 --DERBY-PROPERTIES joinStrategy = HASH\nwhere t1.x = t2.x"));
        Statement statement2 = connection.createStatement(1004, 1007);
        JDBC.assertDrainResults(statement2.executeQuery("select * from d2354"), 40000);
        statement.close();
        statement2.close();
        connection.close();
        this.shutdownDB("jdbc:derby:jar:(d2354db.jar)d2354db;shutdown=true");
        DBInJarTest.removeFiles(new String[]{System.getProperty("derby.system.home") + "/d2354db.jar"});
    }

    private void createDerby2354Database() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:derby:d2354db;create=true");
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.execute("create table d2354 (x varchar(100))");
        statement.close();
        PreparedStatement preparedStatement = connection.prepareStatement("insert into d2354 values ? || 'some extra data to increase the size of the table'");
        for (int i = 0; i < 40000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        connection.commit();
        connection.close();
        this.shutdownDB("jdbc:derby:d2354db;shutdown=true");
        this.createStatement().execute("CALL CREATEARCHIVE('d2354db.jar', 'd2354db', 'd2354db')");
        DBInJarTest.removeDirectory(new File(System.getProperty("derby.system.home") + "/d2354db"));
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(DBInJarTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create procedure CREATEARCHIVE(jarName VARCHAR(20) , path VARCHAR(20), dbName VARCHAR(20)) LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.dbjarUtil.createArchive'");
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DBInJarTest");
        baseTestSuite.addTest(DBInJarTest.baseSuite("DBInJarTest:embedded"));
        return baseTestSuite;
    }
}

