/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class JoinDeadlockTest
extends BaseJDBCTestCase {
    public JoinDeadlockTest(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.locks.waitTimeout", "7");
        properties.setProperty("derby.locks.deadlockTimeout", "5");
        return new SystemPropertyTestSetup(TestConfiguration.defaultSuite(JoinDeadlockTest.class), properties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinDeadlock() throws Exception {
        Statement statement = this.createStatement();
        try {
            Connection connection = this.openDefaultConnection();
            this.setAutoCommit(false);
            connection.setAutoCommit(false);
            statement.executeUpdate("create table outer1(c1 int)");
            statement.executeUpdate("create index o1_i1 on outer1(c1)");
            statement.executeUpdate("insert into outer1 (c1) values 1, 2");
            this.commit();
            statement.executeUpdate("create table inner1(c1 int, c2 char(254))");
            statement.executeUpdate("create index i1_i1 on inner1(c1)");
            statement.executeUpdate("insert into inner1 (c1) values 1, 2");
            this.commit();
            statement.executeUpdate("create table inner2(c1 int, c2 char(254))");
            statement.executeUpdate("create index i2_i1 on inner2(c1)");
            statement.executeUpdate("insert into inner2 (c1) values 1, 2");
            this.commit();
            ResultSet resultSet = statement.executeQuery("select * from outer1 where c1 <= (select count(*) from inner1, inner2 where outer1.c1 = outer1.c1)");
            resultSet.next();
            JoinDeadlockTest.assertEquals((String)resultSet.getString(1), (String)"1");
            Statement statement2 = connection.createStatement();
            statement2.executeUpdate("update inner1 set c1 = c1 where c1 = 1");
            try {
                resultSet.next();
            }
            catch (SQLException sQLException) {
                JoinDeadlockTest.assertSQLState("40XL1", sQLException);
            }
            connection.rollback();
            connection.close();
        }
        finally {
            this.dontThrow(statement, "drop table outer1");
            this.dontThrow(statement, "drop table inner1");
            this.dontThrow(statement, "drop table inner2");
            this.commit();
        }
    }

    private void dontThrow(Statement statement, String string) {
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            JoinDeadlockTest.println("\"" + string + "\" failed");
        }
    }
}

