/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SQLSessionContextTest
extends BaseJDBCTestCase {
    private Connection _conn;
    private Statement _stm;
    private static final String pwSuffix = "pwSuffix";
    private static final String userException = "38000";
    private static final String[] users = new String[]{"TEST_DBO"};
    private static final String[] variableKeywords = new String[]{"role", "schema"};
    private static final String[] currentPrefix = new String[]{"current_", "current "};

    public SQLSessionContextTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("SQLSessionContextTest");
        if (!JDBC.vmSupportsJSR169()) {
            baseTestSuite.addTest(SQLSessionContextTest.positiveSuite("suite: positive, embedded"));
            baseTestSuite.addTest(TestConfiguration.clientServerDecorator(SQLSessionContextTest.positiveSuite("suite: positive, client")));
        }
        return baseTestSuite;
    }

    private static Test positiveSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("suite: positiveSuite");
        for (int i = 0; i < users.length; ++i) {
            baseTestSuite.addTest(TestConfiguration.changeUserDecorator((Test)new SQLSessionContextTest("testPositive"), users[i], users[i].concat(pwSuffix)));
        }
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication((Test)baseTestSuite, users, pwSuffix));
    }

    public void testPositive() throws SQLException {
        int n;
        PreparedStatement[] preparedStatementArray = new PreparedStatement[]{null, null};
        for (int i = 0; i < variableKeywords.length; ++i) {
            String string = currentPrefix[i] + variableKeywords[i];
            preparedStatementArray[i] = this._conn.prepareStatement("values " + string);
        }
        SQLSessionContextTest.println("testPositive user=" + this.getTestConfiguration().getUserName());
        this._stm.executeUpdate("set role outermost");
        this._stm.executeUpdate("set schema outermost");
        this._stm.execute("call test_dbo.p2()");
        ResultSet resultSet = this._stm.getResultSet();
        SQLSessionContextTest.assertCurrent("role", resultSet, "LEVEL2");
        this._stm.getMoreResults(1);
        resultSet = this._stm.getResultSet();
        SQLSessionContextTest.assertCurrent("schema", resultSet, "LEVEL2");
        resultSet.close();
        for (int i = 0; i < variableKeywords.length; ++i) {
            ResultSet resultSet2 = preparedStatementArray[i].executeQuery();
            SQLSessionContextTest.assertCurrent(variableKeywords[i], resultSet2, "OUTERMOST");
            resultSet2.close();
        }
        ResultSet resultSet3 = this._stm.executeQuery("values test_dbo.f2()");
        resultSet3.next();
        resultSet3.close();
        for (int i = 0; i < variableKeywords.length; ++i) {
            resultSet3 = preparedStatementArray[i].executeQuery();
            SQLSessionContextTest.assertCurrent(variableKeywords[i], resultSet3, "OUTERMOST");
            resultSet3.close();
        }
        resultSet3 = this._stm.executeQuery("values test_dbo.f2() + test_dbo.f22()");
        resultSet3.next();
        resultSet3.close();
        try {
            resultSet3 = this._stm.executeQuery("values test_dbo.f3()");
            resultSet3.next();
        }
        catch (SQLException sQLException) {
            SQLSessionContextTest.assertSQLState(userException, sQLException);
        }
        for (int i = 0; i < 1; ++i) {
            resultSet3 = preparedStatementArray[i].executeQuery();
            SQLSessionContextTest.assertCurrent(variableKeywords[i], resultSet3, "OUTERMOST");
            resultSet3.close();
        }
        this._stm.execute("call test_dbo.dropper()");
        String[] stringArray = new String[]{null, "TEST_DBO"};
        for (n = 0; n < 1; ++n) {
            resultSet3 = preparedStatementArray[n].executeQuery();
            SQLSessionContextTest.assertCurrent(variableKeywords[n], resultSet3, stringArray[n]);
            resultSet3.close();
        }
        for (n = 0; n < variableKeywords.length; ++n) {
            preparedStatementArray[n].close();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._stm = this.createStatement();
        this._conn = this.getConnection();
        this._stm.executeUpdate("create role outermost");
        this._stm.executeUpdate("create role level2");
        this._stm.executeUpdate("create role innermost");
        this._stm.executeUpdate("create schema outermost");
        this._stm.executeUpdate("create schema level2");
        this._stm.executeUpdate("create schema innermost");
        this._stm.executeUpdate("create procedure p2()  dynamic result sets 2 language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.p2'  modifies sql data");
        this._stm.executeUpdate("create function f2()  returns int language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.f2'  reads sql data");
        this._stm.executeUpdate("create function f22()  returns int language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.f22'  reads sql data");
        this._stm.executeUpdate("create function f3()  returns int language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.f3'  reads sql data");
        this._stm.executeUpdate("create procedure calledNestedFromP2(state VARCHAR(255))  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.calledNestedFromP2'  modifies sql data");
        this._stm.executeUpdate("create procedure dropper()  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.SQLSessionContextTest.dropper'  modifies sql data");
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this._stm.executeUpdate("set schema test_dbo");
            this._stm.executeUpdate("drop role level2");
            this._stm.executeUpdate("drop role innermost");
            this._stm.executeUpdate("drop schema level2 restrict");
            this._stm.executeUpdate("drop schema innermost restrict");
            this._stm.executeUpdate("drop procedure p2");
            this._stm.executeUpdate("drop function f2");
            this._stm.executeUpdate("drop function f22");
            this._stm.executeUpdate("drop function f3");
            this._stm.executeUpdate("drop procedure calledNestedFromP2");
            this._stm.executeUpdate("drop procedure dropper");
        }
        finally {
            if (this._stm != null) {
                this._stm = null;
            }
            if (this._conn != null) {
                this._conn = null;
            }
            super.tearDown();
        }
    }

    private static void assertCurrent(String string, ResultSet resultSet, String object) throws SQLException {
        SQLSessionContextTest.assertTrue((String)"result set empty", (boolean)resultSet.next());
        String string2 = resultSet.getString(1);
        if (string.equals("role") && object != null) {
            object = "\"" + (String)object + "\"";
        }
        if (object != null) {
            SQLSessionContextTest.assertTrue((String)(string + ": current is " + string2 + ", expected " + (String)object), (boolean)((String)object).equals(string2));
        } else {
            SQLSessionContextTest.assertTrue((String)(string + ": current is " + string2 + ", expected null"), (string2 == null ? 1 : 0) != 0);
        }
        SQLSessionContextTest.assertFalse((String)"result set not empty", (boolean)resultSet.next());
    }

    public static void p2(ResultSet[] resultSetArray, ResultSet[] resultSetArray2) throws Throwable {
        Connection connection = null;
        Connection connection2 = null;
        try {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            String string;
            int n;
            connection = DriverManager.getConnection("jdbc:default:connection");
            for (n = 0; n < variableKeywords.length; ++n) {
                string = currentPrefix[n] + variableKeywords[n];
                preparedStatement = connection.prepareStatement("values " + string);
                resultSet = preparedStatement.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[n], resultSet, "OUTERMOST");
                resultSet.close();
                Statement statement = connection.createStatement();
                statement.executeUpdate("set " + variableKeywords[n] + " level2");
                resultSet = preparedStatement.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[n], resultSet, "LEVEL2");
                connection.commit();
                statement.executeUpdate("call test_dbo.calledNestedFromP2('" + variableKeywords[n] + "')");
                resultSet = preparedStatement.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[n], resultSet, "LEVEL2");
                resultSet.close();
                connection2 = DriverManager.getConnection("jdbc:default:connection");
                PreparedStatement preparedStatement2 = connection2.prepareStatement("values " + string);
                resultSet = preparedStatement2.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[n], resultSet, "LEVEL2");
                resultSet.close();
                preparedStatement2.close();
            }
            for (n = 0; n < variableKeywords.length; ++n) {
                string = currentPrefix[n] + variableKeywords[n];
                preparedStatement = connection.prepareStatement("values " + string);
                resultSet = preparedStatement.executeQuery();
                if (variableKeywords[n].equals("role")) {
                    resultSetArray[0] = resultSet;
                    continue;
                }
                resultSetArray2[0] = resultSet;
            }
        }
        catch (Throwable throwable) {
            SQLSessionContextTest.println("err: " + String.valueOf(throwable));
            throw throwable;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            if (connection2 != null) {
                try {
                    connection2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calledNestedFromP2(String string) throws SQLException {
        Connection connection = null;
        Connection connection2 = null;
        try {
            connection = DriverManager.getConnection("jdbc:default:connection");
            String string2 = string.equals("role") ? "current_role" : "current schema";
            PreparedStatement preparedStatement = connection.prepareStatement("values " + string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            SQLSessionContextTest.assertCurrent(string, resultSet, "LEVEL2");
            resultSet.close();
            Statement statement = connection.createStatement();
            statement.executeUpdate("set " + string + " innermost");
            resultSet = preparedStatement.executeQuery();
            SQLSessionContextTest.assertCurrent(string, resultSet, "INNERMOST");
            resultSet.close();
            preparedStatement.close();
            connection2 = DriverManager.getConnection("jdbc:default:connection");
            preparedStatement = connection2.prepareStatement("values " + string2);
            resultSet = preparedStatement.executeQuery();
            SQLSessionContextTest.assertCurrent(string, resultSet, "INNERMOST");
            resultSet.close();
            preparedStatement.close();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            if (connection2 != null) {
                try {
                    connection2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int f2() throws SQLException {
        Connection connection = null;
        Connection connection2 = null;
        try {
            connection = DriverManager.getConnection("jdbc:default:connection");
            for (int i = 0; i < variableKeywords.length; ++i) {
                String string = currentPrefix[i] + variableKeywords[i];
                PreparedStatement preparedStatement = connection.prepareStatement("values " + string);
                ResultSet resultSet = preparedStatement.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], resultSet, "OUTERMOST");
                resultSet.close();
                Statement statement = connection.createStatement();
                statement.executeUpdate("set " + variableKeywords[i] + " level2");
                resultSet = preparedStatement.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], resultSet, "LEVEL2");
                preparedStatement.close();
                connection2 = DriverManager.getConnection("jdbc:default:connection");
                preparedStatement = connection2.prepareStatement("values " + string);
                resultSet = preparedStatement.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], resultSet, "LEVEL2");
                resultSet.close();
                preparedStatement.close();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            if (connection2 != null) {
                try {
                    connection2.close();
                }
                catch (Exception exception) {}
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int f22() throws SQLException {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:default:connection");
            for (int i = 0; i < variableKeywords.length; ++i) {
                String string = currentPrefix[i] + variableKeywords[i];
                PreparedStatement preparedStatement = connection.prepareStatement("values " + string);
                ResultSet resultSet = preparedStatement.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], resultSet, "OUTERMOST");
                resultSet.close();
                preparedStatement.close();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int f3() throws SQLException {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:default:connection");
            Statement statement = connection.createStatement();
            statement.executeUpdate("set role level2");
            statement.executeUpdate("set schema level2");
            PreparedStatement preparedStatement = connection.prepareStatement("values 42");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            resultSet.next();
            String string = resultSet.getString(1);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropper() throws SQLException {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:default:connection");
            Statement statement = connection.createStatement();
            statement.executeUpdate("drop role outermost");
            statement.executeUpdate("drop schema outermost restrict");
            statement.close();
            String[] stringArray = new String[]{null, "TEST_DBO"};
            for (int i = 0; i < variableKeywords.length; ++i) {
                String string = currentPrefix[i] + variableKeywords[i];
                PreparedStatement preparedStatement = connection.prepareStatement("values " + string);
                ResultSet resultSet = preparedStatement.executeQuery();
                SQLSessionContextTest.assertCurrent(variableKeywords[i], resultSet, stringArray[i]);
                resultSet.close();
                preparedStatement.close();
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

