/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest;
import org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate;
import org.apache.derbyTesting.functionTests.util.streams.ByteAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.functionTests.util.streams.ReadOnceByteArrayInputStream;
import org.apache.derbyTesting.functionTests.util.streams.StringReaderWithLength;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public class TriggerTest
extends BaseJDBCTestCase {
    private static final String SYNTAX_ERROR = "42X01";
    private static final String HAS_DEPENDENT_SPS = "X0Y24";
    private static final String HAS_DEPENDENT_TRIGGER = "X0Y25";
    private static final String TRIGGER_DROPPED = "01502";
    private static final String FOREIGN_KEY_VIOLATION = "23503";
    private static ThreadLocal<List<String>> TRIGGER_INFO = new ThreadLocal();
    StringBuffer listOfCreatedTriggers = new StringBuffer();

    public TriggerTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(TriggerTest.class));
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    protected void setUp() throws Exception {
        JDBC.dropSchema(this.getConnection().getMetaData(), this.getTestConfiguration().getUserName());
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE PROCEDURE TRIGGER_LOG_INFO(O VARCHAR(255)) NO SQL PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".logTriggerInfo'");
        statement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        TRIGGER_INFO.set(null);
        super.tearDown();
    }

    public void testDerby6383StatementTriggerBugTst1() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE DERBY_6368_TAB1 (X INTEGER, Y INTEGER)");
        statement.executeUpdate("CREATE TABLE DERBY_6368_TAB2 (X INTEGER, Y INTEGER)");
        statement.executeUpdate("INSERT INTO  DERBY_6368_TAB1 VALUES(1, 2)");
        statement.executeUpdate("CREATE TRIGGER t1 AFTER UPDATE OF x ON DERBY_6368_TAB1 REFERENCING old table AS old INSERT INTO DERBY_6368_TAB2 SELECT * FROM old");
        this.assertTableRowCount("DERBY_6368_TAB2", 0);
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 0);
        statement.executeUpdate("CREATE TRIGGER t2 AFTER UPDATE OF x ON DERBY_6368_TAB1 REFERENCING old AS old_row for each row INSERT INTO DERBY_6368_TAB2(x) values(old_row.x)");
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 0);
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 2);
        statement.executeUpdate("CREATE TRIGGER t3 AFTER UPDATE ON DERBY_6368_TAB1 REFERENCING old table AS old INSERT INTO DERBY_6368_TAB2 SELECT * FROM old");
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 3);
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 6);
        statement.executeUpdate("ALTER TABLE DERBY_6368_TAB1 ADD COLUMN Z int");
        statement.executeUpdate("ALTER TABLE DERBY_6368_TAB2 ADD COLUMN Z int");
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET z = z + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 7);
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 8);
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 11);
        statement.executeUpdate("drop TRIGGER T1");
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 12);
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 14);
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET z = z + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 15);
        statement.executeUpdate("ALTER TABLE DERBY_6368_TAB1 DROP COLUMN Y");
        statement.executeUpdate("ALTER TABLE DERBY_6368_TAB2 DROP COLUMN Y");
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 16);
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET z = z + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 16);
        statement.executeUpdate("drop table DERBY_6368_TAB1");
        statement.executeUpdate("drop table DERBY_6368_TAB2");
    }

    public void testDerby6383StatementTriggerBugTst2() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE DERBY_6368_TAB1 (X INTEGER, Y INTEGER)");
        statement.executeUpdate("CREATE TABLE DERBY_6368_TAB2 (X INTEGER, Y INTEGER)");
        statement.executeUpdate("INSERT INTO  DERBY_6368_TAB1 VALUES(1, 2)");
        statement.executeUpdate("CREATE TRIGGER t1 AFTER UPDATE ON DERBY_6368_TAB1 REFERENCING old table AS old INSERT INTO DERBY_6368_TAB2 SELECT * FROM old");
        this.assertTableRowCount("DERBY_6368_TAB2", 0);
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET x = x + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 1);
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET y = y + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 2);
        statement.executeUpdate("ALTER TABLE DERBY_6368_TAB1 ADD COLUMN Z int");
        statement.executeUpdate("ALTER TABLE DERBY_6368_TAB2 ADD COLUMN Z int");
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET z = z + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 3);
        statement.executeUpdate("ALTER TABLE DERBY_6368_TAB1 DROP COLUMN X");
        statement.executeUpdate("ALTER TABLE DERBY_6368_TAB2 DROP COLUMN X");
        statement.executeUpdate("UPDATE DERBY_6368_TAB1 SET z = z + 1");
        this.assertTableRowCount("DERBY_6368_TAB2", 3);
        statement.executeUpdate("drop table DERBY_6368_TAB1");
        statement.executeUpdate("drop table DERBY_6368_TAB2");
    }

    public void testDerby6726() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE LOG (ID BIGINT NOT NULL PRIMARY KEY    GENERATED ALWAYS AS IDENTITY    (START WITH 1, INCREMENT BY 1),NAME VARCHAR(80) DEFAULT 'New Log' NOT NULL,VERSION INT NOT NULL,DEPTH_UNITS VARCHAR(12) DEFAULT 'M',TOP_DEPTH DOUBLE DEFAULT -999.25,BOTTOM_DEPTH DOUBLE DEFAULT -999.25)");
        statement.executeUpdate("CREATE TABLE CURVE (ID BIGINT NOT NULL PRIMARY KEY    GENERATED ALWAYS AS IDENTITY    (START WITH 1, INCREMENT BY 1),LOG_ID BIGINT NOT NULL,NAME VARCHAR(80) DEFAULT 'New Curve' NOT NULL,TYPE VARCHAR(40) DEFAULT '.' NOT NULL,VERSION INT NOT NULL,PERSISTENCE VARCHAR(40) DEFAULT 'NUMBER',DEPTH_UNITS VARCHAR(12) DEFAULT 'M',CURVE_UNITS VARCHAR(40) DEFAULT '.',TOP_DEPTH DOUBLE DEFAULT -999.25,BOTTOM_DEPTH DOUBLE DEFAULT -999.25,MINCVAL DOUBLE DEFAULT -999.25,MAXCVAL DOUBLE DEFAULT -999.25,CREATED_BY VARCHAR(40) DEFAULT USER,CREATE_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,LAST_UPDATED TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
        statement.executeUpdate("CREATE TRIGGER CURVE_TRIG_LAST  AFTER UPDATE OF NAME, TYPE, VERSION, PERSISTENCE,        DEPTH_UNITS, CURVE_UNITS, TOP_DEPTH,        BOTTOM_DEPTH, MINCVAL, MAXCVAL ON CURVE  REFERENCING OLD AS UPDATEDROW  FOR EACH ROW     UPDATE CURVE SET LAST_UPDATED=CURRENT_TIMESTAMP            WHERE ID=UPDATEDROW.ID");
        statement.executeUpdate("CREATE TRIGGER CURVE_TRIG_UP  AFTER UPDATE OF TOP_DEPTH, BOTTOM_DEPTH ON CURVE  REFERENCING OLD AS UPDATEDROW  FOR EACH ROW     UPDATE LOG SET         TOP_DEPTH=(            SELECT MIN(TOP_DEPTH) FROM CURVE                    WHERE LOG_ID=UPDATEDROW.LOG_ID AND                          TOP_DEPTH<>-999.25),         BOTTOM_DEPTH=(            SELECT MAX(BOTTOM_DEPTH) FROM CURVE                    WHERE LOG_ID=UPDATEDROW.LOG_ID AND                          BOTTOM_DEPTH<>-999.25)         WHERE ID=UPDATEDROW.LOG_ID");
        statement.executeUpdate("CREATE TABLE CURVE_DATA_NUMBER (CURVE_ID BIGINT NOT NULL,SEQ_NUM BIGINT NOT NULL,MDEPTH DOUBLE,CVALUE DOUBLE DEFAULT -999.25)");
        statement.executeUpdate("ALTER TABLE CURVE_DATA_NUMBER   ADD CONSTRAINT CURVE_DATA_NUMBER_CURVE_ID_FK       FOREIGN KEY (CURVE_ID) REFERENCES CURVE (ID)       ON DELETE CASCADE");
        statement.executeUpdate("ALTER TABLE CURVE_DATA_NUMBER   ADD CONSTRAINT CURVE_DATA_NUMBER_UN       UNIQUE (CURVE_ID, SEQ_NUM)");
        statement.executeUpdate("CREATE INDEX CURVE_DATA_NUMBER_SEQ_NUM_INDEX   on CURVE_DATA_NUMBER (SEQ_NUM)");
        statement.executeUpdate("CREATE TRIGGER CURVE_DATA_NUMBER_TRIG_UP  AFTER UPDATE OF CURVE_ID, SEQ_NUM, MDEPTH, CVALUE        ON CURVE_DATA_NUMBER  REFERENCING OLD AS UPDATEDROW  FOR EACH ROW     UPDATE CURVE SET         TOP_DEPTH=(            SELECT MIN(MDEPTH) FROM CURVE_DATA_NUMBER                    WHERE CURVE_ID=UPDATEDROW.CURVE_ID AND                    MDEPTH<>-999.25),        BOTTOM_DEPTH=(            SELECT MAX(MDEPTH) FROM CURVE_DATA_NUMBER                    WHERE CURVE_ID=UPDATEDROW.CURVE_ID AND                    MDEPTH<>-999.25),        MINCVAL=(            SELECT MIN(CVALUE) FROM CURVE_DATA_NUMBER                    WHERE CURVE_ID=UPDATEDROW.CURVE_ID AND                    CVALUE<>-999.25),        MAXCVAL=(            SELECT MAX(CVALUE) FROM CURVE_DATA_NUMBER                    WHERE CURVE_ID=UPDATEDROW.CURVE_ID AND                    CVALUE<>-999.25)     WHERE ID=UPDATEDROW.CURVE_ID");
        statement.executeUpdate("INSERT INTO LOG (NAME, VERSION) VALUES('TESTLOG',1)");
        statement.executeUpdate("INSERT INTO CURVE(LOG_ID,NAME,VERSION) VALUES(1,'GR',1)");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO CURVE_DATA_NUMBER    (CURVE_ID, SEQ_NUM, MDEPTH, CVALUE)    VALUES(?,?,?,?)");
        for (int i = 1; i < 1000; ++i) {
            preparedStatement.setInt(1, 1);
            preparedStatement.setInt(2, i);
            preparedStatement.setDouble(3, 1000.0 + (double)i);
            preparedStatement.setDouble(4, 43.0 + (double)i);
            preparedStatement.executeUpdate();
        }
        statement.executeUpdate("UPDATE CURVE_DATA_NUMBER   SET CURVE_ID=1 WHERE CURVE_ID=1 AND SEQ_NUM=1");
        statement.executeUpdate("DROP TRIGGER CURVE_DATA_NUMBER_TRIG_UP");
        statement.executeUpdate("DROP TRIGGER CURVE_TRIG_UP");
        statement.executeUpdate("DROP TRIGGER CURVE_TRIG_LAST");
        statement.executeUpdate("ALTER TABLE CURVE_DATA_NUMBER  DROP CONSTRAINT CURVE_DATA_NUMBER_CURVE_ID_FK");
        statement.executeUpdate("ALTER TABLE CURVE_DATA_NUMBER  DROP CONSTRAINT CURVE_DATA_NUMBER_UN");
        statement.executeUpdate("DROP INDEX CURVE_DATA_NUMBER_SEQ_NUM_INDEX");
        statement.executeUpdate("DROP TABLE LOG");
        statement.executeUpdate("DROP TABLE CURVE");
        statement.executeUpdate("DROP TABLE CURVE_DATA_NUMBER");
    }

    public void testDerby5578InvalidateAllStatementsProc() throws SQLException {
        Statement statement = this.createStatement();
        CallableStatement callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS()");
        TriggerTest.assertUpdateCount(callableStatement, 0);
        callableStatement.close();
        int n = this.numberOfRowsInSysstatements(statement);
        int n2 = this.numberOfInvalidStatementsInSysstatements(statement);
        int n3 = this.numberOfValidStatementsInSysstatements(statement);
        TriggerTest.assertEquals((String)"All statements should be invalid in SYS.SYSSTATEMENTS ", (int)n2, (int)n);
        TriggerTest.assertEquals((String)"No statement should be valid in SYS.SYSSTATEMENTS ", (int)n3, (int)0);
        statement.executeUpdate("create table atdc_16_tab1 (a1 integer, b1 integer, c1 integer)");
        statement.executeUpdate("create table atdc_16_tab2 (a2 integer, b2 integer, c2 integer)");
        statement.executeUpdate("insert into atdc_16_tab1 values(1,11,111)");
        statement.executeUpdate("insert into atdc_16_tab2 values(1,11,111)");
        TriggerTest.assertEquals((String)"# of valid statements in SYS.SYSSTATEMENTS should not change", (int)this.numberOfValidStatementsInSysstatements(statement), (int)n3);
        TriggerTest.assertEquals((String)"# of invalid statements in SYS.SYSSTATEMENTS should not change", (int)this.numberOfInvalidStatementsInSysstatements(statement), (int)n2);
        statement.executeUpdate("create trigger atdc_16_trigger_1 after update of b1 on atdc_16_tab1 REFERENCING NEW AS newt for each row update atdc_16_tab2 set c2 = newt.c1");
        TriggerTest.assertEquals((String)"# of valid rows in SYS.SYSSTATEMENTS should be up by 1 for trigger", (int)this.numberOfValidStatementsInSysstatements(statement), (int)(n3 + 1));
        TriggerTest.assertEquals((String)"# of invalid statements in SYS.SYSSTATEMENTS should not change", (int)this.numberOfInvalidStatementsInSysstatements(statement), (int)n2);
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_INVALIDATE_STORED_STATEMENTS()");
        TriggerTest.assertUpdateCount(callableStatement, 0);
        callableStatement.close();
        TriggerTest.assertEquals((String)"All statements should be invalid in SYS.SYSSTATEMENTS ", (int)this.numberOfInvalidStatementsInSysstatements(statement), (int)(n + 1));
        statement.executeUpdate("update atdc_16_tab1 set b1=22,c1=222");
        TriggerTest.assertEquals((String)"# of valid rows in SYS.SYSSTATEMENTS should only be 1 ", (int)this.numberOfValidStatementsInSysstatements(statement), (int)1);
        TriggerTest.assertEquals((String)"# of invalid statements in SYS.SYSSTATEMENTS should not change", (int)this.numberOfInvalidStatementsInSysstatements(statement), (int)n2);
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        JDBC.assertDrainResults(databaseMetaData.getTables(null, "APP", "ATDC_16_TAB1", null));
        TriggerTest.assertEquals((String)"# of valid rows in SYS.SYSSTATEMENTS should only be 2 ", (int)this.numberOfValidStatementsInSysstatements(statement), (int)2);
        TriggerTest.assertEquals((String)"# of invalid statements in SYS.SYSSTATEMENTS should not change", (int)this.numberOfInvalidStatementsInSysstatements(statement), (int)(n2 - 1));
        statement.executeUpdate("drop table ATDC_16_TAB1");
    }

    private int numberOfInvalidStatementsInSysstatements(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM SYS.SYSSTATEMENTS WHERE VALID = false");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return n;
    }

    private int numberOfValidStatementsInSysstatements(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM SYS.SYSSTATEMENTS WHERE VALID = TRUE");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return n;
    }

    private int numberOfRowsInSysstatements(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM SYS.SYSSTATEMENTS");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return n;
    }

    public void testAlerColumnLength() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE TestAlterTable( element_id INTEGER NOT NULL, altered_id VARCHAR(30) NOT NULL, counter SMALLINT NOT NULL DEFAULT 0, timets TIMESTAMP NOT NULL)");
        statement.executeUpdate("CREATE TRIGGER mytrig AFTER UPDATE ON TestAlterTable REFERENCING NEW AS newt OLD AS oldt FOR EACH ROW MODE DB2SQL   UPDATE TestAlterTable set   TestAlterTable.counter = CASE WHEN   (oldt.counter < 32767) THEN (oldt.counter + 1) ELSE 1 END   WHERE ((newt.counter is null) or   (oldt.counter = newt.counter))   AND newt.element_id = TestAlterTable.element_id   AND newt.altered_id = TestAlterTable.altered_id");
        statement.executeUpdate("ALTER TABLE TestAlterTable ALTER altered_id SET DATA TYPE VARCHAR(64)");
        statement.executeUpdate("insert into TestAlterTable values (99, '012345678901234567890123456789001234567890',1,CURRENT_TIMESTAMP)");
        ResultSet resultSet = statement.executeQuery("SELECT element_id, counter FROM TestAlterTable");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"99", "1"}});
        statement.executeUpdate("update TestAlterTable set timets = CURRENT_TIMESTAMP where ELEMENT_ID = 99");
        resultSet = statement.executeQuery("SELECT element_id, counter FROM TestAlterTable");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"99", "2"}});
        statement.executeUpdate("DROP TABLE TestAlterTable");
    }

    public void testFiringOrder() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE T(ID INT)");
        int n = this.createRandomTriggers()[0];
        ArrayList arrayList = new ArrayList();
        TRIGGER_INFO.set(arrayList);
        statement.execute("INSERT INTO T VALUES 1");
        this.commit();
        int n2 = this.assertFiringOrder("INSERT", 1);
        arrayList.clear();
        statement.execute("UPDATE T SET ID = 2");
        this.commit();
        n2 += this.assertFiringOrder("UPDATE", 1);
        arrayList.clear();
        statement.execute("DELETE FROM T");
        this.commit();
        arrayList.clear();
        TriggerTest.assertEquals((String)"All triggers fired?", (int)n, (int)(n2 += this.assertFiringOrder("DELETE", 1)));
        statement.execute("INSERT INTO T VALUES 1,2,3");
        this.commit();
        n2 = this.assertFiringOrder("INSERT", 3);
        arrayList.clear();
        statement.execute("UPDATE T SET ID = 2");
        this.commit();
        n2 += this.assertFiringOrder("UPDATE", 3);
        arrayList.clear();
        statement.execute("DELETE FROM T");
        this.commit();
        arrayList.clear();
        TriggerTest.assertTrue((String)"Sufficient triggers fired?", ((n2 += this.assertFiringOrder("DELETE", 3)) >= n ? 1 : 0) != 0);
        this.assertTableRowCount("T", 0);
        statement.execute("INSERT INTO T SELECT ID FROM T");
        this.commit();
        n2 = this.assertFiringOrder("INSERT", 0);
        arrayList.clear();
        statement.execute("UPDATE T SET ID = 2");
        this.commit();
        n2 += this.assertFiringOrder("UPDATE", 0);
        arrayList.clear();
        statement.execute("DELETE FROM T");
        this.commit();
        n2 += this.assertFiringOrder("DELETE", 0);
        arrayList.clear();
        statement.close();
    }

    private int[] createRandomTriggers() throws SQLException {
        Statement statement = this.createStatement();
        int n = 0;
        int n2 = 0;
        Random random = new Random();
        int n3 = random.nextInt(45) + 45;
        this.listOfCreatedTriggers = new StringBuffer();
        for (int i = 0; i < n3; ++i) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CREATE TRIGGER TR");
            stringBuffer.append(i);
            stringBuffer.append(" ");
            if (random.nextInt(2) == 0) {
                string = "NO CASCADE BEFORE";
                ++n;
            } else {
                string = "AFTER";
                ++n2;
            }
            stringBuffer.append(string);
            stringBuffer.append(" ");
            int n4 = random.nextInt(3);
            String string2 = n4 == 0 ? "INSERT" : (n4 == 1 ? "UPDATE" : "DELETE");
            stringBuffer.append(string2);
            stringBuffer.append(" ON T FOR EACH ");
            String string3 = random.nextInt(2) == 0 ? "ROW" : "STATEMENT";
            stringBuffer.append(string3);
            stringBuffer.append(" ");
            stringBuffer.append("CALL TRIGGER_LOG_INFO('");
            stringBuffer.append(i);
            stringBuffer.append(",");
            stringBuffer.append(string);
            stringBuffer.append(",");
            stringBuffer.append(string2);
            stringBuffer.append(",");
            stringBuffer.append(string3);
            stringBuffer.append("')");
            statement.execute(stringBuffer.toString());
            this.listOfCreatedTriggers.append(stringBuffer.toString());
        }
        this.commit();
        statement.close();
        return new int[]{n3, n, n2};
    }

    public void testFiringConstraintOrder() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE T (I INT PRIMARY KEY,U INT NOT NULL UNIQUE, C INT CHECK (C < 20))");
        statement.execute("INSERT INTO T VALUES(1,5,10)");
        statement.execute("INSERT INTO T VALUES(11,19,3)");
        statement.execute("CREATE TABLE TCHILD (I INT, FOREIGN KEY (I) REFERENCES T)");
        statement.execute("INSERT INTO TCHILD VALUES 1");
        this.commit();
        int n = this.createRandomTriggers()[1];
        ArrayList arrayList = new ArrayList();
        TRIGGER_INFO.set(arrayList);
        TriggerTest.assertStatementError("23505", statement, "INSERT INTO T VALUES (1,6,10)");
        this.assertFiringOrder("INSERT", 1, true);
        arrayList.clear();
        TriggerTest.assertStatementError("23505", statement, "UPDATE T SET I=1 WHERE I = 11");
        this.assertFiringOrder("UPDATE", 1, true);
        arrayList.clear();
        this.rollback();
        TriggerTest.assertStatementError("23505", statement, "INSERT INTO T VALUES (2,5,10)");
        this.assertFiringOrder("INSERT", 1, true);
        arrayList.clear();
        TriggerTest.assertStatementError("23505", statement, "UPDATE T SET U=5 WHERE I = 11");
        this.assertFiringOrder("UPDATE", 1, true);
        arrayList.clear();
        this.rollback();
        TriggerTest.assertStatementError("23513", statement, "INSERT INTO T VALUES (2,6,22)");
        this.assertFiringOrder("INSERT", 1, true);
        arrayList.clear();
        TriggerTest.assertStatementError("23513", statement, "UPDATE T SET C=C+40 WHERE I = 11");
        this.assertFiringOrder("UPDATE", 1, true);
        arrayList.clear();
        this.rollback();
        TriggerTest.assertStatementError(FOREIGN_KEY_VIOLATION, statement, "DELETE FROM T WHERE I = 1");
        this.assertFiringOrder("DELETE", 1, true);
        statement.close();
        this.commit();
    }

    private int assertFiringOrder(String string, int n) {
        return this.assertFiringOrder(string, n, false);
    }

    private int assertFiringOrder(String string, int n, boolean bl) {
        List<String> list = TRIGGER_INFO.get();
        int n2 = -1;
        String string2 = null;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            TriggerTest.assertEquals((int)4, (int)stringTokenizer.countTokens());
            stringTokenizer.hasMoreTokens();
            int n3 = Integer.valueOf(stringTokenizer.nextToken());
            stringTokenizer.hasMoreTokens();
            String string4 = stringTokenizer.nextToken();
            stringTokenizer.hasMoreTokens();
            String string5 = stringTokenizer.nextToken();
            stringTokenizer.hasMoreTokens();
            String string6 = stringTokenizer.nextToken();
            TriggerTest.assertEquals((String)("Incorrect trigger firing:" + string3), (String)string, (String)string5);
            if (n == 0) {
                TriggerTest.assertEquals((String)"Row trigger firing on no rows", (String)"STATEMENT", (String)string6);
            }
            if (bl) {
                TriggerTest.assertFalse((String)"No AFTER triggers", (boolean)"AFTER".equals(string4));
            }
            if (n2 == -1) {
                n2 = n3;
                string2 = string4;
                continue;
            }
            if (string2.equals(string4)) {
                boolean bl2 = n > 1 ? n3 >= n2 : n3 > n2;
                TriggerTest.assertTrue((String)("matching triggers need to be fired in order creation:" + string3 + ". Triggers got fired in this order:" + TRIGGER_INFO.get().toString() + ". Tiggers got created in this order:" + this.listOfCreatedTriggers.toString()), (boolean)bl2);
                n2 = n3;
                continue;
            }
            TriggerTest.assertEquals((String)("BEFORE before AFTER:" + string3), (String)"NO CASCADE BEFORE", (String)string2);
            TriggerTest.assertEquals((String)("then AFTER:" + string3), (String)"AFTER", (String)string4);
            string2 = string4;
            n2 = n3;
        }
        return list.size();
    }

    public static void logTriggerInfo(String string) {
        TRIGGER_INFO.get().add(string);
    }

    public void testNPEinTriggerFire() throws SQLException {
        Statement statement = this.createStatement();
        String string = " CREATE TABLE TRADE(ID INT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY (START WITH 1000), BUYID INT NOT NULL,QTY FLOAT(2) NOT NULL)";
        statement.executeUpdate(string);
        string = "CREATE TABLE TOTAL(BUYID INT NOT NULL, TOTALQTY FLOAT(2) NOT NULL)";
        statement.executeUpdate(string);
        string = "CREATE TRIGGER TRADE_INSERT AFTER INSERT ON TRADE REFERENCING NEW AS NEWROW FOR EACH ROW MODE DB2SQL UPDATE TOTAL SET TOTALQTY = NEWROW.QTY WHERE BUYID = NEWROW.BUYID";
        statement.executeUpdate(string);
        statement.executeUpdate("INSERT INTO TOTAL VALUES (1, 0)");
        statement.executeUpdate("INSERT INTO TRADE VALUES(1, 1, 10)");
        this.commit();
    }

    public void testReadRequiredColumnsOnlyFromTriggerTable() throws SQLException, IOException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE table1 (c11 int, c12 int, c13 int, c14 int, c15 int)");
        statement.executeUpdate("INSERT INTO table1 VALUES(1,2,3,4,5)");
        statement.executeUpdate("CREATE TABLE table2 (c21 int, c22 int, c23 int, c24 int, c25 int)");
        statement.executeUpdate("INSERT INTO table2 VALUES(2,2,3,-1,5)");
        statement.executeUpdate("CREATE TRIGGER tr1 AFTER UPDATE OF c12 ON table1  REFERENCING OLD AS oldt NEW AS newt FOR EACH ROW UPDATE table2 SET c24=oldt.c14");
        this.commit();
        statement.executeUpdate("update table1 set c12 = -9 where c11=1");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM table2");
        String[][] stringArray = new String[][]{{"2", "2", "3", "4", "5"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        String string = "CREATE TRIGGER tr1 AFTER UPDATE OF c12xxx ON table1  REFERENCING OLD AS oldt NEW AS newt FOR EACH ROW UPDATE table2 SET c24=oldt.c14";
        TriggerTest.assertStatementError("42X14", statement, string);
        string = "CREATE TRIGGER tr1 AFTER UPDATE OF c12 ON table1  REFERENCING OLD AS oldt NEW AS newt FOR EACH ROW UPDATE table2 SET c24=oldt.c14xxx";
        TriggerTest.assertStatementError("42X04", statement, string);
        statement.executeUpdate("create table derby1482_lob1 (str1 Varchar(80), c_lob CLOB(50M))");
        statement.executeUpdate("create table derby1482_lob1_log(oldvalue CLOB(50M), newvalue  CLOB(50M), chng_time timestamp default current_timestamp)");
        statement.executeUpdate("create trigger tr1_derby1482_lob1 after update of c_lob on derby1482_lob1 REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL insert into derby1482_lob1_log(oldvalue, newvalue) values (old.c_lob, new.c_lob)");
        statement.executeUpdate("INSERT INTO derby1482_lob1 VALUES ('1',null)");
        statement.executeUpdate("update derby1482_lob1 set c_lob = null");
        resultSet = statement.executeQuery("SELECT oldvalue, newvalue FROM derby1482_lob1_log");
        stringArray = new String[][]{{null, null}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("create table derby1482_selfUpdate (i int, j int)");
        statement.executeUpdate("insert into derby1482_selfUpdate values (1,10)");
        statement.executeUpdate("create trigger tr_derby1482_selfUpdate after update of i on derby1482_selfUpdate referencing old as old for each row update derby1482_selfUpdate set j = old.j+1");
        statement.executeUpdate("update derby1482_selfUpdate set i=i+1");
        resultSet = statement.executeQuery("SELECT * FROM derby1482_selfUpdate");
        stringArray = new String[][]{{"2", "11"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.executeUpdate("create table t1_noTriggerActionColumn (id int, status smallint)");
        statement.executeUpdate("insert into t1_noTriggerActionColumn values(11,1)");
        statement.executeUpdate("create table t2_noTriggerActionColumn (id int, updates int default 0)");
        statement.executeUpdate("insert into t2_noTriggerActionColumn values(1,1)");
        statement.executeUpdate("create trigger tr1_noTriggerActionColumn after update of status on t1_noTriggerActionColumn referencing new as n_row for each row update t2_noTriggerActionColumn set updates = updates + 1 where t2_noTriggerActionColumn.id = 1");
        statement.executeUpdate("update t1_noTriggerActionColumn set status=-1");
        resultSet = statement.executeQuery("SELECT * FROM t2_noTriggerActionColumn");
        stringArray = new String[][]{{"1", "2"}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testDERBY5121() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE T1 (A1 int)");
        statement.executeUpdate("CREATE TABLE T2 (B1 int, B2 int, B3 int)");
        statement.executeUpdate("CREATE TRIGGER t2UpdateTrigger after UPDATE of b1 on t2 referencing new row as nr for each ROW insert into t1 values ( nr.b3 ) ");
        statement.executeUpdate("INSERT INTO T2 VALUES(0,0,0)");
        statement.executeUpdate("update t2 set b1 = 100 , b2 = 1");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM T1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
        statement.executeUpdate("CREATE TABLE T3 (A1 int)");
        statement.executeUpdate("CREATE TABLE T4 (B1 int, B2 int, B3 int)");
        statement.executeUpdate("CREATE TRIGGER t4UpdateTrigger after UPDATE of b1 on t4 referencing new table as nt for each STATEMENT insert into t3 select b3 from nt");
        statement.executeUpdate("INSERT INTO T4 VALUES(0,0,0)");
        statement.executeUpdate("update t4 set b1 = 100 , b2 = 1");
        resultSet = statement.executeQuery("SELECT * FROM T3");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"0"}});
    }

    public void testClobInTriggerTable() throws SQLException, IOException {
        this.testClobInTriggerTable(1024);
        this.testClobInTriggerTable(16384);
        this.testClobInTriggerTable(Short.MAX_VALUE);
        this.testClobInTriggerTable(32768);
        this.testClobInTriggerTable(32769);
        this.testClobInTriggerTable(65535);
        this.testClobInTriggerTable(65536);
        this.testClobInTriggerTable(65537);
    }

    private void testClobInTriggerTable(int n) throws SQLException, IOException {
        CharAlphabet charAlphabet = CharAlphabet.singleChar('a');
        CharAlphabet charAlphabet2 = CharAlphabet.singleChar('b');
        Object object = " create trigger t_lob1 after update of str1 on lob1 ";
        object = (String)object + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        object = (String)object + " insert into t_lob1_log(oldvalue, newvalue) values (old.str1, new.str1)";
        Statement statement = this.createStatement();
        statement.executeUpdate("create table LOB1 (str1 Varchar(80), c_lob CLOB(50M))");
        statement.executeUpdate("create table t_lob1_log(oldvalue varchar(80), newvalue varchar(80), chng_time timestamp default current_timestamp)");
        statement.executeUpdate((String)object);
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        preparedStatement.setString(1, "" + n);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)n, charAlphabet), n);
        preparedStatement.execute();
        this.closeStatement(preparedStatement);
        this.commit();
        statement.executeUpdate("update LOB1 set str1 = str1 || ' '");
        statement.executeUpdate("drop table lob1");
        statement.executeUpdate("drop table t_lob1_log");
        object = " create trigger t_lob1 after update of c_lob on lob1 ";
        object = (String)object + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        object = (String)object + " insert into t_lob1_log(oldvalue, newvalue) values (old.c_lob, new.c_lob)";
        statement.executeUpdate("create table LOB1 (str1 Varchar(80), c_lob CLOB(50M))");
        statement.executeUpdate("create table t_lob1_log(oldvalue CLOB(50M), newvalue  CLOB(50M), chng_time timestamp default current_timestamp)");
        statement.executeUpdate((String)object);
        this.commit();
        preparedStatement = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        preparedStatement.setString(1, "" + n);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)n, charAlphabet), n);
        preparedStatement.execute();
        this.closeStatement(preparedStatement);
        this.commit();
        preparedStatement = this.prepareStatement("update LOB1 set c_lob = ?");
        preparedStatement.setCharacterStream(1, (Reader)new LoopingAlphabetReader((long)n, charAlphabet2), n);
        preparedStatement.execute();
        this.closeStatement(preparedStatement);
        this.commit();
        statement.executeUpdate("drop table lob1");
        statement.executeUpdate("drop table t_lob1_log");
        object = " create trigger t_lob1 after update of c_lob on lob1 ";
        object = (String)object + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        object = (String)object + " insert into t_lob1_log(oldvalue, newvalue, oldvalue_again, newvalue_again) values (old.c_lob, new.c_lob, old.c_lob, new.c_lob)";
        statement.executeUpdate("create table LOB1 (str1 Varchar(80), c_lob CLOB(50M))");
        statement.executeUpdate("create table t_lob1_log(oldvalue CLOB(50M), newvalue  CLOB(50M), oldvalue_again CLOB(50M), newvalue_again CLOB(50M), chng_time timestamp default current_timestamp)");
        statement.executeUpdate((String)object);
        this.commit();
        preparedStatement = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        preparedStatement.setString(1, "" + n);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)n, charAlphabet), n);
        preparedStatement.execute();
        this.closeStatement(preparedStatement);
        this.commit();
        preparedStatement = this.prepareStatement("update LOB1 set c_lob = ?");
        preparedStatement.setCharacterStream(1, (Reader)new LoopingAlphabetReader((long)n, charAlphabet2), n);
        preparedStatement.execute();
        this.closeStatement(preparedStatement);
        this.commit();
        ResultSet resultSet = statement.executeQuery("SELECT * from t_lob1_log");
        resultSet.next();
        TriggerTest.assertEquals(new LoopingAlphabetReader((long)n, charAlphabet), resultSet.getCharacterStream(1));
        TriggerTest.assertEquals(new LoopingAlphabetReader((long)n, charAlphabet2), resultSet.getCharacterStream(2));
        TriggerTest.assertEquals(new LoopingAlphabetReader((long)n, charAlphabet), resultSet.getCharacterStream(3));
        TriggerTest.assertEquals(new LoopingAlphabetReader((long)n, charAlphabet2), resultSet.getCharacterStream(4));
        resultSet.close();
        statement.executeUpdate("drop table lob1");
        statement.executeUpdate("drop table t_lob1_log");
    }

    public void testBlobInTriggerTable() throws SQLException, IOException {
        this.testBlobInTriggerTable(1024);
        this.testBlobInTriggerTable(16384);
        this.testBlobInTriggerTable(Short.MAX_VALUE);
        this.testBlobInTriggerTable(32768);
        this.testBlobInTriggerTable(32769);
        this.testBlobInTriggerTable(65535);
        this.testBlobInTriggerTable(65536);
        this.testBlobInTriggerTable(65537);
        this.testBlobInTriggerTable(0x700000);
    }

    private void testBlobInTriggerTable(int n) throws SQLException, IOException {
        ByteAlphabet byteAlphabet = ByteAlphabet.singleByte((byte)8);
        ByteAlphabet byteAlphabet2 = ByteAlphabet.singleByte((byte)9);
        Object object = " create trigger t_lob1 after update of str1 on lob1 ";
        object = (String)object + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        object = (String)object + " insert into t_lob1_log(oldvalue, newvalue) values (old.str1, new.str1)";
        Statement statement = this.createStatement();
        statement.executeUpdate("create table LOB1 (str1 Varchar(80), b_lob BLOB(50M), b_lob2 BLOB(50M))");
        statement.executeUpdate("create table t_lob1_log(oldvalue varchar(80), newvalue varchar(80), chng_time timestamp default current_timestamp)");
        statement.executeUpdate((String)object);
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?, ?)");
        preparedStatement.setString(1, "" + n);
        preparedStatement.setBinaryStream(2, (InputStream)new LoopingAlphabetStream((long)n, byteAlphabet), n);
        preparedStatement.setBinaryStream(3, (InputStream)new LoopingAlphabetStream((long)n, byteAlphabet), n);
        preparedStatement.execute();
        this.closeStatement(preparedStatement);
        this.commit();
        statement.executeUpdate("update LOB1 set str1 = str1 || ' '");
        statement.executeUpdate("drop table lob1");
        statement.executeUpdate("drop table t_lob1_log");
        object = " create trigger t_lob1 after update of b_lob on lob1 ";
        object = (String)object + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        object = (String)object + " insert into t_lob1_log(oldvalue, newvalue) values (old.b_lob, new.b_lob)";
        statement.executeUpdate("create table LOB1 (str1 Varchar(80), b_lob BLOB(50M))");
        statement.executeUpdate("create table t_lob1_log(oldvalue BLOB(50M), newvalue  BLOB(50M), chng_time timestamp default current_timestamp)");
        statement.executeUpdate((String)object);
        this.commit();
        preparedStatement = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        preparedStatement.setString(1, "" + n);
        preparedStatement.setBinaryStream(2, (InputStream)new LoopingAlphabetStream((long)n, byteAlphabet), n);
        preparedStatement.execute();
        this.closeStatement(preparedStatement);
        this.commit();
        preparedStatement = this.prepareStatement("update LOB1 set b_lob = ?");
        preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream((long)n, byteAlphabet2), n);
        preparedStatement.execute();
        this.closeStatement(preparedStatement);
        this.commit();
        statement.executeUpdate("drop table lob1");
        statement.executeUpdate("drop table t_lob1_log");
        object = " create trigger t_lob1 after update of b_lob on lob1 ";
        object = (String)object + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        object = (String)object + " insert into t_lob1_log(oldvalue, newvalue, oldvalue_again, newvalue_again) values (old.b_lob, new.b_lob, old.b_lob, new.b_lob)";
        statement.executeUpdate("create table LOB1 (str1 Varchar(80), b_lob BLOB(50M))");
        statement.executeUpdate("create table t_lob1_log(oldvalue BLOB(50M), newvalue  BLOB(50M), oldvalue_again BLOB(50M), newvalue_again BLOB(50M), chng_time timestamp default current_timestamp)");
        statement.executeUpdate((String)object);
        this.commit();
        preparedStatement = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        preparedStatement.setString(1, "" + n);
        preparedStatement.setBinaryStream(2, (InputStream)new LoopingAlphabetStream((long)n, byteAlphabet), n);
        preparedStatement.execute();
        this.closeStatement(preparedStatement);
        this.commit();
        preparedStatement = this.prepareStatement("update LOB1 set b_lob = ?");
        preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream((long)n, byteAlphabet2), n);
        preparedStatement.execute();
        this.closeStatement(preparedStatement);
        this.commit();
        ResultSet resultSet = statement.executeQuery("SELECT * from t_lob1_log");
        resultSet.next();
        TriggerTest.assertEquals(new LoopingAlphabetStream((long)n, byteAlphabet), resultSet.getBinaryStream(1));
        TriggerTest.assertEquals(new LoopingAlphabetStream((long)n, byteAlphabet2), resultSet.getBinaryStream(2));
        TriggerTest.assertEquals(new LoopingAlphabetStream((long)n, byteAlphabet), resultSet.getBinaryStream(3));
        TriggerTest.assertEquals(new LoopingAlphabetStream((long)n, byteAlphabet2), resultSet.getBinaryStream(4));
        resultSet.close();
        statement.executeUpdate("drop table lob1");
        statement.executeUpdate("drop table t_lob1_log");
    }

    public void testUpdateTriggerOnClobColumn() throws SQLException, IOException {
        CharAlphabet charAlphabet = CharAlphabet.singleChar('a');
        CharAlphabet charAlphabet2 = CharAlphabet.singleChar('b');
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        Object object = " create trigger t_lob1 after update of str1 on lob1 ";
        object = (String)object + " REFERENCING OLD AS old NEW AS new FOR EACH ROW MODE DB2SQL ";
        object = (String)object + " insert into t_lob1_log(oldvalue, newvalue) values (old.str1, new.str1)";
        statement.executeUpdate("create table LOB1 (str1 Varchar(80), C_lob CLOB(50M))");
        statement.executeUpdate("create table t_lob1_log(oldvalue varchar(80), newvalue varchar(80), chng_time timestamp default current_timestamp)");
        statement.executeUpdate((String)object);
        connection.commit();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO LOB1 VALUES (?, ?)");
        int n = 65537;
        preparedStatement.setString(1, "" + n);
        preparedStatement.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)n, charAlphabet), n);
        preparedStatement.execute();
        connection.commit();
        PreparedStatement preparedStatement2 = this.prepareStatement("update LOB1 set c_lob = ? where str1 = '" + n + "'");
        preparedStatement2.setCharacterStream(1, (Reader)new LoopingAlphabetReader((long)n, charAlphabet2), n);
        preparedStatement2.executeUpdate();
        connection.commit();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM LOB1 where str1 = '" + n + "'");
        resultSet.next();
        TriggerTest.assertEquals(new LoopingAlphabetReader((long)n, charAlphabet2), resultSet.getCharacterStream(2));
        resultSet.close();
        statement.executeUpdate("drop table lob1");
        statement.executeUpdate("drop table t_lob1_log");
    }

    public void testTypesInActionStatement() throws SQLException, IOException {
        Iterator<String> iterator;
        List<String> list = DatabaseMetaDataTest.getSQLTypes(this.getConnection());
        if (!XML.classpathMeetsXMLReqs()) {
            list.remove("XML");
        }
        if (!JDBC.vmSupportsJDBC3()) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (!string.startsWith("DECIMAL") && !string.startsWith("NUMERIC")) continue;
                iterator.remove();
            }
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            this.actionTypeTest(iterator.next().toString());
        }
    }

    private void actionTypeTest(String string) throws SQLException, IOException {
        TriggerTest.println("actionTypeTest:" + string);
        Statement statement = this.createStatement();
        this.actionTypesSetup(string);
        this.actionTypesInsertTest(string);
        this.actionTypesUpdateTest(string);
        this.actionTypesDeleteTest(string);
        statement.executeUpdate("DROP TABLE T_MAIN");
        statement.executeUpdate("DROP TABLE T_ACTION_ROW");
        statement.executeUpdate("DROP TABLE T_ACTION_STATEMENT");
        statement.close();
        this.commit();
    }

    private void actionTypesSetup(String string) throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE T_MAIN(ID INT  GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V " + string + " )");
        statement.executeUpdate("CREATE TABLE T_ACTION_ROW(ID INT, A CHAR(1), V1 " + string + ", V2 " + string + " )");
        statement.executeUpdate("CREATE TABLE T_ACTION_STATEMENT(ID INT, A CHAR(1), V1 " + string + ", V2 " + string + " )");
        statement.executeUpdate("CREATE TRIGGER AIR AFTER INSERT ON T_MAIN REFERENCING NEW AS N FOR EACH ROW INSERT INTO T_ACTION_ROW(A, V1, ID, V2) VALUES ('I', N.V, N.ID, N.V)");
        statement.executeUpdate("CREATE TRIGGER AIS AFTER INSERT ON T_MAIN REFERENCING NEW TABLE AS N FOR EACH STATEMENT INSERT INTO T_ACTION_STATEMENT(A, V1, ID, V2) SELECT 'I', V, ID, V FROM N");
        statement.executeUpdate("CREATE TRIGGER AUR AFTER UPDATE OF V ON T_MAIN REFERENCING NEW AS N OLD AS O FOR EACH ROW INSERT INTO T_ACTION_ROW(A, V1, ID, V2) VALUES ('U', N.V, N.ID, O.V)");
        statement.executeUpdate("CREATE TRIGGER AUS AFTER UPDATE OF V ON T_MAIN REFERENCING NEW TABLE AS N OLD TABLE AS O FOR EACH STATEMENT INSERT INTO T_ACTION_STATEMENT(A, V1, ID, V2) SELECT 'U', N.V, N.ID, O.V FROM N,O WHERE O.ID = N.ID");
        statement.executeUpdate("CREATE TRIGGER ADR AFTER DELETE ON T_MAIN REFERENCING OLD AS O FOR EACH ROW INSERT INTO T_ACTION_ROW(A, V1, ID, V2) VALUES ('D', O.V, O.ID, O.V)");
        statement.executeUpdate("CREATE TRIGGER ADS AFTER DELETE ON T_MAIN REFERENCING OLD TABLE AS O FOR EACH STATEMENT INSERT INTO T_ACTION_STATEMENT(A, V1, ID, V2) SELECT 'D', O.V, O.ID, O.V FROM O");
        statement.close();
        this.commit();
    }

    private void actionTypesInsertTest(String string) throws SQLException, IOException {
        Statement statement = this.createStatement();
        statement.executeUpdate("INSERT INTO T_MAIN(V) VALUES NULL");
        statement.close();
        this.actionTypesCompareMainToAction(1, string);
        int n = DatabaseMetaDataTest.getJDBCType(string);
        int n2 = DatabaseMetaDataTest.getPrecision(n, string);
        if (n == 2004) {
            return;
        }
        Random random = new Random();
        String string2 = "INSERT INTO T_MAIN(V) VALUES (?)";
        String string3 = "INSERT INTO T_MAIN(V) VALUES (?), (?), (?)";
        if (n == 2009) {
            string2 = "INSERT INTO T_MAIN(V) VALUES XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE)";
            string3 = "INSERT INTO T_MAIN(V) VALUES XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE),XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE),XMLPARSE (DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE)";
        }
        PreparedStatement preparedStatement = this.prepareStatement(string2);
        TriggerTest.setRandomValue(random, preparedStatement, 1, n, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this.actionTypesCompareMainToAction(2, string);
        preparedStatement = this.prepareStatement(string3);
        TriggerTest.setRandomValue(random, preparedStatement, 1, n, n2);
        TriggerTest.setRandomValue(random, preparedStatement, 2, n, n2);
        TriggerTest.setRandomValue(random, preparedStatement, 3, n, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this.actionTypesCompareMainToAction(5, string);
    }

    private void actionTypesUpdateTest(String string) throws SQLException, IOException {
        int n = DatabaseMetaDataTest.getJDBCType(string);
        int n2 = DatabaseMetaDataTest.getPrecision(n, string);
        if (n == 2004) {
            return;
        }
        Statement statement = this.createStatement();
        statement.executeUpdate("UPDATE T_MAIN SET V = NULL WHERE ID = 2");
        statement.close();
        this.commit();
        this.actionTypesCompareMainToActionForUpdate(string, 2);
        Random random = new Random();
        PreparedStatement preparedStatement = this.prepareStatement((n == 2009 ? "UPDATE T_MAIN SET V = XMLPARSE(DOCUMENT CAST (? AS CLOB) PRESERVE WHITESPACE)" : "UPDATE T_MAIN SET V = ?") + " WHERE ID >= ? AND ID <= ?");
        TriggerTest.setRandomValue(random, preparedStatement, 1, n, n2);
        preparedStatement.setInt(2, 3);
        preparedStatement.setInt(3, 3);
        TriggerTest.assertUpdateCount(preparedStatement, 1);
        this.commit();
        this.actionTypesCompareMainToActionForUpdate(string, 3);
        switch (n) {
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                preparedStatement.close();
                return;
            }
        }
        TriggerTest.setRandomValue(random, preparedStatement, 1, n, n2);
        preparedStatement.setInt(2, 4);
        preparedStatement.setInt(3, 5);
        TriggerTest.assertUpdateCount(preparedStatement, 2);
        this.commit();
        this.actionTypesCompareMainToActionForUpdate(string, 4);
        this.actionTypesCompareMainToActionForUpdate(string, 5);
        preparedStatement.close();
    }

    private void actionTypesCompareMainToActionForUpdate(String string, int n) throws SQLException, IOException {
        String string2 = "SELECT M.V, R.V1 FROM T_MAIN M, T_ACTION_ROW R WHERE M.ID = ? AND R.A = 'I' AND M.ID = R.ID";
        String string3 = "SELECT V1, V2 FROM T_ACTION_ROW WHERE A = 'U' AND ID = ?";
        String string4 = "SELECT V1, V2 FROM T_ACTION_STATEMENT WHERE A = 'U' AND ID = ?";
        if ("XML".equals(string)) {
            string2 = "SELECT XMLSERIALIZE(M.V AS CLOB), XMLSERIALIZE(R.V1 AS CLOB) FROM T_MAIN M, T_ACTION_ROW R WHERE M.ID = ? AND R.A = 'I' AND M.ID = R.ID";
            string3 = "SELECT XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_ROW WHERE A = 'U' AND ID = ?";
            string4 = "SELECT XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_STATEMENT WHERE A = 'U' AND ID = ?";
        }
        PreparedStatement preparedStatement = this.prepareStatement(string2);
        PreparedStatement preparedStatement2 = this.prepareStatement(string3);
        PreparedStatement preparedStatement3 = this.prepareStatement(string4);
        preparedStatement.setInt(1, n);
        preparedStatement2.setInt(1, n);
        preparedStatement3.setInt(1, n);
        JDBC.assertSameContents(preparedStatement.executeQuery(), preparedStatement2.executeQuery());
        JDBC.assertSameContents(preparedStatement.executeQuery(), preparedStatement3.executeQuery());
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
        this.commit();
    }

    private void actionTypesDeleteTest(String string) throws SQLException, IOException {
        int n = DatabaseMetaDataTest.getJDBCType(string);
        int n2 = DatabaseMetaDataTest.getPrecision(n, string);
        if (n == 2004) {
            return;
        }
        Statement statement = this.createStatement();
        TriggerTest.assertUpdateCount(statement, 1, "DELETE FROM T_MAIN WHERE ID = 3");
        this.commit();
        TriggerTest.assertUpdateCount(statement, 4, "DELETE FROM T_MAIN");
        this.commit();
        statement.close();
    }

    private void actionTypesCompareMainToAction(int n, String string) throws SQLException, IOException {
        Statement statement = this.createStatement();
        Statement statement2 = this.createStatement();
        String string2 = "SELECT ID, V, V FROM T_MAIN ORDER BY 1";
        String string3 = "SELECT ID, V1, V2 FROM T_ACTION_ROW ORDER BY 1";
        String string4 = "SELECT ID, V1, V2 FROM T_ACTION_STATEMENT ORDER BY 1";
        if ("XML".equals(string)) {
            string2 = "SELECT ID, XMLSERIALIZE(V AS CLOB), XMLSERIALIZE(V AS CLOB) FROM T_MAIN ORDER BY 1";
            string3 = "SELECT ID, XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_ROW ORDER BY 1";
            string4 = "SELECT ID, XMLSERIALIZE(V1 AS CLOB), XMLSERIALIZE(V2 AS CLOB) FROM T_ACTION_STATEMENT ORDER BY 1";
        }
        ResultSet resultSet = statement.executeQuery(string2);
        ResultSet resultSet2 = statement2.executeQuery(string3);
        JDBC.assertSameContents(resultSet, resultSet2);
        resultSet = statement.executeQuery(string2);
        resultSet2 = statement2.executeQuery(string4);
        JDBC.assertSameContents(resultSet, resultSet2);
        this.assertTableRowCount("T_ACTION_ROW", n);
        this.assertTableRowCount("T_ACTION_STATEMENT", n);
        statement.close();
        statement2.close();
    }

    public static void setRandomValue(Random random, PreparedStatement preparedStatement, int n, int n2, int n3) throws SQLException, IOException {
        Object object = TriggerTest.getRandomValue(random, n2, n3);
        if (object instanceof StringReaderWithLength) {
            StringReaderWithLength stringReaderWithLength = (StringReaderWithLength)object;
            preparedStatement.setCharacterStream(n, (Reader)stringReaderWithLength, stringReaderWithLength.getLength());
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            preparedStatement.setBinaryStream(n, inputStream, inputStream.available());
        } else {
            preparedStatement.setObject(n, object, n2);
        }
    }

    public static Object getRandomValue(Random random, int n, int n2) throws IOException {
        switch (n) {
            case 5: {
                return (short)random.nextInt();
            }
            case 4: {
                return random.nextInt();
            }
            case -5: {
                return random.nextLong();
            }
            case 6: 
            case 7: {
                return Float.valueOf(random.nextFloat());
            }
            case 8: {
                return random.nextDouble();
            }
            case 91: {
                long l = random.nextLong();
                if (l < 0L) {
                    l = -l;
                }
                l /= 86400000L;
                l %= 1460000L;
                return new Date(l *= 86400000L);
            }
            case 92: {
                long l = random.nextLong();
                if (l < 0L) {
                    l = -l;
                }
                return new Time(l % 86400000L);
            }
            case 93: {
                long l = random.nextLong();
                if (l < 0L) {
                    l = -l;
                }
                return new Timestamp(l %= 126144000000000L);
            }
            case 1: 
            case 12: {
                return TriggerTest.randomString(random, random.nextInt(n2 + 1));
            }
            case -1: {
                return new StringReaderWithLength(TriggerTest.randomString(random, random.nextInt(32701)));
            }
            case 2005: {
                if (n2 > 262144) {
                    n2 = 262144;
                }
                return new StringReaderWithLength(TriggerTest.randomString(random, random.nextInt(n2)));
            }
            case -3: 
            case -2: {
                return TriggerTest.randomBinary(random, random.nextInt(n2 + 1));
            }
            case -4: {
                return new ReadOnceByteArrayInputStream(TriggerTest.randomBinary(random, random.nextInt(32701)));
            }
            case 2004: {
                if (n2 > 262144) {
                    n2 = 262144;
                }
                return new ReadOnceByteArrayInputStream(TriggerTest.randomBinary(random, random.nextInt(n2)));
            }
            case 2009: {
                return new StringReaderWithLength("<a><b>text</b></a>");
            }
        }
        return null;
    }

    private static byte[] randomBinary(Random random, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)random.nextInt();
        }
        return byArray;
    }

    private static String randomString(Random random, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)random.nextInt(65535);
        }
        return new String(cArray);
    }

    public void testDerby4095OldTriggerRows() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE APP.TAB (I INT)");
        statement.executeUpdate("CREATE TABLE APP.LOG (I INT, NAME VARCHAR(30), DELTIME TIMESTAMP)");
        statement.executeUpdate("CREATE TABLE APP.NAMES(ID INT, NAME VARCHAR(30))");
        statement.executeUpdate("CREATE TRIGGER  APP.MYTRIG AFTER DELETE ON APP.TAB REFERENCING OLD_TABLE AS OLDROWS FOR EACH STATEMENT INSERT INTO APP.LOG(i,name,deltime) SELECT OLDROWS.I, NAMES.NAME, CURRENT_TIMESTAMP FROM --DERBY-PROPERTIES joinOrder=FIXED\n NAMES, OLDROWS --DERBY-PROPERTIES joinStrategy = NESTEDLOOP\n WHERE (OLDROWS.i = NAMES.ID) AND (1 = 1)");
        statement.executeUpdate("insert into APP.tab values(1)");
        statement.executeUpdate("insert into APP.tab values(2)");
        statement.executeUpdate("insert into APP.tab values(3)");
        statement.executeUpdate("insert into APP.names values(1,'Charlie')");
        statement.executeUpdate("insert into APP.names values(2,'Hugh')");
        statement.executeUpdate("insert into APP.names values(3,'Alex')");
        statement.executeUpdate("delete from tab where i = 1");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM APP.LOG");
        JDBC.assertDrainResults(resultSet, 1);
        statement.executeUpdate("DROP TABLE APP.TAB");
        statement.executeUpdate("DROP TABLE APP.LOG");
        statement.executeUpdate("DROP TABLE APP.NAMES");
    }

    public void testDerby4095NewTriggerRows() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE APP.TAB (I INT)");
        statement.executeUpdate("CREATE TABLE APP.LOG (I INT, NAME VARCHAR(30), UPDTIME TIMESTAMP, NEWVALUE INT)");
        statement.executeUpdate("CREATE TABLE APP.NAMES(ID INT, NAME VARCHAR(30))");
        statement.executeUpdate("CREATE TRIGGER  APP.MYTRIG AFTER UPDATE ON APP.TAB REFERENCING OLD_TABLE AS OLDROWS NEW_TABLE AS NEWROWS FOR EACH STATEMENT INSERT INTO APP.LOG(i,name,updtime,newvalue) SELECT OLDROWS.I, NAMES.NAME, CURRENT_TIMESTAMP, NEWROWS.I  FROM --DERBY-PROPERTIES joinOrder=FIXED\n NAMES, NEWROWS --DERBY-PROPERTIES joinStrategy = NESTEDLOOP\n ,OLDROWS WHERE (NEWROWS.i = NAMES.ID) AND (1 = 1)");
        statement.executeUpdate("insert into tab values(1)");
        statement.executeUpdate("insert into tab values(2)");
        statement.executeUpdate("insert into tab values(3)");
        statement.executeUpdate("insert into names values(1,'Charlie')");
        statement.executeUpdate("insert into names values(2,'Hugh')");
        statement.executeUpdate("insert into names values(3,'Alex')");
        statement.executeUpdate("update tab set i=1 where i = 1");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM APP.LOG");
        JDBC.assertDrainResults(resultSet, 1);
        statement.executeUpdate("DROP TABLE APP.TAB");
        statement.executeUpdate("DROP TABLE APP.LOG");
        statement.executeUpdate("DROP TABLE APP.NAMES");
    }

    public void testDerby4610WrongDataType() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table testtable (id integer, name varchar(20), primary key(id))");
        statement.execute("create table testchild (id integer constraint fk_id references testtable on delete cascade, ordernum int, primary key(id))");
        statement.execute("create procedure testproc (str varchar(20)) PARAMETER STYLE JAVA LANGUAGE JAVA EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".derby4610proc'");
        statement.execute("create trigger testtabletrigger after delete on testtable referencing old as old for each row mode db2sql call testproc(char(old.id))");
        statement.execute("create trigger testchildtrigger after delete on testchild referencing old as old for each row mode db2sql call testproc(char(old.ordernum))");
        statement.execute("insert into testtable values (1, 'test1')");
        statement.execute("insert into testchild values (1, 10)");
        TriggerTest.assertUpdateCount(statement, 1, "delete from testtable where id = 1");
    }

    public static void derby4610proc(String string) {
    }

    public void testDerby6351TransitionTableCorrelation() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table t1(x int)");
        statement.execute("create table t2(x varchar(10), y int)");
        statement.execute("create trigger tr1 after insert on t1 referencing new table as n insert into t2 select 'tr1', x from n n");
        statement.execute("create trigger tr2 after update on t1 referencing old table as o insert into t2 select 'tr2', x from o o");
        statement.execute("create trigger tr3 after insert on t1 referencing new table as n insert into t2 select 'tr3', x from n");
        statement.execute("create trigger tr4 after update on t1 referencing old table as o insert into t2 select 'tr4', x from o");
        statement.execute("create trigger tr5 after insert on t1 referencing new table as n insert into t2 select 'tr5', n1.x from n n1");
        statement.execute("create trigger tr6 after update on t1 referencing old table as o insert into t2 select 'tr6', o1.x from o o1");
        statement.execute("insert into t1 values 1,2");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t2 order by x, y"), new String[][]{{"tr1", "1"}, {"tr1", "2"}, {"tr3", "1"}, {"tr3", "2"}, {"tr5", "1"}, {"tr5", "2"}});
        statement.execute("delete from t2");
        statement.execute("update t1 set x = x + 1 where x = 1");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t2 order by x, y"), new String[][]{{"tr2", "1"}, {"tr4", "1"}, {"tr6", "1"}});
    }

    public void testDerby6357TempTable() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("declare global temporary table temptable(x int) not logged");
        statement.execute("create table t1(x int)");
        statement.execute("create table t2(i int, b boolean)");
        this.assertCompileError("XCL51", "create trigger tr1 after insert on session.temptable referencing new table as new insert into t1(i) select x from new");
        this.assertCompileError("XCL51", "create trigger tr2 after insert on t1 insert into t2(i) select x from session.temptable");
        this.assertCompileError("XCL51", "create trigger tr3 after insert on t1 insert into session.temptable values 1");
        this.assertCompileError("XCL51", "create trigger tr4 after insert on t1 insert into t2(b) values exists(select * from session.temptable)");
        this.assertCompileError("XCL51", "create trigger tr5 after insert on t1 insert into t2(i) values case when exists(select * from session.temptable) then 1 else 2 end");
        this.assertCompileError("XCL51", "create trigger tr6 after insert on t1 insert into t2(b) values (select count(*) from session.temptable) = (select count(*) from sysibm.sysdummy1)");
        this.assertCompileError("XCL51", "create trigger tr7 after insert on t1 merge into t2 using session.temptable on i=x when matched then delete");
        this.assertCompileError("XCL51", "create trigger tr8 after insert on t1 merge into session.temptable using t2 on i=x when matched then delete");
        this.assertCompileError("XCL51", "create trigger tr9 after insert on t1 merge into t2 using t1 on exists(select * from session.temptable where t1.x=t2.i) when matched then delete");
    }

    public void testDerby6371DropColumn() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create schema d6371_s1");
        statement.execute("create schema d6371_s2");
        statement.execute("create table d6371_s1.t1(x int, y int)");
        statement.execute("create table d6371_s1.t2(x int, y int)");
        statement.execute("set schema 'D6371_S1'");
        this.commit();
        statement.execute("create trigger d6371_s2.tr1 after update of x on t1 for each row insert into t2(x) select x from t1");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "alter table t1 drop column x restrict");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "alter table t2 drop column x restrict");
        statement.execute("alter table t1 drop column y restrict");
        statement.execute("alter table t2 drop column y restrict");
        statement.execute("insert into t1 values 1");
        statement.execute("update t1 set x = x + 1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from t2"), "2");
        this.rollback();
        Connection connection = this.openDefaultConnection("D6371_USER_WITHOUT_SCHEMA", "secret");
        Statement statement2 = connection.createStatement();
        statement2.execute("create trigger d6371_s1.tr2 after update of x on d6371_s1.t1 for each row insert into d6371_s1.t2(x) select x from d6371_s1.t1");
        statement2.close();
        connection.commit();
        connection.close();
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "alter table t1 drop column x restrict");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "alter table t2 drop column x restrict");
        statement.execute("alter table t1 drop column y restrict");
        statement.execute("alter table t2 drop column y restrict");
        statement.execute("insert into t1 values 1");
        statement.execute("update t1 set x = x + 1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from t2"), "2");
    }

    public void testDerby6348() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d6348(x int)");
        statement.execute("insert into d6348 values 1");
        statement.execute("create trigger d6348_tr1 after update on d6348 values 1");
        statement.execute("create trigger d6348_tr2 after update on d6348 for each row update d6348 set x = x + 1 where x < 3");
        statement.execute("update d6348 set x = x + 1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from d6348"), "3");
        this.rollback();
        statement.execute("create table d6348(x int)");
        statement.execute("create trigger d6348_tr1 after insert on d6348 values current_user");
        statement.execute("create trigger d6348_tr2 after insert on d6348 values current_user");
        statement.execute("insert into d6348 values 1");
    }

    public void testDerby2041DropDependencies() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table t1(x int, y int, z int)");
        statement.execute("create table t2(x int, y int, z int)");
        statement.execute("create table syn_table(x int, y int, z int)");
        statement.execute("create table view_table(x int, y int, z int)");
        statement.execute("create function f(x int) returns int language java parameter style java external name 'java.lang.Math.abs'");
        statement.execute("create procedure p() language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".dummyProc' no sql");
        statement.execute("create function tf() returns table (x int) language java parameter style derby_jdbc_result_set external name '" + ((Object)((Object)this)).getClass().getName() + ".dummyTableFunction' no sql");
        statement.execute("create derby aggregate intmode for int external name '" + ModeAggregate.class.getName() + "'");
        statement.execute("create sequence seq");
        statement.execute("create synonym syn for syn_table");
        statement.execute("create view v(x) as select x from view_table");
        statement.execute("create type tp external name 'java.util.List' language java");
        statement.execute("create trigger tr_t2 after insert on t1 select x from t2");
        statement.execute("create trigger tr_f after insert on t1 values f(1)");
        statement.execute("create trigger tr_p after insert on t1 call p()");
        statement.execute("create trigger tr_tf after insert on t1 select * from table(tf()) t");
        statement.execute("create trigger tr_intmode after insert on t1 select intmode(x) from (values 1,2,3) v(x)");
        statement.execute("create trigger tr_seq after insert on t1 values next value for seq");
        statement.execute("create trigger tr_syn after insert on t1 select * from syn");
        statement.execute("create trigger tr_v after insert on t1 select * from v");
        statement.execute("create trigger tr_tp after insert on t1 values cast(null as tp)");
        PreparedStatement preparedStatement = this.prepareStatement("select triggername from sys.systriggers join sys.sysschemas using (schemaid) where triggername = ? and schemaname = ?");
        preparedStatement.setString(2, this.getTestConfiguration().getUserName());
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "drop table t2");
        preparedStatement.setString(1, "TR_T2");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "TR_T2");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "drop function f");
        preparedStatement.setString(1, "TR_F");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "TR_F");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "drop procedure p");
        preparedStatement.setString(1, "TR_P");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "TR_P");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "drop function tf");
        preparedStatement.setString(1, "TR_TF");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "TR_TF");
        TriggerTest.assertStatementError(SYNTAX_ERROR, statement, "drop derby aggregate intmode cascade");
        TriggerTest.assertStatementError(HAS_DEPENDENT_SPS, statement, "drop derby aggregate intmode restrict");
        preparedStatement.setString(1, "TR_INTMODE");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "TR_INTMODE");
        TriggerTest.assertStatementError(SYNTAX_ERROR, statement, "drop sequence seq cascade");
        TriggerTest.assertStatementError(HAS_DEPENDENT_SPS, statement, "drop sequence seq restrict");
        preparedStatement.setString(1, "TR_SEQ");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "TR_SEQ");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "drop synonym syn");
        preparedStatement.setString(1, "TR_SYN");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "TR_SYN");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "drop view v");
        preparedStatement.setString(1, "TR_V");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "TR_V");
        TriggerTest.assertStatementError(SYNTAX_ERROR, statement, "drop type tp cascade");
        TriggerTest.assertStatementError(HAS_DEPENDENT_SPS, statement, "drop type tp restrict");
        preparedStatement.setString(1, "TR_TP");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "TR_TP");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "alter table t2 drop column x restrict");
        preparedStatement.setString(1, "TR_T2");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "TR_T2");
        statement.execute("alter table t2 drop column y restrict");
        TriggerTest.assertNull((Object)statement.getWarnings());
        preparedStatement.setString(1, "TR_T2");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "TR_T2");
        JDBC.assertColumnNames(statement.executeQuery("select * from t2"), "X", "Z");
        statement.execute("alter table t2 drop column x cascade");
        TriggerTest.assertSQLState(TRIGGER_DROPPED, statement.getWarnings());
        preparedStatement.setString(1, "TR_T2");
        JDBC.assertEmpty(preparedStatement.executeQuery());
        JDBC.assertColumnNames(statement.executeQuery("select * from t2"), "Z");
    }

    public void testDerby2041RecompileOnly() throws SQLException {
        Statement statement = this.createStatement();
        PreparedStatement preparedStatement = this.prepareStatement("select valid from sys.sysschemas join sys.systriggers using (schemaid) join sys.sysstatements on stmtid = actionstmtid where schemaname = ? and triggername = ?");
        preparedStatement.setString(1, this.getTestConfiguration().getUserName());
        preparedStatement.setString(2, "TR");
        statement.execute("create table t1(x int not null)");
        statement.execute("create table t2(x int not null)");
        statement.execute("create index idx on t2(x)");
        statement.execute("create trigger tr after insert on t1 insert into t2 values 1");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "true");
        statement.execute("drop index idx");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "false");
        statement.execute("insert into t1 values 1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from t2"), "1");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "true");
        statement.execute("truncate table t2");
        this.assertTableRowCount("T2", 0);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "false");
        statement.execute("insert into t1 values 1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from t2"), "1");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "true");
        statement.execute("drop trigger tr");
        statement.execute("alter table t2 add constraint t2_pk primary key (x)");
        statement.execute("create table t3(x int, y int references t2 on delete cascade)");
        statement.execute("create trigger tr after delete on t1 delete from t2");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "true");
        TriggerTest.assertStatementError(HAS_DEPENDENT_TRIGGER, statement, "drop table t3");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "true");
    }

    public static void dummyProc() {
    }

    public static ResultSet dummyTableFunction() {
        return null;
    }

    public void testDerby6540TransitionTableNameClash() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d6540_t1(x int)");
        statement.execute("create table d6540_t2(y int)");
        statement.execute("create table d6540_t3(z int)");
        statement.execute("create trigger d6540_tr after insert on d6540_t1 referencing new table as d6540_t2 insert into d6540_t3 select x from d6540_t2 union all select y from app.d6540_t2");
        PreparedStatement preparedStatement = this.prepareStatement("select * from d6540_t3 order by z");
        JDBC.assertEmpty(preparedStatement.executeQuery());
        statement.execute("insert into d6540_t1 values 1");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        statement.execute("insert into d6540_t2 values 2, 3");
        statement.execute("insert into d6540_t1 values 4, 5");
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}});
        statement.execute("truncate table d6540_t1");
        statement.execute("truncate table d6540_t2");
        statement.execute("truncate table d6540_t3");
        statement.execute("drop trigger d6540_tr");
        statement.execute("create trigger d6540_tr after insert on d6540_t1 referencing new as d6540_t2 for each row insert into d6540_t3 select * from app.d6540_t2 where d6540_t2.x = app.d6540_t2.y");
        JDBC.assertEmpty(preparedStatement.executeQuery());
        statement.execute("insert into d6540_t1 values 1");
        JDBC.assertEmpty(preparedStatement.executeQuery());
        statement.execute("insert into d6540_t2 values 1, 2, 3");
        statement.execute("insert into d6540_t1 values 2, 3, 4");
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"2"}, {"3"}});
        statement.execute("drop trigger d6540_tr");
        statement.execute("create table d6540_t4(c1 int, c2 int)");
        statement.execute("create trigger d6540_tr after insert on d6540_t1 referencing new as d6540_t2 for each row insert into d6540_t4 select y, d6540_t2.x from d6540_t2");
        statement.execute("insert into d6540_t1 values 1");
        JDBC.assertFullResultSet(statement.executeQuery("select * from d6540_t4 order by c1"), new String[][]{{"1", "1"}, {"2", "1"}, {"3", "1"}});
        this.assertCompileError(SYNTAX_ERROR, "create trigger d6540_tr1 after insert on d6540_t1 referencing new table as app.n values 1");
        this.assertCompileError(SYNTAX_ERROR, "create trigger d6540_tr2 after insert on d6540_t1 referencing new as app.n for each row values 1");
    }

    public void testDerby6543() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d6543_1(x int)");
        statement.execute("create table d6543_2(x int)");
        statement.execute("create trigger d6543_tr after insert on d6543_1 referencing new as new for each row insert into d6543_2 select x from d6543_1 where new . x = x");
        TriggerTest.assertUpdateCount(statement, 4, "insert into d6543_1 values 1, 2, 2, 3");
        JDBC.assertFullResultSet(statement.executeQuery("select * from d6543_2 order by x"), new String[][]{{"1"}, {"2"}, {"2"}, {"2"}, {"2"}, {"3"}});
    }

    public void testQualifiedNamesInSystemTables() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create schema d6370");
        statement.execute("set schema d6370");
        statement.execute("create table t1(x int, y int, z int)");
        statement.execute("create table t2(x int, y int, z int)");
        statement.execute("create table t3(x int, y int, z int)");
        statement.execute("create table syn_table(x int, y int, z int)");
        statement.execute("create table view_table(x int, y int, z int)");
        statement.execute("create function f(x int) returns int language java parameter style java external name 'java.lang.Math.abs'");
        statement.execute("create procedure p() language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".dummyProc' no sql");
        statement.execute("create function tf() returns table (x int) language java parameter style derby_jdbc_result_set external name '" + ((Object)((Object)this)).getClass().getName() + ".dummyTableFunction' no sql");
        statement.execute("create derby aggregate intmode for int external name '" + ModeAggregate.class.getName() + "'");
        statement.execute("create sequence seq");
        statement.execute("create synonym syn for syn_table");
        statement.execute("create view v(x) as select x from view_table");
        statement.execute("create type tp external name 'java.util.List' language java");
        statement.execute("create table tp_t1(x tp)");
        statement.execute("create table tp_t2(x tp)");
        statement.execute("create trigger tr01 no cascade before insert on t1 when (exists(select f(y) from v join t1 t on v.x = t.x)) call p()");
        statement.execute("create trigger tr02 after insert on t1 when (exists(select * from table(tf()) t)) insert into t2(z) select 1 from t1");
        statement.execute("create trigger tr03 after delete on t1 insert into t2(z) select intmode(x) from syn");
        statement.execute("create trigger tr04 after insert on tp_t1 referencing new as new for each row insert into tp_t2 values new.x, cast(null as tp)");
        statement.execute("create trigger tr05 after insert on t1 referencing new table as new when (next value for seq < 1000) insert into t2(y) select a.z from new a, t1 b, new c, t1 d");
        statement.execute("create trigger tr06 after insert on t1 update t2 set t2.x = t2.y");
        statement.execute("create trigger tr07 after insert on t1 insert into t2 (t2.x, t2.y) values (1, default)");
        statement.execute("create trigger tr08 after update on t1 delete from t2 where t2.x = t2.y");
        statement.execute("create trigger tr09 after delete on t1 merge into t2 using t3 on t2.x = t3.x when matched and t3.y = 5 then update set t2.x = t3.y when not matched then insert values (t3.x, t3.y, t3.z)");
        statement.execute("create trigger tr10 after insert on t1 referencing new as new for each row update t2 set x = (select count(*) from t1 where new.x = t2.x)");
        statement.execute("create trigger tr11 after insert on t1 for each row values sin(0)");
        statement.execute("create function sin(x double) returns double language java parameter style java external name 'java.lang.Math.sin'");
        statement.execute("create trigger tr12 after insert on t1 for each row values sin(0)");
        String[][] stringArray = new String[][]{{"TR01", "exists(select \"D6370\".\"F\"(y) from \"D6370\".\"V\" join \"D6370\".\"T1\" t on \"V\".x = \"T\".x)", "VALUES exists(select \"D6370\".\"F\"(y) from \"D6370\".\"V\" join \"D6370\".\"T1\" t on \"V\".x = \"T\".x)", "call \"D6370\".\"P\"()", "call \"D6370\".\"P\"()"}, {"TR02", "exists(select * from table(\"D6370\".\"TF\"()) t)", "VALUES exists(select * from table(\"D6370\".\"TF\"()) t)", "insert into \"D6370\".\"T2\"(z) select 1 from \"D6370\".\"T1\"", "insert into \"D6370\".\"T2\"(z) select 1 from \"D6370\".\"T1\""}, {"TR03", null, null, "insert into \"D6370\".\"T2\"(z) select \"D6370\".\"INTMODE\"(x) from \"D6370\".\"SYN\"", "insert into \"D6370\".\"T2\"(z) select \"D6370\".\"INTMODE\"(x) from \"D6370\".\"SYN\""}, {"TR04", null, null, "insert into \"D6370\".\"TP_T2\" values new.x, cast(null as \"D6370\".\"TP\")", "insert into \"D6370\".\"TP_T2\" values CAST (org.apache.derby.iapi.db.Factory::getTriggerExecutionContext().getNewRow().getObject(1) AS \"D6370\".\"TP\") , cast(null as \"D6370\".\"TP\")"}, {"TR05", "next value for \"D6370\".\"SEQ\" < 1000", "VALUES next value for \"D6370\".\"SEQ\" < 1000", "insert into \"D6370\".\"T2\"(y) select \"A\".z from new a, \"D6370\".\"T1\" b, new c, \"D6370\".\"T1\" d", "insert into \"D6370\".\"T2\"(y) select \"A\".z from new org.apache.derby.catalog.TriggerNewTransitionRows()  a, \"D6370\".\"T1\" b, new org.apache.derby.catalog.TriggerNewTransitionRows()  c, \"D6370\".\"T1\" d"}, {"TR06", null, null, "update \"D6370\".\"T2\" set t2.x = \"T2\".y", "update \"D6370\".\"T2\" set t2.x = \"T2\".y"}, {"TR07", null, null, "insert into \"D6370\".\"T2\" (t2.x, t2.y) values (1, default)", "insert into \"D6370\".\"T2\" (t2.x, t2.y) values (1, default)"}, {"TR08", null, null, "delete from \"D6370\".\"T2\" where \"D6370\".\"T2\".x = \"D6370\".\"T2\".y", "delete from \"D6370\".\"T2\" where \"D6370\".\"T2\".x = \"D6370\".\"T2\".y"}, {"TR09", null, null, "merge into \"D6370\".\"T2\" using \"D6370\".\"T3\" on \"D6370\".\"T2\".x = \"D6370\".\"T3\".x when matched and \"D6370\".\"T3\".y = 5 then update set t2.x = \"D6370\".\"T3\".y when not matched then insert values (\"D6370\".\"T3\".x, \"D6370\".\"T3\".y, \"D6370\".\"T3\".z)", "merge into \"D6370\".\"T2\" using \"D6370\".\"T3\" on \"D6370\".\"T2\".x = \"D6370\".\"T3\".x when matched and \"D6370\".\"T3\".y = 5 then update set t2.x = \"D6370\".\"T3\".y when not matched then insert values (\"D6370\".\"T3\".x, \"D6370\".\"T3\".y, \"D6370\".\"T3\".z)"}, {"TR10", null, null, "update \"D6370\".\"T2\" set x = (select count(*) from \"D6370\".\"T1\" where new.x = \"D6370\".\"T2\".x)", "update \"D6370\".\"T2\" set x = (select count(*) from \"D6370\".\"T1\" where CAST (org.apache.derby.iapi.db.Factory::getTriggerExecutionContext().getNewRow().getObject(1) AS INTEGER)  = \"D6370\".\"T2\".x)"}, {"TR11", null, null, "values \"SYSFUN\".\"SIN\"(0)", "values \"SYSFUN\".\"SIN\"(0)"}, {"TR12", null, null, "values \"D6370\".\"SIN\"(0)", "values \"D6370\".\"SIN\"(0)"}};
        ResultSet resultSet = statement.executeQuery("select triggername, whenclausetext, s1.text, triggerdefinition, s2.text from sys.systriggers join sys.sysschemas using (schemaid) left join sys.sysstatements s1 on whenstmtid = stmtid join sys.sysstatements s2 on actionstmtid = s2.stmtid where schemaname = 'D6370' order by triggername");
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("insert into tp_t1 values cast(null as tp)");
    }

    public void testDerby6663() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d6663_t1(pk int primary key)");
        statement.execute("create table d6663_t2(x int references d6663_t1)");
        statement.execute("create table d6663_t3(y int)");
        statement.execute("create trigger d6663_tr after insert on d6663_t3 referencing new as new for each row insert into d6663_t2 values new.y");
        TriggerTest.assertStatementError(FOREIGN_KEY_VIOLATION, statement, "insert into d6663_t3 values 1");
        statement.execute("insert into d6663_t1 values 1");
        statement.execute("insert into d6663_t3 values 1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from d6663_t2"), "1");
    }
}

