/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.Connection;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derby.tools.dblook;
import org.apache.derbyTesting.functionTests.tests.tools.dblook_test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Test_6661
extends BaseJDBCTestCase {
    private static final String[][] EXPECTED_CONSTRAINT_STATE = new String[][]{{"CHECK6661_INIT_DEFERRED", "e"}, {"CHECK6661_INIT_IMMEDIATE", "i"}, {"CHECK6661_VANILLA", "E"}, {"TPRIM6661_INIT_DEFERRED", "e"}, {"TPRIM6661_INIT_IMMEDIATE", "i"}, {"TPRIM6661_VANILLA", "E"}, {"TREF6661_INIT_DEFERRED", "e"}, {"TREF6661_INIT_IMMEDIATE", "i"}, {"TREF6661_VANILLA", "E"}, {"TUNIQUE6661_INIT_DEFERRED", "e"}, {"TUNIQUE6661_INIT_IMMEDIATE", "i"}, {"TUNIQUE6661_VANILLA", "E"}};
    private static final String DBLOOK_OUTPUT = SupportFilesSetup.getReadWrite("dblookOutput.sql").getPath();

    public Test_6661(String string) {
        super(string);
    }

    public static Test suite() {
        SupportFilesSetup supportFilesSetup;
        BaseTestSuite baseTestSuite = new BaseTestSuite(Test_6661.class, "Test_6661");
        TestSetup testSetup = TestConfiguration.singleUseDatabaseDecorator((Test)baseTestSuite);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)testSetup);
        SupportFilesSetup supportFilesSetup2 = supportFilesSetup = new SupportFilesSetup((Test)cleanDatabaseTestSetup);
        return supportFilesSetup2;
    }

    public void test_01() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create table tprim6661_vanilla\n(\n    keyCol  int not null,\n    constraint tprim6661_vanilla primary key( keyCol )\n)\n");
        this.goodStatement(connection, "create table tprim6661_init_deferred\n(\n    keyCol  int not null,\n    constraint tprim6661_init_deferred primary key( keyCol ) deferrable initially deferred\n)\n");
        this.goodStatement(connection, "create table tprim6661_init_immediate\n(\n    keyCol  int not null,\n    constraint tprim6661_init_immediate primary key( keyCol ) deferrable\n)\n");
        this.goodStatement(connection, "create table tunique6661_vanilla\n(\n    keyCol  int not null,\n    constraint tunique6661_vanilla primary key( keyCol )\n)\n");
        this.goodStatement(connection, "create table tunique6661_init_deferred\n(\n    keyCol  int not null,\n    constraint tunique6661_init_deferred primary key( keyCol ) deferrable initially deferred\n)\n");
        this.goodStatement(connection, "create table tunique6661_init_immediate\n(\n    keyCol  int not null,\n    constraint tunique6661_init_immediate primary key( keyCol ) deferrable\n)\n");
        this.goodStatement(connection, "create table tref6661\n(\n    tref6661_vanilla int,\n    tref6661_init_deferred int,\n    tref6661_init_immediate int,\n\n    constraint tref6661_vanilla foreign key( tref6661_vanilla ) references tprim6661_vanilla( keyCol ),\n    constraint tref6661_init_deferred foreign key( tref6661_init_deferred ) references tprim6661_vanilla( keyCol ) deferrable initially deferred,\n    constraint tref6661_init_immediate foreign key( tref6661_init_immediate ) references tprim6661_vanilla( keyCol ) deferrable\n)\n");
        this.goodStatement(connection, "create table tcheck6661\n(\n    a int,\n\n    constraint check6661_vanilla check( a > 0 ),\n    constraint check6661_init_deferred check( a > 10 ) deferrable initially deferred,\n    constraint check6661_init_immediate check( a > 100 ) deferrable\n)\n");
        String string = "select constraintname, state from sys.sysconstraints order by constraintname";
        this.assertResults(connection, string, EXPECTED_CONSTRAINT_STATE, true);
        TestConfiguration testConfiguration = this.getTestConfiguration();
        String string2 = testConfiguration.getPhysicalDatabaseName(testConfiguration.getDefaultDatabaseName());
        new dblook(new String[]{"-d", "jdbc:derby:" + string2, "-o", DBLOOK_OUTPUT});
        this.goodStatement(connection, "drop table tcheck6661");
        this.goodStatement(connection, "drop table tref6661");
        this.goodStatement(connection, "drop table tunique6661_init_immediate");
        this.goodStatement(connection, "drop table tunique6661_init_deferred");
        this.goodStatement(connection, "drop table tunique6661_vanilla");
        this.goodStatement(connection, "drop table tprim6661_init_immediate");
        this.goodStatement(connection, "drop table tprim6661_init_deferred");
        this.goodStatement(connection, "drop table tprim6661_vanilla");
        this.assertResults(connection, string, new String[0][], true);
        dblook_test.runDDL(connection, DBLOOK_OUTPUT);
        this.assertResults(connection, string, EXPECTED_CONSTRAINT_STATE, true);
    }
}

