/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

abstract class CanonTestCase
extends BaseJDBCTestCase {
    static final String DEFAULT_ENCODING = "US-ASCII";
    final String outputEncoding;
    private ByteArrayOutputStream rawBytes;

    CanonTestCase(String string) {
        this(string, null);
    }

    CanonTestCase(String string, String string2) {
        super(string);
        this.outputEncoding = string2 == null ? DEFAULT_ENCODING : string2;
    }

    OutputStream getOutputStream() {
        this.rawBytes = new ByteArrayOutputStream(20480);
        return this.rawBytes;
    }

    void compareCanon(String string) throws Throwable {
        this.rawBytes.flush();
        this.rawBytes.close();
        byte[] byArray = this.rawBytes.toByteArray();
        this.rawBytes = null;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        try {
            URL uRL = CanonTestCase.getTestResource(string);
            CanonTestCase.assertNotNull((String)("No master file " + string), (Object)uRL);
            InputStream inputStream = CanonTestCase.openTestResource(uRL);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.outputEncoding));
            bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), this.outputEncoding));
            int n = 1;
            while (true) {
                String string2 = bufferedReader2.readLine();
                String string3 = bufferedReader.readLine();
                if (string3 == null && string2 == null) {
                    break;
                }
                if (string3 == null) {
                    CanonTestCase.fail((String)"More output from test than expected");
                }
                if (string2 == null) {
                    CanonTestCase.fail((String)("Less output from test than expected, stoped at line" + n));
                }
                CanonTestCase.assertEquals((String)("Output at line " + n), (String)string3, (String)string2);
                ++n;
            }
        }
        catch (Throwable throwable) {
            this.dumpForFail(byArray);
            throw throwable;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedReader2 != null) {
                try {
                    bufferedReader2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void dumpForFail(byte[] byArray) throws IOException {
        File file = this.getFailureFolder();
        File file2 = new File(file, this.getName() + ".out");
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ((OutputStream)fileOutputStream).write(byArray);
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }
}

