/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Random;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.LoadGenerator;

public class PoissonLoadGenerator
implements LoadGenerator {
    private final double avgWaitTime;
    private ClientThread[] threads;
    private volatile boolean stop;
    private volatile boolean collect;
    private long startTime;
    private long stopTime;

    public PoissonLoadGenerator(double d) {
        this.avgWaitTime = d;
    }

    @Override
    public void init(Client[] clientArray) {
        this.threads = new ClientThread[clientArray.length];
        for (int i = 0; i < clientArray.length; ++i) {
            this.threads[i] = new ClientThread(clientArray[i]);
        }
    }

    @Override
    public void startWarmup() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].start();
        }
    }

    @Override
    public void startSteadyState() {
        this.startTime = System.currentTimeMillis();
        this.collect = true;
    }

    @Override
    public void stop() {
        this.stopTime = System.currentTimeMillis();
        this.collect = false;
        this.stop = true;
        for (int i = 0; i < this.threads.length; ++i) {
            try {
                this.threads[i].wakeup();
                this.threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    @Override
    public void printReport(PrintStream printStream) {
        long l = this.stopTime - this.startTime;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = Long.MAX_VALUE;
        long l5 = 0L;
        for (int i = 0; i < this.threads.length; ++i) {
            l2 += this.threads[i].count;
            l3 += this.threads[i].totalTime;
            l4 = Math.min(l4, this.threads[i].min);
            l5 = Math.max(l5, this.threads[i].max);
        }
        double d = (double)l2 * 1000.0 / (double)l;
        double d2 = (double)l3 / (double)l2;
        printStream.println("Number of threads:\t" + this.threads.length);
        printStream.println("Average injection rate (tx/s):\t" + d);
        printStream.println("Average response time (ms):\t" + d2);
        printStream.println("Minimum response time (ms):\t" + l4);
        printStream.println("Maximum response time (ms):\t" + l5);
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].getClient().printReport(printStream);
        }
    }

    private class ClientThread
    extends Thread {
        private final Client client;
        private long count;
        private long totalTime;
        private long min = Long.MAX_VALUE;
        private long max = 0L;

        ClientThread(Client client) {
            this.client = client;
        }

        public Client getClient() {
            return this.client;
        }

        synchronized void wakeup() {
            this.notifyAll();
        }

        @Override
        public void run() {
            try {
                this.runClient();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runClient() throws SQLException, InterruptedException {
            Random random = new Random();
            long l = System.currentTimeMillis();
            double d = 0.0;
            long l2 = l;
            while (!PoissonLoadGenerator.this.stop) {
                long l3 = l + (long)(d += -Math.log(random.nextDouble()) * PoissonLoadGenerator.this.avgWaitTime);
                while (l2 < l3) {
                    ClientThread clientThread = this;
                    synchronized (clientThread) {
                        if (PoissonLoadGenerator.this.stop) {
                            return;
                        }
                        this.wait(l3 - l2);
                    }
                    l2 = System.currentTimeMillis();
                }
                long l4 = l2;
                this.client.doWork();
                long l5 = System.currentTimeMillis();
                if (PoissonLoadGenerator.this.collect) {
                    long l6 = l5 - l4;
                    ++this.count;
                    this.totalTime += l6;
                    if (l6 > this.max) {
                        this.max = l6;
                    }
                    if (l6 < this.min) {
                        this.min = l6;
                    }
                }
                l2 = l5;
            }
        }
    }
}

