/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.util;

public class BitUtil {
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] set(byte[] byArray, int n) {
        int n2;
        if (n >= 0 && (n2 = n >> 3) < byArray.length) {
            int n3 = 7 - n % 8;
            int n4 = n2;
            byArray[n4] = (byte)(byArray[n4] | 1 << n3);
            return byArray;
        }
        throw new IndexOutOfBoundsException(Integer.toString(n));
    }

    public static byte[] clear(byte[] byArray, int n) {
        int n2;
        if (n >= 0 && (n2 = n >> 3) < byArray.length) {
            int n3 = 7 - n % 8;
            int n4 = n2;
            byArray[n4] = (byte)(byArray[n4] & ~(1 << n3));
            return byArray;
        }
        throw new IndexOutOfBoundsException(Integer.toString(n));
    }

    public static boolean get(byte[] byArray, int n) {
        int n2;
        if (n >= 0 && (n2 = n >> 3) < byArray.length) {
            int n3 = 7 - n % 8;
            return (byArray[n2] & 1 << n3) != 0;
        }
        throw new IndexOutOfBoundsException(Integer.toString(n));
    }

    public static String hexDump(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        stringBuffer.append("Hex dump:\n");
        for (int i = 0; i < byArray.length; i += 16) {
            char c;
            int n;
            String string = Integer.toHexString(i);
            for (n = string.length(); n < 8; ++n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            stringBuffer.append(":");
            for (n = 0; n < 16 && i + n < byArray.length; ++n) {
                byte by = byArray[i + n];
                if (n % 2 == 0) {
                    stringBuffer.append(" ");
                }
                c = (char)((by & 0xF0) >>> 4);
                byte by2 = (byte)(by & 0xF);
                stringBuffer.append(hex_table[c]);
                stringBuffer.append(hex_table[by2]);
            }
            stringBuffer.append("  ");
            for (n = 0; n < 16 && i + n < byArray.length; ++n) {
                c = (char)byArray[i + n];
                if (Character.isLetterOrDigit(c)) {
                    stringBuffer.append(String.valueOf(c));
                    continue;
                }
                stringBuffer.append(".");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

