/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.typemapping;

import org.apache.commons.lang.StringUtils;

public class SqlTypeWithJdbcType {
    private String size;
    private String scale;
    private String defaultValue;
    private String sqlTypeName;
    private int jdbcType;

    public SqlTypeWithJdbcType(String sqlTypeName, int jdbcType) {
        if (sqlTypeName == null) {
            throw new NullPointerException("sqlTypeName must not be null");
        }
        this.sqlTypeName = sqlTypeName;
        this.jdbcType = jdbcType;
    }

    public SqlTypeWithJdbcType(String sqlTypeName, int jdbcType, String size) {
        this(sqlTypeName, jdbcType);
        this.size = size;
    }

    public SqlTypeWithJdbcType(String sqlTypeName, int jdbcType, String size, String scale) {
        this(sqlTypeName, jdbcType, size);
        this.scale = scale;
    }

    public SqlTypeWithJdbcType(String sqlTypeName, int jdbcType, String size, String scale, String defaultValue) {
        this(sqlTypeName, jdbcType, size, scale);
        this.defaultValue = defaultValue;
    }

    public SqlTypeWithJdbcType(SqlTypeWithJdbcType sqlType, String size, String scale, String defaultValue) {
        this(sqlType.getSqlTypeName(), sqlType.getJdbcType());
        this.size = size != null ? size : sqlType.getSize();
        this.scale = scale != null ? scale : sqlType.getScale();
        this.defaultValue = defaultValue != null ? defaultValue : sqlType.getDefaultValue();
    }

    public String getScale() {
        return this.scale;
    }

    public String getSize() {
        return this.size;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getSqlTypeName() {
        return this.sqlTypeName;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String printSize() {
        if (StringUtils.isNotBlank((String)this.size) && StringUtils.isNotBlank((String)this.scale)) {
            return '(' + this.size + ',' + this.scale + ')';
        }
        if (StringUtils.isNotBlank((String)this.size)) {
            return '(' + this.size + ')';
        }
        return "";
    }
}

