/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control.action;

import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.control.action.MergepointAction;
import org.apache.torque.generator.outlet.OutletResult;

public class OptionAction
implements MergepointAction {
    private final String optionName;
    private boolean acceptNotSet = true;

    public OptionAction(String option, Boolean acceptNotSet) {
        if (option == null) {
            throw new IllegalArgumentException("OptionAction: option must not be null");
        }
        this.optionName = option;
        if (acceptNotSet != null) {
            this.acceptNotSet = acceptNotSet;
        }
    }

    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        Object option = controllerState.getOption(this.optionName);
        if (option == null) {
            if (this.acceptNotSet) {
                return new OutletResult("");
            }
            throw new GeneratorException("OptionAction: The option " + this.optionName + " is not set");
        }
        return new OutletResult(option.toString());
    }

    public String toString() {
        return "(OptionAction: optionName=" + this.optionName + ", acceptNotSet=" + this.acceptNotSet + ")";
    }
}

