/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.MissingBundlePrerequisiteException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.BaseFetchConnection;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

class BundleFetchConnection
extends BaseFetchConnection {
    private final Transport transport;
    InputStream bin;
    final Map<ObjectId, String> prereqs = new HashMap<ObjectId, String>();
    private String lockMessage;
    private PackLock packLock;

    BundleFetchConnection(Transport transportBundle, InputStream src) throws TransportException {
        this.transport = transportBundle;
        this.bin = new BufferedInputStream(src);
        try {
            switch (this.readSignature()) {
                case 2: {
                    this.readBundleV2();
                    break;
                }
                default: {
                    throw new TransportException(this.transport.uri, JGitText.get().notABundle);
                }
            }
        }
        catch (TransportException err) {
            this.close();
            throw err;
        }
        catch (IOException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
        catch (RuntimeException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
    }

    private int readSignature() throws IOException {
        String rev = this.readLine(new byte[1024]);
        if ("# v2 git bundle".equals(rev)) {
            return 2;
        }
        throw new TransportException(this.transport.uri, JGitText.get().notABundle);
    }

    private void readBundleV2() throws IOException {
        String line;
        byte[] hdrbuf = new byte[1024];
        LinkedHashMap<String, Ref> avail = new LinkedHashMap<String, Ref>();
        while ((line = this.readLine(hdrbuf)).length() != 0) {
            ObjectId id;
            if (line.charAt(0) == '-') {
                ObjectId id2 = ObjectId.fromString(line.substring(1, 41));
                String shortDesc = null;
                if (line.length() > 42) {
                    shortDesc = line.substring(42);
                }
                this.prereqs.put(id2, shortDesc);
                continue;
            }
            String name = line.substring(41, line.length());
            Ref prior = avail.put(name, new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, name, id = ObjectId.fromString(line.substring(0, 40))));
            if (prior == null) continue;
            throw this.duplicateAdvertisement(name);
        }
        this.available(avail);
    }

    private PackProtocolException duplicateAdvertisement(String name) {
        return new PackProtocolException(this.transport.uri, MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, name));
    }

    private String readLine(byte[] hdrbuf) throws IOException {
        StringBuilder line = new StringBuilder();
        boolean done = false;
        while (!done) {
            this.bin.mark(hdrbuf.length);
            int cnt = this.bin.read(hdrbuf);
            int lf = 0;
            while (lf < cnt && hdrbuf[lf] != 10) {
                ++lf;
            }
            this.bin.reset();
            IO.skipFully(this.bin, lf);
            if (lf < cnt && hdrbuf[lf] == 10) {
                IO.skipFully(this.bin, 1L);
                done = true;
            }
            line.append(RawParseUtils.decode(StandardCharsets.UTF_8, hdrbuf, 0, lf));
        }
        return line.toString();
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return false;
    }

    @Override
    protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        this.verifyPrerequisites();
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (ObjectInserter ins = this.transport.local.newObjectInserter();){
                PackParser parser = ins.newPackParser(this.bin);
                parser.setAllowThin(true);
                parser.setObjectChecker(this.transport.getObjectChecker());
                parser.setLockMessage(this.lockMessage);
                this.packLock = parser.parse(NullProgressMonitor.INSTANCE);
                ins.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
        catch (RuntimeException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
    }

    @Override
    public void setPackLockMessage(String message) {
        this.lockMessage = message;
    }

    @Override
    public Collection<PackLock> getPackLocks() {
        if (this.packLock != null) {
            return Collections.singleton(this.packLock);
        }
        return Collections.emptyList();
    }

    private void verifyPrerequisites() throws TransportException {
        if (this.prereqs.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (RevWalk rw = new RevWalk(this.transport.local);){
            List<Ref> localRefs;
            RevFlag PREREQ = rw.newFlag("PREREQ");
            RevFlag SEEN = rw.newFlag("SEEN");
            HashMap<ObjectId, String> missing = new HashMap<ObjectId, String>();
            ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
            for (Map.Entry<ObjectId, String> e : this.prereqs.entrySet()) {
                ObjectId objectId = e.getKey();
                try {
                    RevCommit c = rw.parseCommit(objectId);
                    if (c.has(PREREQ)) continue;
                    c.add(PREREQ);
                    commits.add(c);
                }
                catch (MissingObjectException notFound) {
                    missing.put(objectId, e.getValue());
                }
                catch (IOException err) {
                    throw new TransportException(this.transport.uri, MessageFormat.format(JGitText.get().cannotReadCommit, objectId.name()), err);
                }
            }
            if (!missing.isEmpty()) {
                throw new MissingBundlePrerequisiteException(this.transport.uri, missing);
            }
            try {
                localRefs = this.transport.local.getRefDatabase().getRefs();
            }
            catch (IOException e) {
                throw new TransportException(this.transport.uri, e.getMessage(), e);
            }
            for (Ref r : localRefs) {
                try {
                    rw.markStart(rw.parseCommit(r.getObjectId()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            int remaining = commits.size();
            try {
                RevCommit revCommit;
                while ((revCommit = rw.next()) != null) {
                    if (!revCommit.has(PREREQ)) continue;
                    revCommit.add(SEEN);
                    if (--remaining != 0) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                throw new TransportException(this.transport.uri, JGitText.get().cannotReadObject, iOException);
            }
            if (remaining > 0) {
                for (RevObject revObject : commits) {
                    if (revObject.has(SEEN)) continue;
                    missing.put(revObject, this.prereqs.get(revObject));
                }
                throw new MissingBundlePrerequisiteException(this.transport.uri, missing);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() {
        if (this.bin != null) {
            try {
                try {
                    this.bin.close();
                }
                catch (IOException iOException) {
                    this.bin = null;
                }
            }
            finally {
                this.bin = null;
            }
        }
    }
}

