/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.sql.Query;

public abstract class AbstractAdapter
implements Adapter {
    private static final long serialVersionUID = 1L;
    private boolean useGetGeneratedKeys = false;

    protected AbstractAdapter() {
    }

    @Override
    public abstract String toUpperCase(String var1);

    @Override
    public char getStringDelimiter() {
        return '\'';
    }

    @Override
    public abstract IDMethod getIDMethodType();

    @Override
    public abstract String getIDMethodSQL(Object var1);

    @Override
    public String getUpdateLockClause() {
        return "FOR UPDATE";
    }

    @Override
    public abstract void lockTable(Connection var1, String var2) throws SQLException;

    @Override
    public abstract void unlockTable(Connection var1, String var2) throws SQLException;

    @Override
    public abstract String ignoreCase(String var1);

    @Override
    public String ignoreCaseInOrderBy(String in) {
        return this.ignoreCase(in);
    }

    @Override
    public boolean supportsNativeLimit() {
        return true;
    }

    @Override
    public boolean supportsNativeOffset() {
        return true;
    }

    @Override
    public void generateLimits(Query query, long offset, int limit) throws TorqueException {
        if (this.supportsNativeLimit()) {
            query.setLimit(String.valueOf(limit));
        }
    }

    @Override
    public boolean escapeText() {
        return true;
    }

    @Override
    public boolean useIlike() {
        return false;
    }

    @Override
    public boolean useEscapeClauseForLike() {
        return false;
    }

    @Override
    public boolean useMinusForExcept() {
        return false;
    }

    @Override
    public boolean useGetGeneratedKeys() {
        return this.useGetGeneratedKeys;
    }

    @Override
    public void setCapabilities(DatabaseMetaData dmd) throws SQLException {
        this.useGetGeneratedKeys = dmd.supportsGetGeneratedKeys();
    }
}

