/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.message;

import jakarta.enterprise.inject.Vetoed;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.deltaspike.core.api.message.MessageBundle;
import org.apache.deltaspike.core.impl.message.MessageBundleInvocationHandler;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.jsf.api.message.JsfMessage;
import org.apache.deltaspike.jsf.impl.message.JsfMessageBundleInvocationHandler;

@Vetoed
public class DefaultJsfMessage<T>
implements JsfMessage<T> {
    private final String clientId;
    private final Class<T> type;
    private final MessageBundleInvocationHandler invocationHandler;

    public DefaultJsfMessage(Class<T> type, String clientId, MessageBundleInvocationHandler invocationHandler) {
        this.type = type;
        this.clientId = clientId;
        this.invocationHandler = invocationHandler;
        if (!type.isInterface() || type.getAnnotation(MessageBundle.class) == null) {
            throw new IllegalArgumentException("JsfMessage must only be used for interfaces annotated with @MessageBundle!");
        }
    }

    public JsfMessage<T> forClientId(String clientId) {
        return new DefaultJsfMessage<T>(this.type, clientId, this.invocationHandler);
    }

    public JsfMessage<T> forComponent(UIComponent uiComponent) {
        return this.forClientId(uiComponent.getClientId());
    }

    public T addError() {
        return this.getMessage(FacesMessage.SEVERITY_ERROR);
    }

    public T addFatal() {
        return this.getMessage(FacesMessage.SEVERITY_FATAL);
    }

    public T addInfo() {
        return this.getMessage(FacesMessage.SEVERITY_INFO);
    }

    public T addWarn() {
        return this.getMessage(FacesMessage.SEVERITY_WARN);
    }

    public T get() {
        return this.getMessage(null);
    }

    private T getMessage(FacesMessage.Severity severity) {
        return this.type.cast(Proxy.newProxyInstance(ClassUtils.getClassLoader(null), new Class[]{this.type}, (InvocationHandler)new JsfMessageBundleInvocationHandler(severity, this.clientId, this.invocationHandler)));
    }
}

