/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.Serializable;
import java.util.Properties;
import org.apache.directory.fortress.core.PropertyMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AdminMgrImpl;
import org.apache.directory.fortress.core.impl.DelAdminMgrImpl;
import org.apache.directory.fortress.core.impl.DelReviewMgrImpl;
import org.apache.directory.fortress.core.impl.GroupMgrImpl;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.impl.PropertyP;
import org.apache.directory.fortress.core.impl.ReviewMgrImpl;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Role;

public class PropertyMgrImpl
extends Manageable
implements PropertyMgr,
Serializable {
    private PropertyP propP = new PropertyP();

    @Override
    public FortEntity add(FortEntity entity, Properties props) throws SecurityException {
        this.checkPropertyUpdateAccess(entity);
        entity.setContextId(this.contextId);
        return this.propP.addProperties(entity, props);
    }

    @Override
    public FortEntity update(FortEntity entity, Properties props) throws SecurityException {
        this.checkPropertyUpdateAccess(entity);
        entity.setContextId(this.contextId);
        return this.propP.updateProperties(entity, props);
    }

    @Override
    public void delete(FortEntity entity, Properties props) throws SecurityException {
        this.checkPropertyUpdateAccess(entity);
        entity.setContextId(this.contextId);
        this.propP.deleteProperties(entity, props);
    }

    @Override
    public Properties get(FortEntity entity) throws SecurityException {
        this.checkPropertyGetAccess(entity);
        entity.setContextId(this.contextId);
        return this.propP.getProperties(entity);
    }

    private void checkPropertyUpdateAccess(FortEntity entity) throws SecurityException {
        if (entity instanceof Role) {
            this.checkAccess(AdminMgrImpl.class.getName(), "updateRole");
        } else if (entity instanceof AdminRole) {
            this.checkAccess(DelAdminMgrImpl.class.getName(), "updateRole");
        } else if (entity instanceof Group) {
            this.checkAccess(GroupMgrImpl.class.getName(), "update");
        } else if (entity instanceof PermObj) {
            PermObj pObj = (PermObj)entity;
            if (pObj.isAdmin()) {
                this.checkAccess(DelAdminMgrImpl.class.getName(), "updatePermObj");
            } else {
                this.checkAccess(AdminMgrImpl.class.getName(), "updatePermObj");
            }
        } else if (entity instanceof Permission) {
            Permission perm = (Permission)entity;
            if (perm.isAdmin()) {
                this.checkAccess(DelAdminMgrImpl.class.getName(), "updatePermission");
            } else {
                this.checkAccess(AdminMgrImpl.class.getName(), "updatePermission");
            }
        } else {
            throw new SecurityException(10501, "Properties not allowed on supplied entity");
        }
    }

    private void checkPropertyGetAccess(FortEntity entity) throws SecurityException {
        if (entity instanceof Role) {
            this.checkAccess(ReviewMgrImpl.class.getName(), "readRole");
        } else if (entity instanceof AdminRole) {
            this.checkAccess(DelReviewMgrImpl.class.getName(), "readRole");
        } else if (entity instanceof Group) {
            this.checkAccess(GroupMgrImpl.class.getName(), "read");
        } else if (entity instanceof PermObj) {
            PermObj pObj = (PermObj)entity;
            if (pObj.isAdmin()) {
                this.checkAccess(DelReviewMgrImpl.class.getName(), "readPermObj");
            } else {
                this.checkAccess(ReviewMgrImpl.class.getName(), "readPermObj");
            }
        } else if (entity instanceof Permission) {
            Permission perm = (Permission)entity;
            if (perm.isAdmin()) {
                this.checkAccess(DelReviewMgrImpl.class.getName(), "readPermission");
            } else {
                this.checkAccess(ReviewMgrImpl.class.getName(), "readPermission");
            }
        } else {
            throw new SecurityException(10501, "Properties not allowed on supplied entity");
        }
    }
}

