/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.core.GroupMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.model.SerializableList;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupListModel
extends Model<SerializableList<Group>> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private GroupMgr groupMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)GroupListModel.class.getName());
    private Group group;
    private SerializableList<Group> groups = null;

    public GroupListModel(Session session) {
        Injector.get().inject((Object)this);
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.groupMgr.setAdmin(session);
        }
    }

    public GroupListModel(Group group, Session session) {
        Injector.get().inject((Object)this);
        this.group = group;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.groupMgr.setAdmin(session);
        }
    }

    public SerializableList<Group> getObject() {
        if (this.groups != null) {
            LOG.debug(".getObject count: " + this.groups.size());
            return this.groups;
        }
        if (this.group == null) {
            LOG.debug(".getObject null");
            this.groups = new SerializableList(new ArrayList());
        } else {
            LOG.debug(".getObject group name: " + this.group.getName());
            List foundGroups = this.getList(this.group);
            this.groups = CollectionUtils.isNotEmpty((Collection)foundGroups) ? new SerializableList(foundGroups) : new SerializableList(new ArrayList());
        }
        return this.groups;
    }

    public void setObject(SerializableList<Group> object) {
        LOG.debug(".setObject count: " + object.size());
        this.groups = object;
    }

    public void detach() {
        this.groups = null;
        this.group = null;
    }

    public List<Group> getList(Group group) {
        List groupList = null;
        try {
            if (CollectionUtils.isNotEmpty((Collection)group.getMembers())) {
                String userId = (String)group.getMembers().get(0);
                LOG.debug(".getList userId name: " + userId);
                groupList = this.groupMgr.find(new User(userId));
            } else {
                LOG.debug(".getList group name: " + group.getName());
                groupList = this.groupMgr.find(group);
            }
            if (CollectionUtils.isNotEmpty((Collection)groupList)) {
                Collections.sort(groupList, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (SecurityException se) {
            String error = ".getList caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return groupList;
    }
}

