/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.Manageable;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.ReviewMgrImpl;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.rest.ReviewMgrRestImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public final class ReviewMgrFactory {
    private static final String CLS_NM = ReviewMgrFactory.class.getName();

    public static ReviewMgr createInstance() throws SecurityException {
        return ReviewMgrFactory.createInstance("HOME");
    }

    public static ReviewMgr createInstance(String contextId) throws SecurityException {
        VUtil.assertNotNull(contextId, 101, CLS_NM + ".createInstance");
        String reviewClassName = Config.getInstance().getProperty("reviewmgr.implementation");
        Manageable reviewMgr = StringUtils.isEmpty((CharSequence)reviewClassName) ? (Config.getInstance().isRestEnabled() ? new ReviewMgrRestImpl() : new ReviewMgrImpl()) : (ReviewMgr)ClassUtil.createInstance(reviewClassName);
        reviewMgr.setContextId(contextId);
        return reviewMgr;
    }

    public static ReviewMgr createInstance(Session adminSess) throws SecurityException {
        return ReviewMgrFactory.createInstance("HOME", adminSess);
    }

    public static ReviewMgr createInstance(String contextId, Session adminSess) throws SecurityException {
        ReviewMgr reviewMgr = ReviewMgrFactory.createInstance(contextId);
        reviewMgr.setAdmin(adminSess);
        return reviewMgr;
    }
}

