/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.EncKdcRepPart.actions;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.EncKdcRepPart.EncKdcRepPartContainer;
import org.apache.directory.shared.kerberos.codec.lastReq.LastReqContainer;
import org.apache.directory.shared.kerberos.components.LastReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreLastReq
extends GrammarAction<EncKdcRepPartContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreLastReq.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreLastReq() {
        super("Store the EncKDCRepPart LastReq");
    }

    public final void action(EncKdcRepPartContainer encKdcRepPartContainer) throws DecoderException {
        TLV tlv = encKdcRepPartContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_01308_ZERO_LENGTH_TLV, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_01309_EMPTY_TLV, (Object[])new Object[0]));
        }
        LastReqContainer lastReqContainer = new LastReqContainer();
        Asn1Decoder.decode((ByteBuffer)encKdcRepPartContainer.getStream(), (Asn1Container)lastReqContainer);
        LastReq lastReq = lastReqContainer.getLastReq();
        if (IS_DEBUG) {
            LOG.debug("LastReq : {}", (Object)lastReq);
        }
        encKdcRepPartContainer.getEncKdcRepPart().setLastReq(lastReq);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        encKdcRepPartContainer.updateParent();
    }
}

