/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.directory.api.ldap.model.exception.LdapContextNotEmptyException;
import org.apache.directory.api.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

public class StudioLdapException
extends Exception {
    private static final long serialVersionUID = -1L;

    public StudioLdapException(Exception exception) {
        super(exception);
    }

    @Override
    public String getMessage() {
        String message = "";
        Throwable cause = this.getCause();
        if (cause instanceof LdapOperationException) {
            LdapOperationException loe = (LdapOperationException)cause;
            ResultCodeEnum rc = loe.getResultCode();
            String template = " [LDAP result code %d - %s]";
            message = String.valueOf(message) + String.format(Locale.ROOT, template, rc.getResultCode(), rc.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)cause.getMessage())) {
            message = String.valueOf(message) + " " + cause.getMessage();
        }
        return message;
    }

    public static boolean isEntryAlreadyExistsException(Exception exception) {
        return ExceptionUtils.indexOfThrowable((Throwable)exception, LdapEntryAlreadyExistsException.class) > -1;
    }

    public static boolean isContextNotEmptyException(Exception exception) {
        return ExceptionUtils.indexOfThrowable((Throwable)exception, LdapContextNotEmptyException.class) > -1;
    }
}

