/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.views.HierarchyView;
import org.apache.directory.studio.schemaeditor.view.views.SchemaView;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenTypeHierarchyAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private TreeViewer viewer;

    public OpenTypeHierarchyAction(TreeViewer viewer) {
        super(Messages.getString("OpenTypeHierarchyAction.OpenTypeAction"));
        this.setToolTipText(Messages.getString("OpenTypeHierarchyAction.OpenTypeToolTip"));
        this.setId(PluginConstants.CMD_OPEN_TYPE_HIERARCHY);
        this.setActionDefinitionId(PluginConstants.CMD_OPEN_TYPE_HIERARCHY);
        this.setEnabled(false);
        this.viewer = viewer;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                OpenTypeHierarchyAction.this.setEnabled(selection.size() == 1 && (selection.getFirstElement() instanceof AttributeTypeWrapper || selection.getFirstElement() instanceof ObjectClassWrapper));
            }
        });
    }

    public void run() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof SchemaView) {
            this.openTypeHierarchyFromTreeViewer(((SchemaView)part).getViewer());
        } else if (part instanceof HierarchyView) {
            this.openTypeHierarchyFromTreeViewer(((HierarchyView)part).getViewer());
        } else if (part instanceof AttributeTypeEditor) {
            this.openTypeHierarchy((SchemaObject)((AttributeTypeEditor)part).getOriginalAttributeType());
        } else if (part instanceof ObjectClassEditor) {
            this.openTypeHierarchy((SchemaObject)((ObjectClassEditor)part).getOriginalObjectClass());
        }
    }

    private void openTypeHierarchyFromTreeViewer(TreeViewer treeViewer) {
        Object firstElement = ((StructuredSelection)treeViewer.getSelection()).getFirstElement();
        if (firstElement instanceof ObjectClassWrapper) {
            ObjectClassWrapper ocw = (ObjectClassWrapper)firstElement;
            this.openTypeHierarchy((SchemaObject)ocw.getObjectClass());
        } else if (firstElement instanceof AttributeTypeWrapper) {
            AttributeTypeWrapper atw = (AttributeTypeWrapper)firstElement;
            this.openTypeHierarchy((SchemaObject)atw.getAttributeType());
        }
    }

    private void openTypeHierarchy(SchemaObject element) {
        HierarchyView view = (HierarchyView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(HierarchyView.ID);
        if (view == null) {
            try {
                view = (HierarchyView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(HierarchyView.ID);
            }
            catch (PartInitException e) {
                PluginUtils.logError(Messages.getString("OpenTypeHierarchyAction.ErrorOpeningView"), e);
                ViewUtils.displayErrorMessageDialog(Messages.getString("OpenTypeHierarchyAction.Error"), Messages.getString("OpenTypeHierarchyAction.ErrorOpeningView"));
            }
        }
        if (view != null) {
            view.setInput(element);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)view);
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

