/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObjectRenderer;
import org.apache.directory.api.ldap.model.schema.SchemaObjectSorter;
import org.apache.directory.studio.schemaeditor.model.Schema;

public class OpenLdapSchemaFileExporter {
    public static String toSourceCode(Schema schema) {
        StringBuffer sb = new StringBuffer();
        for (AttributeType at : SchemaObjectSorter.hierarchicalOrdered(schema.getAttributeTypes())) {
            sb.append(OpenLdapSchemaFileExporter.toSourceCode(at));
            sb.append("\n");
        }
        for (ObjectClass oc : SchemaObjectSorter.sortObjectClasses(schema.getObjectClasses())) {
            sb.append(OpenLdapSchemaFileExporter.toSourceCode(oc));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toSourceCode(AttributeType at) {
        return SchemaObjectRenderer.OPEN_LDAP_SCHEMA_RENDERER.render(at);
    }

    public static String toSourceCode(ObjectClass oc) {
        return SchemaObjectRenderer.OPEN_LDAP_SCHEMA_RENDERER.render(oc);
    }
}

