/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.schemachecker;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NoAliasWarning;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaCheckerListener;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaWarning;
import org.apache.directory.studio.schemaeditor.model.schemamanager.SchemaEditorSchemaLoader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class SchemaChecker {
    private static SchemaChecker instance;
    private SchemaManager schemaManager;
    private MultiValuedMap<Object, Object> errorsMap = new ArrayListValuedHashMap();
    private List<SchemaWarning> warningsList = new ArrayList<SchemaWarning>();
    private MultiValuedMap<Object, Object> warningsMap = new ArrayListValuedHashMap();
    private static Object lock;
    private boolean listeningToModifications = false;
    private List<SchemaCheckerListener> listeners = new ArrayList<SchemaCheckerListener>();
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void attributeTypeAdded(AttributeType at) {
            1 var2_2 = this;
            synchronized (var2_2) {
                SchemaChecker.this.recheckWholeSchema();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void attributeTypeModified(AttributeType at) {
            1 var2_2 = this;
            synchronized (var2_2) {
                SchemaChecker.this.recheckWholeSchema();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void attributeTypeRemoved(AttributeType at) {
            1 var2_2 = this;
            synchronized (var2_2) {
                SchemaChecker.this.recheckWholeSchema();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void objectClassAdded(ObjectClass oc) {
            1 var2_2 = this;
            synchronized (var2_2) {
                SchemaChecker.this.recheckWholeSchema();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void objectClassModified(ObjectClass oc) {
            1 var2_2 = this;
            synchronized (var2_2) {
                SchemaChecker.this.recheckWholeSchema();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void objectClassRemoved(ObjectClass oc) {
            1 var2_2 = this;
            synchronized (var2_2) {
                SchemaChecker.this.recheckWholeSchema();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void schemaAdded(Schema schema) {
            1 var2_2 = this;
            synchronized (var2_2) {
                SchemaChecker.this.recheckWholeSchema();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void schemaRemoved(Schema schema) {
            1 var2_2 = this;
            synchronized (var2_2) {
                SchemaChecker.this.recheckWholeSchema();
            }
        }

        @Override
        public void schemaRenamed(Schema schema) {
        }
    };

    static {
        lock = new Object();
    }

    private SchemaChecker() {
        Activator.getDefault().getProjectsHandler().addListener(new ProjectsHandlerAdapter(){

            @Override
            public void openProjectChanged(Project oldProject, Project newProject) {
                if (oldProject != null) {
                    oldProject.getSchemaHandler().removeListener(SchemaChecker.this.schemaHandlerListener);
                }
                if (newProject != null) {
                    newProject.getSchemaHandler().addListener(SchemaChecker.this.schemaHandlerListener);
                }
            }
        });
    }

    public static SchemaChecker getInstance() {
        if (instance == null) {
            instance = new SchemaChecker();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableModificationsListening() {
        SchemaChecker schemaChecker = this;
        synchronized (schemaChecker) {
            if (!this.listeningToModifications) {
                Activator.getDefault().getSchemaHandler().addListener(this.schemaHandlerListener);
                this.listeningToModifications = true;
                this.recheckWholeSchema();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableModificationsListening() {
        SchemaChecker schemaChecker = this;
        synchronized (schemaChecker) {
            if (this.listeningToModifications) {
                Activator.getDefault().getSchemaHandler().removeListener(this.schemaHandlerListener);
                this.listeningToModifications = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        SchemaChecker schemaChecker = this;
        synchronized (schemaChecker) {
            this.recheckWholeSchema();
        }
    }

    public boolean isListeningToModifications() {
        return this.listeningToModifications;
    }

    private void recheckWholeSchema() {
        Job job = new Job("Checking Schema"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SchemaChecker.this.schemaManager = (SchemaManager)new DefaultSchemaManager((SchemaLoader)new SchemaEditorSchemaLoader());
                    SchemaChecker.this.schemaManager.loadAllEnabled();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SchemaChecker.this.updateErrorsAndWarnings();
                SchemaChecker.this.notifyListeners();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateErrorsAndWarnings() {
        Object object = lock;
        synchronized (object) {
            this.errorsMap.clear();
            this.indexErrors();
            this.createWarnings();
            this.warningsMap.clear();
            this.indexWarnings();
        }
    }

    private void indexErrors() {
        for (Throwable error : this.schemaManager.getErrors()) {
            LdapSchemaException ldapSchemaException;
            SchemaObject source;
            if (!(error instanceof LdapSchemaException) || (source = (ldapSchemaException = (LdapSchemaException)error).getSourceObject()) == null) continue;
            SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
            if (source instanceof AttributeType) {
                source = schemaHandler.getAttributeType(source.getOid());
            } else if (source instanceof LdapSyntax) {
                source = schemaHandler.getSyntax(source.getOid());
            } else if (source instanceof MatchingRule) {
                source = schemaHandler.getMatchingRule(source.getOid());
            } else if (source instanceof ObjectClass) {
                source = schemaHandler.getObjectClass(source.getOid());
            }
            this.errorsMap.put((Object)source, (Object)ldapSchemaException);
        }
    }

    private void createWarnings() {
        this.warningsList.clear();
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        if (schemaHandler != null) {
            for (AttributeType attributeType : schemaHandler.getAttributeTypes()) {
                this.checkSchemaObjectNames((SchemaObject)attributeType);
            }
            for (ObjectClass objectClass : schemaHandler.getObjectClasses()) {
                this.checkSchemaObjectNames((SchemaObject)objectClass);
            }
        }
    }

    private void checkSchemaObjectNames(SchemaObject schemaObject) {
        if (schemaObject.getNames() == null || schemaObject.getNames().size() == 0) {
            this.warningsList.add(new NoAliasWarning(schemaObject));
        }
    }

    private void indexWarnings() {
        for (SchemaWarning warning : this.warningsList) {
            this.warningsMap.put((Object)warning.getSource(), (Object)warning);
        }
    }

    public List<Throwable> getErrors() {
        if (this.schemaManager != null) {
            return this.schemaManager.getErrors();
        }
        return new ArrayList<Throwable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SchemaWarning> getWarnings() {
        Object object = lock;
        synchronized (object) {
            return this.warningsList;
        }
    }

    public void addListener(SchemaCheckerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SchemaCheckerListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (SchemaCheckerListener listener : this.listeners) {
            listener.schemaCheckerUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> getErrors(SchemaObject so) {
        Object object = lock;
        synchronized (object) {
            return (List)this.errorsMap.get((Object)so);
        }
    }

    public boolean hasErrors(SchemaObject so) {
        List<?> errors = this.getErrors(so);
        if (errors == null) {
            return false;
        }
        return errors.size() > 0;
    }

    public List<Object> getWarnings(SchemaObject so) {
        return (List)this.warningsMap.get((Object)so);
    }

    public boolean hasWarnings(SchemaObject so) {
        List<Object> warnings = this.getWarnings(so);
        if (warnings == null) {
            return false;
        }
        return warnings.size() > 0;
    }
}

