/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ObjectClassSelectionDialogContentProvider
implements IStructuredContentProvider {
    private SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
    private List<ObjectClass> hiddenObjectClasses;

    public ObjectClassSelectionDialogContentProvider(List<ObjectClass> hiddenObjectClasses) {
        this.hiddenObjectClasses = hiddenObjectClasses;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof String) {
            ArrayList<ObjectClass> results = new ArrayList<ObjectClass>();
            String searchText = (String)inputElement;
            searchText = String.valueOf(searchText) + "*";
            String searchRegexp = searchText.replaceAll("\\*", "[\\\\S]*");
            searchRegexp = searchRegexp.replaceAll("\\?", "[\\\\S]");
            Pattern pattern = Pattern.compile(searchRegexp, 2);
            List<ObjectClass> ocList = this.schemaHandler.getObjectClasses();
            Collections.sort(ocList, new Comparator<ObjectClass>(){

                @Override
                public int compare(ObjectClass oc1, ObjectClass oc2) {
                    List oc1Names = oc1.getNames();
                    List oc2Names = oc2.getNames();
                    if (!(oc1Names != null && oc1Names.size() != 0 || oc2Names != null && oc2Names.size() != 0)) {
                        return 0;
                    }
                    if ((oc1Names == null || oc1Names.size() == 0) && oc2Names != null && oc2Names.size() > 0) {
                        return "".compareToIgnoreCase((String)oc2Names.get(0));
                    }
                    if (oc1Names != null && oc1Names.size() > 0 && (oc2Names == null || oc2Names.size() == 0)) {
                        return ((String)oc1Names.get(0)).compareToIgnoreCase("");
                    }
                    return ((String)oc1Names.get(0)).compareToIgnoreCase((String)oc2Names.get(0));
                }
            });
            for (ObjectClass oc : ocList) {
                Matcher m;
                for (String name : oc.getNames()) {
                    Matcher m2 = pattern.matcher(name);
                    if (!m2.matches()) continue;
                    if (this.hiddenObjectClasses.contains(oc) || results.contains(oc)) break;
                    results.add(oc);
                    break;
                }
                if (!(m = pattern.matcher(oc.getOid())).matches() || this.hiddenObjectClasses.contains(oc) || results.contains(oc)) continue;
                results.add(oc);
            }
            return results.toArray();
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

