/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.model.ProjectType;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProjectWrapper;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ProjectsViewLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        if (element instanceof ProjectWrapper) {
            Project project = ((ProjectWrapper)element).getProject();
            ProjectType type = project.getType();
            switch (type) {
                case OFFLINE: {
                    Project.ProjectState state = project.getState();
                    switch (state) {
                        case OPEN: {
                            return Activator.getDefault().getImage("resources/icons/project_offline.gif");
                        }
                        case CLOSED: {
                            return Activator.getDefault().getImage("resources/icons/project_offline_closed.gif");
                        }
                    }
                }
                case ONLINE: {
                    Project.ProjectState state2 = project.getState();
                    switch (state2) {
                        case OPEN: {
                            return Activator.getDefault().getImage("resources/icons/project_online.gif");
                        }
                        case CLOSED: {
                            return Activator.getDefault().getImage("resources/icons/project_online_closed.gif");
                        }
                    }
                }
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof ProjectWrapper) {
            ProjectWrapper projectWrapper = (ProjectWrapper)element;
            return projectWrapper.getProject().getName();
        }
        return super.getText(element);
    }
}

