/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.view.wizards.AbstractWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewSchemaWizardPage
extends AbstractWizardPage {
    private SchemaHandler schemaHandler;
    private Text nameText;

    protected NewSchemaWizardPage() {
        super("NewSchemaWizardPage");
        this.setTitle(Messages.getString("NewSchemaWizardPage.CreateSchema"));
        this.setDescription(Messages.getString("NewSchemaWizardPage.PleaseSpecifiyName"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/schema_new_wizard.png"));
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.getString("NewSchemaWizardPage.SchemaName"));
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSchemaWizardPage.this.dialogChanged();
            }
        });
        this.initFields();
        this.setControl((Control)composite);
    }

    private void initFields() {
        if (Activator.getDefault().getSchemaHandler() == null) {
            this.nameText.setEnabled(false);
            this.displayErrorMessage(Messages.getString("NewSchemaWizardPage.ErrorNoSchemaProjectOpen"));
        } else {
            this.displayErrorMessage(null);
            this.setPageComplete(false);
        }
    }

    private void dialogChanged() {
        if (this.nameText.getText().equals("")) {
            this.displayErrorMessage(Messages.getString("NewSchemaWizardPage.ErrorNoNameSpecified"));
            return;
        }
        if (this.schemaHandler.isSchemaNameAlreadyTaken(this.nameText.getText())) {
            this.displayErrorMessage(Messages.getString("NewSchemaWizardPage.ErrorSchemaNameExists"));
            return;
        }
        this.displayErrorMessage(null);
    }

    public String getSchemaName() {
        return this.nameText.getText();
    }
}

