/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.optional.net.FTPConfigurator;
import org.apache.tools.ant.taskdefs.optional.net.FTPTask;
import org.apache.tools.ant.taskdefs.optional.net.FTPTaskMirror;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.RetryHandler;
import org.apache.tools.ant.util.Retryable;
import org.apache.tools.ant.util.VectorSet;

public class FTPTaskMirrorImpl
implements FTPTaskMirror {
    private static final int CODE_521 = 521;
    private static final int CODE_550 = 550;
    private static final int CODE_553 = 553;
    private static final SimpleDateFormat TIMESTAMP_LOGGING_SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private final FTPTask task;
    private Set<File> dirCache = new HashSet<File>();
    private int transferred = 0;
    private int skipped = 0;

    public FTPTaskMirrorImpl(FTPTask task) {
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFunctioningAsDirectory(FTPClient ftp, String dir, FTPFile file) {
        boolean result = false;
        String currentWorkingDir = null;
        if (file.isDirectory()) {
            return true;
        }
        if (file.isFile()) {
            return false;
        }
        try {
            currentWorkingDir = ftp.printWorkingDirectory();
        }
        catch (IOException ioe) {
            this.task.log("could not find current working directory " + dir + " while checking a symlink", 4);
        }
        if (currentWorkingDir == null) return result;
        try {
            result = ftp.changeWorkingDirectory(file.getLink());
        }
        catch (IOException ioe) {
            this.task.log("could not cd to " + file.getLink() + " while checking a symlink", 4);
        }
        if (!result) return result;
        boolean comeback = false;
        try {
            comeback = ftp.changeWorkingDirectory(currentWorkingDir);
            if (comeback) return result;
        }
        catch (IOException ioe) {
            try {
                this.task.log("could not cd back to " + dir + " while checking a symlink", 0);
                if (comeback) return result;
            }
            catch (Throwable throwable) {
                if (comeback) throw throwable;
                throw new BuildException("could not cd back to %s while checking a symlink", new Object[]{dir});
            }
            throw new BuildException("could not cd back to %s while checking a symlink", new Object[]{dir});
        }
        throw new BuildException("could not cd back to %s while checking a symlink", new Object[]{dir});
    }

    private boolean isFunctioningAsFile(FTPClient ftp, String dir, FTPFile file) {
        return !file.isDirectory() && (file.isFile() || !this.isFunctioningAsDirectory(ftp, dir, file));
    }

    protected void executeRetryable(RetryHandler h, Retryable r, String descr) throws IOException {
        h.execute(r, descr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int transferFiles(FTPClient ftp, FileSet fs) throws IOException, BuildException {
        DirectoryScanner ds;
        if (this.task.getAction() == 0) {
            ds = fs.getDirectoryScanner(this.task.getProject());
        } else {
            ds = new FTPDirectoryScanner(ftp);
            fs.setupDirectoryScanner((FileScanner)ds, this.task.getProject());
            ds.setFollowSymlinks(fs.isFollowSymlinks());
            ds.scan();
        }
        String[] dsfiles = null;
        dsfiles = this.task.getAction() == 6 ? ds.getIncludedDirectories() : ds.getIncludedFiles();
        if (ds.getBasedir() == null && (this.task.getAction() == 0 || this.task.getAction() == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        String dir = null;
        if (this.task.getAction() == 0 || this.task.getAction() == 1) {
            dir = ds.getBasedir().getAbsolutePath();
        }
        try (BufferedWriter bw = null;){
            if (this.task.getAction() == 3) {
                File pd = this.task.getListing().getParentFile();
                if (!pd.exists()) {
                    pd.mkdirs();
                }
                bw = new BufferedWriter(new FileWriter(this.task.getListing()));
            }
            RetryHandler h = new RetryHandler(this.task.getRetriesAllowed(), (Task)this.task);
            if (this.task.getAction() == 6) {
                for (int i = dsfiles.length - 1; i >= 0; --i) {
                    String dsfile = dsfiles[i];
                    this.executeRetryable(h, () -> this.rmDir(ftp, dsfile), dsfile);
                }
            } else {
                BufferedWriter fbw = bw;
                String fdir = dir;
                if (this.task.isNewer()) {
                    this.task.setGranularityMillis(this.task.getTimestampGranularity().getMilliseconds(this.task.getAction()));
                }
                for (String dsfile : dsfiles) {
                    this.executeRetryable(h, () -> {
                        switch (this.task.getAction()) {
                            case 0: {
                                this.sendFile(ftp, fdir, dsfile);
                                break;
                            }
                            case 1: {
                                this.getFile(ftp, fdir, dsfile);
                                break;
                            }
                            case 2: {
                                this.delFile(ftp, dsfile);
                                break;
                            }
                            case 3: {
                                this.listFile(ftp, fbw, dsfile);
                                break;
                            }
                            case 5: {
                                this.doSiteCommand(ftp, "chmod " + this.task.getChmod() + " " + this.resolveFile(dsfile));
                                ++this.transferred;
                                break;
                            }
                            default: {
                                throw new BuildException("unknown ftp action %s", new Object[]{this.task.getAction()});
                            }
                        }
                    }, dsfile);
                }
            }
        }
        return dsfiles.length;
    }

    protected void transferFiles(FTPClient ftp) throws IOException, BuildException {
        this.transferred = 0;
        this.skipped = 0;
        if (this.task.getFilesets().isEmpty()) {
            throw new BuildException("at least one fileset must be specified.");
        }
        for (FileSet fs : this.task.getFilesets()) {
            if (fs == null) continue;
            this.transferFiles(ftp, fs);
        }
        this.task.log(this.transferred + " " + FTPTask.ACTION_TARGET_STRS[this.task.getAction()] + " " + FTPTask.COMPLETED_ACTION_STRS[this.task.getAction()]);
        if (this.skipped != 0) {
            this.task.log(this.skipped + " " + FTPTask.ACTION_TARGET_STRS[this.task.getAction()] + " were not successfully " + FTPTask.COMPLETED_ACTION_STRS[this.task.getAction()]);
        }
    }

    protected String resolveFile(String file) {
        return file.replace(File.separator.charAt(0), this.task.getSeparator().charAt(0));
    }

    protected void createParents(FTPClient ftp, String filename) throws IOException, BuildException {
        File checkDir;
        String dirname;
        File dir = new File(filename);
        if (this.dirCache.contains(dir)) {
            return;
        }
        Vector<File> parents = new Vector<File>();
        while ((dirname = dir.getParent()) != null && !this.dirCache.contains(checkDir = new File(dirname))) {
            dir = checkDir;
            parents.addElement(dir);
        }
        int i = parents.size() - 1;
        if (i >= 0) {
            String cwd = ftp.printWorkingDirectory();
            String parent = dir.getParent();
            if (parent != null && !ftp.changeWorkingDirectory(this.resolveFile(parent))) {
                throw new BuildException("could not change to directory: %s", new Object[]{ftp.getReplyString()});
            }
            while (i >= 0) {
                if (!ftp.changeWorkingDirectory((dir = (File)parents.elementAt(i--)).getName())) {
                    this.task.log("creating remote directory " + this.resolveFile(dir.getPath()), 3);
                    if (!ftp.makeDirectory(dir.getName())) {
                        this.handleMkDirFailure(ftp);
                    }
                    if (!ftp.changeWorkingDirectory(dir.getName())) {
                        throw new BuildException("could not change to directory: %s", new Object[]{ftp.getReplyString()});
                    }
                }
                this.dirCache.add(dir);
            }
            ftp.changeWorkingDirectory(cwd);
        }
    }

    private long getTimeDiff(FTPClient ftp) {
        long returnValue = 0L;
        File tempFile = this.findFileName(ftp);
        try {
            FILE_UTILS.createNewFile(tempFile);
            long localTimeStamp = tempFile.lastModified();
            BufferedInputStream instream = new BufferedInputStream(Files.newInputStream(tempFile.toPath(), new OpenOption[0]));
            ftp.storeFile(tempFile.getName(), (InputStream)instream);
            instream.close();
            if (FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                FTPFile[] ftpFiles = ftp.listFiles(tempFile.getName());
                if (ftpFiles.length == 1) {
                    long remoteTimeStamp = ftpFiles[0].getTimestamp().getTime().getTime();
                    returnValue = localTimeStamp - remoteTimeStamp;
                }
                ftp.deleteFile(ftpFiles[0].getName());
            }
            Delete mydelete = new Delete();
            mydelete.bindToOwner((Task)this.task);
            mydelete.setFile(tempFile.getCanonicalFile());
            mydelete.execute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.task.getLocation());
        }
        return returnValue;
    }

    private File findFileName(FTPClient ftp) {
        FTPFile[] files = null;
        int maxIterations = 1000;
        for (int counter = 1; counter < 1000; ++counter) {
            File localFile = FILE_UTILS.createTempFile(this.task.getProject(), "ant" + Integer.toString(counter), ".tmp", null, false, false);
            String fileName = localFile.getName();
            boolean found = false;
            try {
                if (files == null) {
                    files = ftp.listFiles();
                }
                for (FTPFile file : files) {
                    if (file == null || !file.getName().equals(fileName)) continue;
                    found = true;
                    break;
                }
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, this.task.getLocation());
            }
            if (found) continue;
            localFile.deleteOnExit();
            return localFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpToDate(FTPClient ftp, File localFile, String remoteFile) throws IOException, BuildException {
        StringBuilder msg;
        this.task.log("checking date for " + remoteFile, 3);
        FTPFile[] files = ftp.listFiles(remoteFile);
        if (files == null || files.length == 0) {
            if (this.task.getAction() == 0) {
                this.task.log("Could not date test remote file: " + remoteFile + "assuming out of date.", 3);
                return false;
            }
            throw new BuildException("could not date test remote file: %s", new Object[]{ftp.getReplyString()});
        }
        long remoteTimestamp = files[0].getTimestamp().getTime().getTime();
        long localTimestamp = localFile.lastModified();
        long adjustedRemoteTimestamp = remoteTimestamp + this.task.getTimeDiffMillis() + this.task.getGranularityMillis();
        SimpleDateFormat simpleDateFormat = TIMESTAMP_LOGGING_SDF;
        synchronized (simpleDateFormat) {
            msg = new StringBuilder("   [").append(TIMESTAMP_LOGGING_SDF.format(new Date(localTimestamp))).append("] local");
        }
        this.task.log(msg.toString(), 3);
        simpleDateFormat = TIMESTAMP_LOGGING_SDF;
        synchronized (simpleDateFormat) {
            msg = new StringBuilder("   [").append(TIMESTAMP_LOGGING_SDF.format(new Date(adjustedRemoteTimestamp))).append("] remote");
        }
        if (remoteTimestamp != adjustedRemoteTimestamp) {
            simpleDateFormat = TIMESTAMP_LOGGING_SDF;
            synchronized (simpleDateFormat) {
                msg.append(" - (raw: ").append(TIMESTAMP_LOGGING_SDF.format(new Date(remoteTimestamp))).append(")");
            }
        }
        this.task.log(msg.toString(), 3);
        if (this.task.getAction() == 0) {
            return adjustedRemoteTimestamp >= localTimestamp;
        }
        return localTimestamp >= adjustedRemoteTimestamp;
    }

    protected void doSiteCommand(FTPClient ftp, String theCMD) throws IOException, BuildException {
        this.task.log("Doing Site Command: " + theCMD, 3);
        if (!ftp.sendSiteCommand(theCMD)) {
            this.task.log("Failed to issue Site Command: " + theCMD, 1);
        } else {
            for (String reply : ftp.getReplyStrings()) {
                if (reply.contains("200")) continue;
                this.task.log(reply, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        BufferedInputStream instream;
        block8: {
            File file;
            block7: {
                instream = null;
                try {
                    file = this.task.getProject().resolveFile(new File(dir, filename).getPath());
                    if (!this.task.isNewer() || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block7;
                }
                catch (Throwable throwable) {
                    FileUtils.close(instream);
                    throw throwable;
                }
                FileUtils.close(instream);
                return;
            }
            if (this.task.isVerbose()) {
                this.task.log("transferring " + file.getAbsolutePath());
            }
            instream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
            this.createParents(ftp, filename);
            ftp.storeFile(this.resolveFile(filename), (InputStream)instream);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                String s = "could not put file: " + ftp.getReplyString();
                if (this.task.isSkipFailedTransfers()) {
                    this.task.log(s, 1);
                    ++this.skipped;
                    break block8;
                }
                throw new BuildException(s);
            }
            if (this.task.getChmod() != null) {
                this.doSiteCommand(ftp, "chmod " + this.task.getChmod() + " " + this.resolveFile(filename));
            }
            this.task.log("File " + file.getAbsolutePath() + " copied to " + this.task.getServer(), 3);
            ++this.transferred;
        }
        FileUtils.close((InputStream)instream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void delFile(FTPClient ftp, String filename) throws IOException, BuildException {
        if (this.task.isVerbose()) {
            this.task.log("deleting " + filename);
        }
        if (!ftp.deleteFile(this.resolveFile(filename))) {
            String s = "could not delete file: " + ftp.getReplyString();
            if (!this.task.isSkipFailedTransfers()) throw new BuildException(s);
            this.task.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.task.log("File " + filename + " deleted from " + this.task.getServer(), 3);
            ++this.transferred;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void rmDir(FTPClient ftp, String dirname) throws IOException, BuildException {
        if (this.task.isVerbose()) {
            this.task.log("removing " + dirname);
        }
        if (!ftp.removeDirectory(this.resolveFile(dirname))) {
            String s = "could not remove directory: " + ftp.getReplyString();
            if (!this.task.isSkipFailedTransfers()) throw new BuildException(s);
            this.task.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.task.log("Directory " + dirname + " removed from " + this.task.getServer(), 3);
            ++this.transferred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        BufferedOutputStream outstream;
        block9: {
            File pdir;
            File file;
            block8: {
                outstream = null;
                try {
                    file = this.task.getProject().resolveFile(new File(dir, filename).getPath());
                    if (!this.task.isNewer() || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block8;
                }
                catch (Throwable throwable) {
                    FileUtils.close(outstream);
                    throw throwable;
                }
                FileUtils.close(outstream);
                return;
            }
            if (this.task.isVerbose()) {
                this.task.log("transferring " + filename + " to " + file.getAbsolutePath());
            }
            if (!(pdir = file.getParentFile()).exists()) {
                pdir.mkdirs();
            }
            outstream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
            ftp.retrieveFile(this.resolveFile(filename), (OutputStream)outstream);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                String s = "could not get file: " + ftp.getReplyString();
                if (this.task.isSkipFailedTransfers()) {
                    this.task.log(s, 1);
                    ++this.skipped;
                    break block9;
                }
                throw new BuildException(s);
            }
            this.task.log("File " + file.getAbsolutePath() + " copied from " + this.task.getServer(), 3);
            ++this.transferred;
            if (!this.task.isPreserveLastModified()) break block9;
            ((OutputStream)outstream).close();
            outstream = null;
            FTPFile[] remote = ftp.listFiles(this.resolveFile(filename));
            if (remote.length > 0) {
                FILE_UTILS.setFileLastModified(file, remote[0].getTimestamp().getTime().getTime());
            }
        }
        FileUtils.close((OutputStream)outstream);
    }

    protected void listFile(FTPClient ftp, BufferedWriter bw, String filename) throws IOException, BuildException {
        FTPFile[] ftpfiles;
        if (this.task.isVerbose()) {
            this.task.log("listing " + filename);
        }
        if ((ftpfiles = ftp.listFiles(this.resolveFile(filename))) != null && ftpfiles.length > 0) {
            bw.write(ftpfiles[0].toString());
            bw.newLine();
            ++this.transferred;
        }
    }

    protected void makeRemoteDir(FTPClient ftp, String dir) throws IOException, BuildException {
        String workingDirectory = ftp.printWorkingDirectory();
        if (this.task.isVerbose()) {
            if (dir.startsWith("/") || workingDirectory == null) {
                this.task.log("Creating directory: " + dir + " in /");
            } else {
                this.task.log("Creating directory: " + dir + " in " + workingDirectory);
            }
        }
        if (dir.startsWith("/")) {
            ftp.changeWorkingDirectory("/");
        }
        StringTokenizer st = new StringTokenizer(dir, "/");
        while (st.hasMoreTokens()) {
            String subdir = st.nextToken();
            this.task.log("Checking " + subdir, 4);
            if (ftp.changeWorkingDirectory(subdir)) continue;
            if (!ftp.makeDirectory(subdir)) {
                int rc = ftp.getReplyCode();
                if (!this.task.isIgnoreNoncriticalErrors() || rc != 550 && rc != 553 && rc != 521) {
                    throw new BuildException("could not create directory: " + ftp.getReplyString());
                }
                if (!this.task.isVerbose()) continue;
                this.task.log("Directory already exists");
                continue;
            }
            if (this.task.isVerbose()) {
                this.task.log("Directory created OK");
            }
            ftp.changeWorkingDirectory(subdir);
        }
        if (workingDirectory != null) {
            ftp.changeWorkingDirectory(workingDirectory);
        }
    }

    private void handleMkDirFailure(FTPClient ftp) throws BuildException {
        int rc = ftp.getReplyCode();
        if (!this.task.isIgnoreNoncriticalErrors() || rc != 550 && rc != 553 && rc != 521) {
            throw new BuildException("could not create directory: " + ftp.getReplyString());
        }
    }

    @Override
    public void doFTP() throws BuildException {
        FTPClient ftp = null;
        try {
            FTPClient lftp;
            this.task.log("Opening FTP connection to " + this.task.getServer(), 3);
            ftp = new FTPClient();
            if (this.task.isConfigurationSet()) {
                ftp = FTPConfigurator.configure(ftp, this.task);
            }
            ftp.setRemoteVerificationEnabled(this.task.getEnableRemoteVerification());
            ftp.connect(this.task.getServer(), this.task.getPort());
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                throw new BuildException("FTP connection failed: %s", new Object[]{ftp.getReplyString()});
            }
            this.task.log("connected", 3);
            this.task.log("logging in to FTP server", 3);
            if (this.task.getAccount() != null && !ftp.login(this.task.getUserid(), this.task.getPassword(), this.task.getAccount()) || this.task.getAccount() == null && !ftp.login(this.task.getUserid(), this.task.getPassword())) {
                throw new BuildException("Could not login to FTP server");
            }
            this.task.log("login succeeded", 3);
            if (this.task.isBinary()) {
                ftp.setFileType(2);
            } else {
                ftp.setFileType(0);
            }
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                throw new BuildException("could not set transfer type: %s", new Object[]{ftp.getReplyString()});
            }
            if (this.task.isPassive()) {
                this.task.log("entering passive mode", 3);
                ftp.enterLocalPassiveMode();
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("could not enter into passive mode: %s", new Object[]{ftp.getReplyString()});
                }
            }
            if (this.task.getInitialSiteCommand() != null) {
                lftp = ftp;
                this.executeRetryable(new RetryHandler(this.task.getRetriesAllowed(), (Task)this.task), () -> this.doSiteCommand(lftp, this.task.getInitialSiteCommand()), "initial site command: " + this.task.getInitialSiteCommand());
            }
            if (this.task.getUmask() != null) {
                lftp = ftp;
                this.executeRetryable(new RetryHandler(this.task.getRetriesAllowed(), (Task)this.task), () -> this.doSiteCommand(lftp, "umask " + this.task.getUmask()), "umask " + this.task.getUmask());
            }
            if (this.task.getAction() == 4) {
                lftp = ftp;
                this.executeRetryable(new RetryHandler(this.task.getRetriesAllowed(), (Task)this.task), () -> this.makeRemoteDir(lftp, this.task.getRemotedir()), this.task.getRemotedir());
            } else if (this.task.getAction() == 7) {
                lftp = ftp;
                this.executeRetryable(new RetryHandler(this.task.getRetriesAllowed(), (Task)this.task), () -> this.doSiteCommand(lftp, this.task.getSiteCommand()), "Site Command: " + this.task.getSiteCommand());
            } else {
                if (this.task.getRemotedir() != null) {
                    this.task.log("changing the remote directory", 3);
                    ftp.changeWorkingDirectory(this.task.getRemotedir());
                    if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                        throw new BuildException("could not change remote directory: %s", new Object[]{ftp.getReplyString()});
                    }
                }
                if (this.task.isNewer() && this.task.isTimeDiffAuto()) {
                    this.task.setTimeDiffMillis(this.getTimeDiff(ftp));
                }
                this.task.log(FTPTask.ACTION_STRS[this.task.getAction()] + " " + FTPTask.ACTION_TARGET_STRS[this.task.getAction()]);
                this.transferFiles(ftp);
            }
        }
        catch (IOException ex) {
            throw new BuildException("error during FTP transfer: " + ex, (Throwable)ex);
        }
        finally {
            if (ftp != null && ftp.isConnected()) {
                try {
                    this.task.log("disconnecting", 3);
                    ftp.logout();
                    ftp.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected class FTPDirectoryScanner
    extends DirectoryScanner {
        protected FTPClient ftp = null;
        private String rootPath = null;
        private boolean remoteSystemCaseSensitive = false;
        private boolean remoteSensitivityChecked = false;
        private Map<String, FTPFile[]> fileListMap = new HashMap<String, FTPFile[]>();
        private Map<String, FTPFileProxy> scannedDirs = new HashMap<String, FTPFileProxy>();

        public FTPDirectoryScanner(FTPClient ftp) {
            this.ftp = ftp;
            this.setFollowSymlinks(false);
        }

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new VectorSet();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new VectorSet();
            this.dirsIncluded = new VectorSet();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new VectorSet();
            try {
                String cwd = this.ftp.printWorkingDirectory();
                this.forceRemoteSensitivityCheck();
                this.checkIncludePatterns();
                this.clearCaches();
                this.ftp.changeWorkingDirectory(cwd);
            }
            catch (IOException e) {
                throw new BuildException("Unable to scan FTP server: ", (Throwable)e);
            }
        }

        private void checkIncludePatterns() {
            Hashtable<String, String> newroots = new Hashtable<String, String>();
            for (String include : this.includes) {
                String newpattern = SelectorUtils.rtrimWildcardTokens((String)include);
                newroots.put(newpattern, include);
            }
            if (FTPTaskMirrorImpl.this.task.getRemotedir() == null) {
                try {
                    FTPTaskMirrorImpl.this.task.setRemotedir(this.ftp.printWorkingDirectory());
                }
                catch (IOException e) {
                    throw new BuildException("could not read current ftp directory", FTPTaskMirrorImpl.this.task.getLocation());
                }
            }
            AntFTPRootFile baseFTPFile = new AntFTPRootFile(this.ftp, FTPTaskMirrorImpl.this.task.getRemotedir());
            this.rootPath = ((AntFTPFile)baseFTPFile).getAbsolutePath();
            if (newroots.containsKey("")) {
                this.scandir(this.rootPath, "", true);
            } else {
                newroots.forEach((k, v) -> this.scanRoot(new AntFTPFile(baseFTPFile, (String)k), (String)v));
            }
        }

        private void scanRoot(AntFTPFile myfile, String originalpattern) {
            boolean isOK = true;
            boolean traversesSymlinks = false;
            String path = null;
            if (myfile.exists()) {
                this.forceRemoteSensitivityCheck();
                if (this.remoteSensitivityChecked && this.remoteSystemCaseSensitive && this.isFollowSymlinks()) {
                    path = myfile.getFastRelativePath();
                } else {
                    try {
                        path = myfile.getRelativePath();
                        traversesSymlinks = myfile.isTraverseSymlinks();
                    }
                    catch (IOException be) {
                        throw new BuildException((Throwable)be, FTPTaskMirrorImpl.this.task.getLocation());
                    }
                    catch (BuildException be) {
                        isOK = false;
                    }
                }
            } else {
                isOK = false;
            }
            if (isOK) {
                String currentelement = path.replace(FTPTaskMirrorImpl.this.task.getSeparator().charAt(0), File.separatorChar);
                if (!this.isFollowSymlinks() && traversesSymlinks) {
                    return;
                }
                if (myfile.isDirectory()) {
                    if (this.isIncluded(currentelement) && !currentelement.isEmpty()) {
                        this.accountForIncludedDir(currentelement, myfile, true);
                    } else {
                        if (!currentelement.isEmpty() && currentelement.charAt(currentelement.length() - 1) != File.separatorChar) {
                            currentelement = currentelement + File.separatorChar;
                        }
                        this.scandir(myfile.getAbsolutePath(), currentelement, true);
                    }
                } else if (this.isCaseSensitive && originalpattern.equals(currentelement)) {
                    this.accountForIncludedFile(currentelement);
                } else if (!this.isCaseSensitive && originalpattern.equalsIgnoreCase(currentelement)) {
                    this.accountForIncludedFile(currentelement);
                }
            }
        }

        protected void scandir(String dir, String vpath, boolean fast) {
            if (fast && this.hasBeenScanned(vpath)) {
                return;
            }
            try {
                if (!this.ftp.changeWorkingDirectory(dir)) {
                    return;
                }
                String completePath = vpath.isEmpty() ? this.rootPath : this.rootPath + FTPTaskMirrorImpl.this.task.getSeparator() + vpath.replace(File.separatorChar, FTPTaskMirrorImpl.this.task.getSeparator().charAt(0));
                FTPFile[] newfiles = this.listFiles(completePath, false);
                if (newfiles == null) {
                    this.ftp.changeToParentDirectory();
                    return;
                }
                for (FTPFile file : newfiles) {
                    if (file == null || ".".equals(file.getName()) || "..".equals(file.getName())) continue;
                    String name = vpath + file.getName();
                    this.scannedDirs.put(name, new FTPFileProxy(file));
                    if (FTPTaskMirrorImpl.this.isFunctioningAsDirectory(this.ftp, dir, file)) {
                        boolean slowScanAllowed = true;
                        if (!this.isFollowSymlinks() && file.isSymbolicLink()) {
                            this.dirsExcluded.addElement(name);
                            slowScanAllowed = false;
                        } else if (this.isIncluded(name)) {
                            this.accountForIncludedDir(name, new AntFTPFile(this.ftp, file, completePath), fast);
                        } else {
                            this.dirsNotIncluded.addElement(name);
                            if (fast && this.couldHoldIncluded(name)) {
                                this.scandir(file.getName(), name + File.separator, fast);
                            }
                        }
                        if (fast || !slowScanAllowed) continue;
                        this.scandir(file.getName(), name + File.separator, fast);
                        continue;
                    }
                    if (!this.isFollowSymlinks() && file.isSymbolicLink()) {
                        this.filesExcluded.addElement(name);
                        continue;
                    }
                    if (!FTPTaskMirrorImpl.this.isFunctioningAsFile(this.ftp, dir, file)) continue;
                    this.accountForIncludedFile(name);
                }
                this.ftp.changeToParentDirectory();
            }
            catch (IOException e) {
                throw new BuildException("Error while communicating with FTP server: ", (Throwable)e);
            }
        }

        private void accountForIncludedFile(String name) {
            if (!this.filesIncluded.contains(name) && !this.filesExcluded.contains(name)) {
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name) && this.isSelected(name, this.scannedDirs.get(name))) {
                        this.filesIncluded.addElement(name);
                    } else {
                        this.filesExcluded.addElement(name);
                    }
                } else {
                    this.filesNotIncluded.addElement(name);
                }
            }
        }

        private void accountForIncludedDir(String name, AntFTPFile file, boolean fast) {
            if (!this.dirsIncluded.contains(name) && !this.dirsExcluded.contains(name)) {
                if (!this.isExcluded(name)) {
                    if (fast) {
                        if (file.isSymbolicLink()) {
                            try {
                                file.getClient().changeWorkingDirectory(file.curpwd);
                            }
                            catch (IOException ioe) {
                                throw new BuildException("could not change directory to curpwd");
                            }
                            this.scandir(file.getLink(), name + File.separator, fast);
                        } else {
                            try {
                                file.getClient().changeWorkingDirectory(file.curpwd);
                            }
                            catch (IOException ioe) {
                                throw new BuildException("could not change directory to curpwd");
                            }
                            this.scandir(file.getName(), name + File.separator, fast);
                        }
                    }
                    this.dirsIncluded.addElement(name);
                } else {
                    this.dirsExcluded.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        try {
                            file.getClient().changeWorkingDirectory(file.curpwd);
                        }
                        catch (IOException ioe) {
                            throw new BuildException("could not change directory to curpwd");
                        }
                        this.scandir(file.getName(), name + File.separator, fast);
                    }
                }
            }
        }

        private boolean hasBeenScanned(String vpath) {
            return this.scannedDirs.containsKey(vpath);
        }

        private void clearCaches() {
            this.fileListMap.clear();
            this.scannedDirs.clear();
        }

        public FTPFile[] listFiles(String directory, boolean changedir) {
            FTPFile[] result;
            String currentPath = directory;
            if (changedir) {
                try {
                    if (!this.ftp.changeWorkingDirectory(directory)) {
                        return null;
                    }
                    currentPath = this.ftp.printWorkingDirectory();
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTPTaskMirrorImpl.this.task.getLocation());
                }
            }
            if (this.fileListMap.containsKey(currentPath)) {
                FTPTaskMirrorImpl.this.task.log("filelist map used in listing files", 4);
                return this.fileListMap.get(currentPath);
            }
            try {
                result = this.ftp.listFiles();
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, FTPTaskMirrorImpl.this.task.getLocation());
            }
            this.fileListMap.put(currentPath, result);
            if (!this.remoteSensitivityChecked) {
                this.checkRemoteSensitivity(result, directory);
            }
            return result;
        }

        private void forceRemoteSensitivityCheck() {
            if (!this.remoteSensitivityChecked) {
                try {
                    this.checkRemoteSensitivity(this.ftp.listFiles(), this.ftp.printWorkingDirectory());
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTPTaskMirrorImpl.this.task.getLocation());
                }
            }
        }

        public FTPFile[] listFiles(String directory) {
            return this.listFiles(directory, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkRemoteSensitivity(FTPFile[] array, String directory) {
            if (array == null) {
                return;
            }
            boolean candidateFound = false;
            String target = null;
            for (int icounter = 0; icounter < array.length; ++icounter) {
                if (array[icounter] == null || !array[icounter].isDirectory() || ".".equals(array[icounter].getName()) || "..".equals(array[icounter].getName())) continue;
                candidateFound = true;
                target = this.fiddleName(array[icounter].getName());
                FTPTaskMirrorImpl.this.task.log("will try to cd to " + target + " where a directory called " + array[icounter].getName() + " exists", 4);
                for (int pcounter = 0; pcounter < array.length; ++pcounter) {
                    if (array[pcounter] == null || pcounter == icounter || !target.equals(array[pcounter].getName())) continue;
                    candidateFound = false;
                    break;
                }
                if (candidateFound) break;
            }
            if (candidateFound) {
                try {
                    FTPTaskMirrorImpl.this.task.log("testing case sensitivity, attempting to cd to " + target, 4);
                    this.remoteSystemCaseSensitive = !this.ftp.changeWorkingDirectory(target);
                }
                catch (IOException ioe) {
                    this.remoteSystemCaseSensitive = true;
                }
                finally {
                    try {
                        this.ftp.changeWorkingDirectory(directory);
                    }
                    catch (IOException ioe) {
                        throw new BuildException((Throwable)ioe, FTPTaskMirrorImpl.this.task.getLocation());
                    }
                }
                FTPTaskMirrorImpl.this.task.log("remote system is case sensitive : " + this.remoteSystemCaseSensitive, 3);
                this.remoteSensitivityChecked = true;
            }
        }

        private String fiddleName(String origin) {
            StringBuilder result = new StringBuilder();
            for (char ch : origin.toCharArray()) {
                if (Character.isLowerCase(ch)) {
                    result.append(Character.toUpperCase(ch));
                    continue;
                }
                if (Character.isUpperCase(ch)) {
                    result.append(Character.toLowerCase(ch));
                    continue;
                }
                result.append(ch);
            }
            return result.toString();
        }

        protected class AntFTPRootFile
        extends AntFTPFile {
            private String remotedir;

            public AntFTPRootFile(FTPClient aclient, String remotedir) {
                super(aclient, null, remotedir);
                this.remotedir = remotedir;
                try {
                    this.getClient().changeWorkingDirectory(this.remotedir);
                    this.setCurpwd(this.getClient().printWorkingDirectory());
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTPTaskMirrorImpl.this.task.getLocation());
                }
            }

            @Override
            public String getAbsolutePath() {
                return this.getCurpwd();
            }

            @Override
            public String getRelativePath() throws BuildException, IOException {
                return "";
            }
        }

        protected class AntFTPFile {
            private FTPClient client;
            private String curpwd;
            private FTPFile ftpFile;
            private AntFTPFile parent = null;
            private boolean relativePathCalculated = false;
            private boolean traversesSymlinks = false;
            private String relativePath = "";

            public AntFTPFile(FTPClient client, FTPFile ftpFile, String curpwd) {
                this.client = client;
                this.ftpFile = ftpFile;
                this.curpwd = curpwd;
            }

            public AntFTPFile(AntFTPFile parent, String path) {
                this.parent = parent;
                this.client = parent.client;
                Vector pathElements = SelectorUtils.tokenizePath((String)path);
                try {
                    boolean result = this.client.changeWorkingDirectory(parent.getAbsolutePath());
                    if (!result) {
                        return;
                    }
                    this.curpwd = parent.getAbsolutePath();
                }
                catch (IOException ioe) {
                    throw new BuildException("could not change working dir to %s", new Object[]{parent.curpwd});
                }
                for (String currentPathElement : pathElements) {
                    try {
                        if (!this.client.changeWorkingDirectory(currentPathElement)) {
                            if (!(FTPDirectoryScanner.this.isCaseSensitive() || !FTPDirectoryScanner.this.remoteSystemCaseSensitive && FTPDirectoryScanner.this.remoteSensitivityChecked || (currentPathElement = this.findPathElementCaseUnsensitive(this.curpwd, currentPathElement)) != null)) {
                                return;
                            }
                            return;
                        }
                        this.curpwd = this.getCurpwdPlusFileSep() + currentPathElement;
                    }
                    catch (IOException ioe) {
                        throw new BuildException("could not change working dir to %s from %s", new Object[]{currentPathElement, this.curpwd});
                    }
                }
                String lastpathelement = (String)pathElements.get(pathElements.size() - 1);
                this.ftpFile = this.getFile(FTPDirectoryScanner.this.listFiles(this.curpwd), lastpathelement);
            }

            private String findPathElementCaseUnsensitive(String parentPath, String soughtPathElement) {
                FTPFile[] files = FTPDirectoryScanner.this.listFiles(parentPath, false);
                if (files == null) {
                    return null;
                }
                for (FTPFile file : files) {
                    if (file == null || !file.getName().equalsIgnoreCase(soughtPathElement)) continue;
                    return file.getName();
                }
                return null;
            }

            public boolean exists() {
                return this.ftpFile != null;
            }

            public String getLink() {
                return this.ftpFile.getLink();
            }

            public String getName() {
                return this.ftpFile.getName();
            }

            public String getAbsolutePath() {
                return this.getCurpwdPlusFileSep() + this.ftpFile.getName();
            }

            public String getFastRelativePath() {
                String absPath = this.getAbsolutePath();
                if (absPath.startsWith(FTPDirectoryScanner.this.rootPath + FTPTaskMirrorImpl.this.task.getSeparator())) {
                    return absPath.substring(FTPDirectoryScanner.this.rootPath.length() + FTPTaskMirrorImpl.this.task.getSeparator().length());
                }
                return null;
            }

            public String getRelativePath() throws IOException, BuildException {
                if (!this.relativePathCalculated) {
                    if (this.parent != null) {
                        this.traversesSymlinks = this.parent.isTraverseSymlinks();
                        this.relativePath = this.getRelativePath(this.parent.getAbsolutePath(), this.parent.getRelativePath());
                    } else {
                        this.relativePath = this.getRelativePath(FTPDirectoryScanner.this.rootPath, "");
                        this.relativePathCalculated = true;
                    }
                }
                return this.relativePath;
            }

            private String getRelativePath(String currentPath, String currentRelativePath) {
                Vector pathElements = SelectorUtils.tokenizePath((String)this.getAbsolutePath(), (String)FTPTaskMirrorImpl.this.task.getSeparator());
                Vector pathElements2 = SelectorUtils.tokenizePath((String)currentPath, (String)FTPTaskMirrorImpl.this.task.getSeparator());
                StringBuilder relPath = new StringBuilder(currentRelativePath);
                int size = pathElements.size();
                for (int pcount = pathElements2.size(); pcount < size; ++pcount) {
                    String currentElement = (String)pathElements.get(pcount);
                    FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(currentPath);
                    FTPFile theFile = null;
                    if (theFiles != null) {
                        theFile = this.getFile(theFiles, currentElement);
                    }
                    if (relPath.length() > 0) {
                        relPath.append(FTPTaskMirrorImpl.this.task.getSeparator());
                    }
                    if (theFile == null) {
                        relPath.append(currentElement);
                        currentPath = currentPath + FTPTaskMirrorImpl.this.task.getSeparator() + currentElement;
                        FTPTaskMirrorImpl.this.task.log("Hidden file " + relPath + " assumed to not be a symlink.", 3);
                        continue;
                    }
                    this.traversesSymlinks = this.traversesSymlinks || theFile.isSymbolicLink();
                    relPath.append(theFile.getName());
                    currentPath = currentPath + FTPTaskMirrorImpl.this.task.getSeparator() + theFile.getName();
                }
                return relPath.toString();
            }

            public FTPFile getFile(FTPFile[] theFiles, String lastpathelement) {
                if (theFiles == null) {
                    return null;
                }
                Predicate<String> test = FTPDirectoryScanner.this.isCaseSensitive() ? lastpathelement::equals : lastpathelement::equalsIgnoreCase;
                return Stream.of(theFiles).filter(Objects::nonNull).filter(f -> test.test(f.getName())).findFirst().orElse(null);
            }

            public boolean isDirectory() {
                return this.ftpFile.isDirectory();
            }

            public boolean isSymbolicLink() {
                return this.ftpFile.isSymbolicLink();
            }

            protected FTPClient getClient() {
                return this.client;
            }

            protected void setCurpwd(String curpwd) {
                this.curpwd = curpwd;
            }

            public String getCurpwd() {
                return this.curpwd;
            }

            public String getCurpwdPlusFileSep() {
                String sep = FTPTaskMirrorImpl.this.task.getSeparator();
                return this.curpwd.endsWith(sep) ? this.curpwd : this.curpwd + sep;
            }

            public boolean isTraverseSymlinks() throws IOException, BuildException {
                if (!this.relativePathCalculated) {
                    this.getRelativePath();
                }
                return this.traversesSymlinks;
            }

            public String toString() {
                return "AntFtpFile: " + this.curpwd + "%" + this.ftpFile;
            }
        }
    }

    protected static class FTPFileProxy
    extends File {
        private static final long serialVersionUID = 1L;
        private final FTPFile file;
        private final String[] parts;
        private final String name;

        public FTPFileProxy(FTPFile file) {
            super(file.getName());
            this.name = file.getName();
            this.file = file;
            this.parts = FileUtils.getPathStack((String)this.name);
        }

        public FTPFileProxy(String completePath) {
            super(completePath);
            this.file = null;
            this.name = completePath;
            this.parts = FileUtils.getPathStack((String)completePath);
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String getAbsolutePath() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.parts.length > 0 ? this.parts[this.parts.length - 1] : this.name;
        }

        @Override
        public String getParent() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.parts.length - 1; ++i) {
                result.append(File.separatorChar).append(this.parts[i]);
            }
            return result.toString();
        }

        @Override
        public String getPath() {
            return this.name;
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return this.file == null;
        }

        @Override
        public boolean isFile() {
            return this.file != null;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public long lastModified() {
            if (this.file != null) {
                return this.file.getTimestamp().getTimeInMillis();
            }
            return 0L;
        }

        @Override
        public long length() {
            if (this.file != null) {
                return this.file.getSize();
            }
            return 0L;
        }
    }
}

