/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.widgets;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.studio.aciitemeditor.widgets.Messages;
import org.apache.directory.studio.aciitemeditor.widgets.WidgetModifyEvent;
import org.apache.directory.studio.aciitemeditor.widgets.WidgetModifyListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ACIItemGeneralComposite
extends Composite {
    private Text identificationTagText = null;
    private Spinner precedenceSpinner = null;
    private ComboViewer authenticationLevelComboViewer = null;
    private Button userFirstRadioButton = null;
    private Button itemFirstRadioButton = null;
    private List<WidgetModifyListener> listenerList = new ArrayList<WidgetModifyListener>();

    public ACIItemGeneralComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        this.setLayoutData(layoutData);
        this.createComposite();
    }

    private void createComposite() {
        GridData identificationTagGridData = new GridData();
        identificationTagGridData.grabExcessHorizontalSpace = true;
        identificationTagGridData.verticalAlignment = 2;
        identificationTagGridData.horizontalSpan = 2;
        identificationTagGridData.horizontalAlignment = 4;
        GridData precedenceGridData = new GridData();
        precedenceGridData.grabExcessHorizontalSpace = true;
        precedenceGridData.verticalAlignment = 2;
        precedenceGridData.horizontalSpan = 2;
        precedenceGridData.horizontalAlignment = 1;
        precedenceGridData.widthHint = 36;
        GridData authenticationLevelGridData = new GridData();
        authenticationLevelGridData.grabExcessHorizontalSpace = true;
        authenticationLevelGridData.verticalAlignment = 2;
        authenticationLevelGridData.horizontalSpan = 2;
        authenticationLevelGridData.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        Label identificationTagLabel = new Label(composite, 0);
        identificationTagLabel.setText(Messages.getString("ACIItemGeneralComposite.idTag.label"));
        this.identificationTagText = new Text(composite, 2048);
        this.identificationTagText.setLayoutData((Object)identificationTagGridData);
        this.identificationTagText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ACIItemGeneralComposite.this.fire((TypedEvent)event);
            }
        });
        Label precedenceLabel = new Label(composite, 0);
        precedenceLabel.setText(Messages.getString("ACIItemGeneralComposite.precedence.label"));
        this.precedenceSpinner = new Spinner(composite, 2048);
        this.precedenceSpinner.setMinimum(0);
        this.precedenceSpinner.setMaximum(255);
        this.precedenceSpinner.setDigits(0);
        this.precedenceSpinner.setIncrement(1);
        this.precedenceSpinner.setPageIncrement(10);
        this.precedenceSpinner.setSelection(0);
        this.precedenceSpinner.setLayoutData((Object)precedenceGridData);
        this.precedenceSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ACIItemGeneralComposite.this.fire((TypedEvent)event);
            }
        });
        Label authenticationLevelLabel = new Label(composite, 0);
        authenticationLevelLabel.setText(Messages.getString("ACIItemGeneralComposite.authLevel.label"));
        Combo authenticationLevelCombo = new Combo(composite, 8);
        authenticationLevelCombo.setLayoutData((Object)authenticationLevelGridData);
        AuthenticationLevel[] authenticationLevels = new AuthenticationLevel[]{AuthenticationLevel.NONE, AuthenticationLevel.SIMPLE, AuthenticationLevel.STRONG};
        this.authenticationLevelComboViewer = new ComboViewer(authenticationLevelCombo);
        this.authenticationLevelComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.authenticationLevelComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.authenticationLevelComboViewer.setInput((Object)authenticationLevels);
        this.authenticationLevelComboViewer.setSelection((ISelection)new StructuredSelection((Object)AuthenticationLevel.NONE));
        authenticationLevelCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ACIItemGeneralComposite.this.fire((TypedEvent)event);
            }
        });
        Label userOrItemFirstLabel = new Label(composite, 0);
        userOrItemFirstLabel.setText(Messages.getString("ACIItemGeneralComposite.userOrItemFirst.label"));
        this.userFirstRadioButton = new Button(composite, 16);
        this.userFirstRadioButton.setText(Messages.getString("ACIItemGeneralComposite.userFirst.label"));
        this.userFirstRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ACIItemGeneralComposite.this.fire((TypedEvent)event);
            }
        });
        this.itemFirstRadioButton = new Button(composite, 16);
        this.itemFirstRadioButton.setText(Messages.getString("ACIItemGeneralComposite.itemFirst.label"));
        this.itemFirstRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ACIItemGeneralComposite.this.fire((TypedEvent)event);
            }
        });
    }

    public void addWidgetModifyListener(WidgetModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.listenerList.add(listener);
    }

    public void removeWidgetModifyListener(WidgetModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.listenerList.remove(listener);
    }

    private void fire(TypedEvent event) {
        for (WidgetModifyListener listener : this.listenerList) {
            listener.widgetModified(new WidgetModifyEvent((Object)this));
        }
    }

    public String getIdentificationTag() {
        return this.identificationTagText.getText();
    }

    public void setIdentificationTag(String identificationTag) {
        this.identificationTagText.setText(identificationTag);
    }

    public int getPrecedence() {
        return this.precedenceSpinner.getSelection();
    }

    public void setPrecedence(int precedence) {
        this.precedenceSpinner.setSelection(precedence);
    }

    public AuthenticationLevel getAuthenticationLevel() {
        IStructuredSelection selection = (IStructuredSelection)this.authenticationLevelComboViewer.getSelection();
        return (AuthenticationLevel)selection.getFirstElement();
    }

    public void setAuthenticationLevel(AuthenticationLevel authenticationLevel) {
        StructuredSelection selection = new StructuredSelection((Object)authenticationLevel);
        this.authenticationLevelComboViewer.setSelection((ISelection)selection);
    }

    public boolean isUserFirst() {
        return this.userFirstRadioButton.getSelection();
    }

    public void setUserFirst() {
        this.userFirstRadioButton.setSelection(true);
        this.itemFirstRadioButton.setSelection(false);
    }

    public boolean isItemFirst() {
        return this.itemFirstRadioButton.getSelection();
    }

    public void setItemFirst() {
        this.itemFirstRadioButton.setSelection(true);
        this.userFirstRadioButton.setSelection(false);
    }
}

