/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.api.dsmlv2.DsmlDecorator;
import org.apache.directory.api.dsmlv2.request.AddRequestDsml;
import org.apache.directory.api.dsmlv2.request.BatchRequestDsml;
import org.apache.directory.api.dsmlv2.response.BatchResponseDsml;
import org.apache.directory.api.dsmlv2.response.SearchResponseDsml;
import org.apache.directory.api.dsmlv2.response.SearchResultDoneDsml;
import org.apache.directory.api.dsmlv2.response.SearchResultEntryDsml;
import org.apache.directory.api.dsmlv2.response.SearchResultReferenceDsml;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultDoneImpl;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.io.api.StudioSearchResultEnumeration;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.utils.JNDIUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExportDsmlRunnable
implements StudioConnectionRunnableWithProgress {
    private static final String OBJECTCLASS_OBJECTCLASS_OID = "objectClass";
    private static final String OBJECTCLASS_OBJECTCLASS_NAME = "2.5.4.0";
    private static final String REFERRAL_OBJECTCLASS_OID = "2.16.840.1.113730.3.2.6";
    private static final String REFERRAL_OBJECTCLASS_NAME = "referral";
    private static final String REF_ATTRIBUTETYPE_OID = "2.16.840.1.113730.3.1.34";
    private static final String REF_ATTRIBUTETYPE_NAME = "ref";
    private String exportDsmlFilename;
    private IBrowserConnection browserConnection;
    private SearchParameter searchParameter;
    private ExportDsmlJobType type = ExportDsmlJobType.RESPONSE;
    private static LdapApiService codec = LdapApiServiceFactory.getSingleton();

    public ExportDsmlRunnable(String exportDsmlFilename, IBrowserConnection connection, SearchParameter searchParameter, ExportDsmlJobType type) {
        this.exportDsmlFilename = exportDsmlFilename;
        this.browserConnection = connection;
        this.searchParameter = searchParameter;
        this.type = type;
        ArrayList<String> returningAttributes = new ArrayList<String>(Arrays.asList(searchParameter.getReturningAttributes()));
        returningAttributes.add(REF_ATTRIBUTETYPE_NAME);
        returningAttributes.add(REF_ATTRIBUTETYPE_OID);
        searchParameter.setReturningAttributes(returningAttributes.toArray(new String[0]));
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__export_dsml_name;
    }

    public Object[] getLockedObjects() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.exportDsmlFilename));
        return l.toArray();
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__export_dsml_error;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__export_dsml_task, 4);
        monitor.reportProgress(" ");
        monitor.worked(1);
        try {
            StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
            StudioSearchResultEnumeration ne = SearchRunnable.search(this.browserConnection, this.searchParameter, dummyMonitor);
            monitor.worked(1);
            String dsmlExportString = null;
            switch (this.type) {
                case RESPONSE: {
                    dsmlExportString = this.processAsDsmlResponse(ne, dummyMonitor);
                    break;
                }
                case REQUEST: {
                    dsmlExportString = this.processAsDsmlRequest(ne, dummyMonitor);
                }
            }
            monitor.worked(1);
            if (dsmlExportString != null) {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileOutputStream fos = new FileOutputStream(this.exportDsmlFilename);){
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");){
                        Throwable throwable3 = null;
                        Object var12_18 = null;
                        try (BufferedWriter bufferedWriter = new BufferedWriter(osw);){
                            bufferedWriter.write(dsmlExportString);
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            monitor.worked(1);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    private String processAsDsmlResponse(StudioSearchResultEnumeration sre, StudioProgressMonitor monitor) throws LdapException {
        BatchResponseDsml batchResponse = new BatchResponseDsml();
        ExportDsmlRunnable.processAsDsmlResponse(sre, batchResponse, monitor, this.searchParameter);
        return batchResponse.toDsml();
    }

    public static void processAsDsmlResponse(StudioSearchResultEnumeration sre, BatchResponseDsml batchResponse, StudioProgressMonitor monitor, SearchParameter searchParameter) throws LdapException {
        SearchResponseDsml sr;
        block7: {
            sr = new SearchResponseDsml(codec);
            batchResponse.addResponse((DsmlDecorator)sr);
            try {
                int count = 0;
                if (!monitor.errorsReported()) {
                    while (sre.hasMore()) {
                        Entry entry = sre.next().getEntry();
                        sr.addResponse(ExportDsmlRunnable.convertSearchResultToDsml(entry));
                        monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__export_progress, (Object[])new String[]{Integer.toString(++count)}));
                    }
                }
            }
            catch (LdapException e) {
                int ldapStatusCode = JNDIUtils.getLdapStatusCode((Exception)((Object)e));
                if (ldapStatusCode == 3 || ldapStatusCode == 4 || ldapStatusCode == 11) break block7;
                monitor.reportError((Exception)((Object)e));
            }
        }
        SearchResultDoneImpl srd = new SearchResultDoneImpl();
        LdapResult ldapResult = srd.getLdapResult();
        if (!monitor.errorsReported()) {
            ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        } else {
            Exception t = monitor.getException();
            ldapResult.setResultCode(ResultCodeEnum.getBestEstimate((Throwable)t, (MessageTypeEnum)MessageTypeEnum.SEARCH_REQUEST));
            if (t.getMessage() != null) {
                ldapResult.setDiagnosticMessage(t.getMessage());
            }
        }
        sr.addResponse((DsmlDecorator)new SearchResultDoneDsml(codec, (SearchResultDone)srd));
    }

    private static DsmlDecorator<? extends Response> convertSearchResultToDsml(Entry entry) throws LdapException {
        if (ExportDsmlRunnable.isReferral(entry)) {
            SearchResultReferenceDsml srr = new SearchResultReferenceDsml(codec);
            Attribute refAttribute = entry.get(REF_ATTRIBUTETYPE_NAME);
            if (refAttribute == null) {
                refAttribute = entry.get(REF_ATTRIBUTETYPE_OID);
            }
            if (refAttribute != null) {
                for (Value value : refAttribute) {
                    srr.addSearchResultReference(new LdapUrl(value.getString()));
                }
            }
            return srr;
        }
        SearchResultEntryDsml sre = new SearchResultEntryDsml(codec);
        sre.setEntry(entry);
        return sre;
    }

    private static boolean isReferral(Entry entry) {
        if (entry != null) {
            Attribute objectClassAttribute = entry.get(OBJECTCLASS_OBJECTCLASS_NAME);
            if (objectClassAttribute == null) {
                objectClassAttribute = entry.get(OBJECTCLASS_OBJECTCLASS_OID);
            }
            if (objectClassAttribute != null) {
                return objectClassAttribute.contains(new String[]{REFERRAL_OBJECTCLASS_NAME}) || objectClassAttribute.contains(new String[]{REFERRAL_OBJECTCLASS_OID});
            }
        }
        return false;
    }

    private String processAsDsmlRequest(StudioSearchResultEnumeration sre, StudioProgressMonitor monitor) throws LdapException {
        BatchRequestDsml batchRequest;
        block4: {
            batchRequest = new BatchRequestDsml();
            try {
                int count = 0;
                if (!monitor.errorsReported()) {
                    while (sre.hasMore()) {
                        Entry entry = sre.next().getEntry();
                        AddRequestDsml arDsml = this.convertToAddRequestDsml(entry);
                        batchRequest.addRequest((DsmlDecorator)arDsml);
                        monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__export_progress, (Object[])new String[]{Integer.toString(++count)}));
                    }
                }
            }
            catch (LdapException e) {
                int ldapStatusCode = JNDIUtils.getLdapStatusCode((Exception)((Object)e));
                if (ldapStatusCode == 3 || ldapStatusCode == 4 || ldapStatusCode == 11) break block4;
                monitor.reportError((Exception)((Object)e));
            }
        }
        return batchRequest.toDsml();
    }

    private AddRequestDsml convertToAddRequestDsml(Entry entry) throws LdapException {
        AddRequestDsml ar = new AddRequestDsml(codec);
        ar.setEntry(entry);
        return ar;
    }

    public static enum ExportDsmlJobType {
        RESPONSE,
        REQUEST;

    }
}

