/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.ldapbrowser.core.internal.search.LdapSearchPageScoreComputer;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Messages;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.eclipse.search.ui.ISearchPageScoreComputer;

public class Value
implements IValue {
    private static final long serialVersionUID = -9039209604742682740L;
    private IAttribute attribute;
    private Object rawValue;

    public Value(IAttribute attribute, Object rawValue) {
        this.init(attribute, rawValue);
        assert (rawValue != null);
    }

    public Value(IAttribute attribute) {
        this.init(attribute, null);
    }

    private void init(IAttribute attribute, Object rawValue) {
        assert (attribute != null);
        this.attribute = attribute;
        this.rawValue = rawValue == null ? (attribute.isString() ? IValue.EMPTY_STRING_VALUE : IValue.EMPTY_BINARY_VALUE) : rawValue;
    }

    @Override
    public IAttribute getAttribute() {
        return this.attribute;
    }

    @Override
    public Object getRawValue() {
        return this.rawValue;
    }

    @Override
    public String getStringValue() {
        if (this.rawValue == EMPTY_STRING_VALUE) {
            return EMPTY_STRING_VALUE.getStringValue();
        }
        if (this.rawValue == EMPTY_BINARY_VALUE) {
            return EMPTY_BINARY_VALUE.getStringValue();
        }
        if (this.rawValue instanceof String) {
            return (String)this.rawValue;
        }
        if (this.rawValue instanceof byte[]) {
            return LdifUtils.utf8decode((byte[])((byte[])this.rawValue));
        }
        return Messages.Value_Unknown;
    }

    @Override
    public byte[] getBinaryValue() {
        if (this.rawValue == EMPTY_STRING_VALUE) {
            return EMPTY_STRING_VALUE.getBinaryValue();
        }
        if (this.rawValue == EMPTY_BINARY_VALUE) {
            return EMPTY_BINARY_VALUE.getBinaryValue();
        }
        if (this.rawValue instanceof byte[]) {
            return (byte[])this.rawValue;
        }
        if (this.rawValue instanceof String) {
            return LdifUtils.utf8encode((String)((String)this.rawValue));
        }
        return LdifUtils.utf8encode((String)Messages.Value_Unknown);
    }

    @Override
    public boolean isString() {
        return this.rawValue == EMPTY_STRING_VALUE || this.attribute.isString();
    }

    @Override
    public boolean isBinary() {
        return this.rawValue == EMPTY_BINARY_VALUE || this.attribute.isBinary();
    }

    @Override
    public boolean isEmpty() {
        return this.rawValue == EMPTY_STRING_VALUE || this.rawValue == EMPTY_BINARY_VALUE;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof IValue)) {
            return false;
        }
        IValue vc = (IValue)o;
        if (!vc.getAttribute().equals(this.getAttribute())) {
            return false;
        }
        if (this.isEmpty() && vc.isEmpty()) {
            return true;
        }
        if (this.isBinary() && vc.isBinary()) {
            return Utils.equals(this.getBinaryValue(), vc.getBinaryValue());
        }
        if (this.isString() && vc.isString()) {
            return this.getStringValue().equals(vc.getStringValue());
        }
        return false;
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }

    public String toString() {
        return this.attribute + ":" + (this.isString() ? this.getStringValue() : "BINARY");
    }

    public Object getAdapter(Class adapter) {
        Class clazz = adapter;
        if (clazz.isAssignableFrom(ISearchPageScoreComputer.class)) {
            return new LdapSearchPageScoreComputer();
        }
        if (clazz.isAssignableFrom(Connection.class)) {
            return this.getAttribute().getEntry().getBrowserConnection().getConnection();
        }
        if (clazz.isAssignableFrom(IBrowserConnection.class)) {
            return this.getAttribute().getEntry().getBrowserConnection();
        }
        if (clazz.isAssignableFrom(IEntry.class)) {
            return this.getAttribute().getEntry();
        }
        if (clazz.isAssignableFrom(IAttribute.class)) {
            return this.getAttribute();
        }
        if (clazz.isAssignableFrom(IValue.class)) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isRdnPart() {
        for (Ava ava : this.getAttribute().getEntry().getRdn()) {
            if (!this.getAttribute().getDescription().equals(ava.getNormType()) || !this.getStringValue().equals(ava.getValue().getNormalized())) continue;
            return true;
        }
        return false;
    }
}

