/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.certificate;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.widgets.CertificateInfoComposite;
import org.apache.directory.studio.valueeditors.ValueEditorsActivator;
import org.apache.directory.studio.valueeditors.ValueEditorsConstants;
import org.apache.directory.studio.valueeditors.certificate.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CertificateDialog
extends Dialog {
    public static final String LOAD_FILE_NAME_TOOLTIP = "LoadFileName";
    private static final String DIALOG_TITLE = Messages.getString("CertificateDialog.CertificateDialog");
    private static final int LOAD_BUTTON_ID = 9998;
    private static final int SAVE_BUTTON_ID = 9999;
    private Text loadFilenameText;
    private byte[] currentData;
    private X509Certificate currentCertificate;
    private byte[] returnData;
    private CertificateInfoComposite certificateInfoComposite;

    public CertificateDialog(Shell parentShell, byte[] initialData) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.currentData = initialData;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.returnData = this.currentData;
        } else if (buttonId == 9999) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
            fileDialog.setText(Messages.getString("CertificateDialog.SaveCertificate"));
            String returnedFileName = fileDialog.open();
            if (returnedFileName != null) {
                try {
                    File file = new File(returnedFileName);
                    FileUtils.writeByteArrayToFile((File)file, (byte[])this.currentData);
                }
                catch (IOException e) {
                    ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, ValueEditorsConstants.PLUGIN_ID, 4, Messages.getString("CertificateDialog.CantWriteToFile"), (Throwable)e));
                }
            }
        } else if (buttonId == 9998) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
            fileDialog.setText(Messages.getString("CertificateDialog.LoadCertificate"));
            String returnedFileName = fileDialog.open();
            if (returnedFileName != null) {
                this.loadFile(returnedFileName);
            }
        } else {
            this.returnData = null;
        }
        super.buttonPressed(buttonId);
    }

    private void loadFile(String fileName) {
        try {
            File file = new File(fileName);
            this.currentData = FileUtils.readFileToByteArray((File)file);
            this.updateInput();
        }
        catch (IOException e) {
            ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, ValueEditorsConstants.PLUGIN_ID, 4, Messages.getString("CertificateDialog.CantReadFile"), (Throwable)e));
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        shell.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/certificateeditor.png"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.loadFilenameText = new Text(parent, 0);
        this.loadFilenameText.setToolTipText(LOAD_FILE_NAME_TOOLTIP);
        this.loadFilenameText.setBackground(parent.getBackground());
        this.loadFilenameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CertificateDialog.this.loadFile(CertificateDialog.this.loadFilenameText.getText());
            }
        });
        this.createButton(parent, 9998, Messages.getString("CertificateDialog.LoadCertificateButton"), false);
        this.createButton(parent, 9999, Messages.getString("CertificateDialog.SaveCertificateButton"), false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite certificateInfoContainer = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)1);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(450);
        gd.heightHint = this.convertVerticalDLUsToPixels(300);
        certificateInfoContainer.setLayoutData((Object)gd);
        this.certificateInfoComposite = new CertificateInfoComposite(certificateInfoContainer, 0);
        if (this.currentData != null && this.currentData.length > 0) {
            this.updateInput();
        }
        CertificateDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateInput() {
        block3: {
            try {
                this.currentCertificate = CertificateDialog.generateCertificate(this.currentData);
                this.currentData = this.currentCertificate.getEncoded();
                this.certificateInfoComposite.setInput(new X509Certificate[]{this.currentCertificate});
                if (this.getButton(0) != null) {
                    this.getButton(0).setEnabled(true);
                }
            }
            catch (Exception e) {
                ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, ValueEditorsConstants.PLUGIN_ID, 4, Messages.getString("CertificateDialog.CantParseCertificate"), (Throwable)e));
                if (this.getButton(0) == null) break block3;
                this.getButton(0).setEnabled(false);
            }
        }
    }

    public byte[] getData() {
        return this.returnData;
    }

    public static String getCertificateInfo(byte[] data) {
        try {
            X509Certificate certificate = CertificateDialog.generateCertificate(data);
            if (certificate != null) {
                String name = certificate.getSubjectX500Principal().getName();
                int version = certificate.getVersion();
                String type = certificate.getType();
                return String.valueOf(type) + "v" + version + ": " + name;
            }
            return NLS.bind((String)Messages.getString("CertificateDialog.InvalidCertificate"), (Object)data.length);
        }
        catch (Exception exception) {
            return NLS.bind((String)Messages.getString("CertificateDialog.InvalidCertificate"), (Object)data.length);
        }
    }

    private static X509Certificate generateCertificate(byte[] data) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate certificate = cf.generateCertificate(new ByteArrayInputStream(data));
        if (certificate instanceof X509Certificate) {
            return (X509Certificate)certificate;
        }
        return null;
    }
}

