/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.ldapservers.ConsolesManager;
import org.apache.directory.studio.ldapservers.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerStatus;
import org.apache.mina.util.AvailablePortFinder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.framework.Bundle;

public class LdapServersUtils {
    public static final String LAUNCH_CONFIGURATION_CUSTOM_OBJECT = "launchConfiguration";
    public static final String CONSOLE_PRINTER_CUSTOM_OBJECT = "consolePrinter";

    public static void runStartupListenerWatchdog(LdapServer server, int port) throws Exception {
        if (port == 0) {
            return;
        }
        long startTime = System.currentTimeMillis();
        long watchDog = startTime + 180000L;
        while (System.currentTimeMillis() < watchDog && LdapServerStatus.STARTING == server.getStatus()) {
            if (AvailablePortFinder.available((int)port)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            server.setStatus(LdapServerStatus.STARTED);
            return;
        }
        if (LdapServerStatus.STARTING == server.getStatus()) {
            server.setStatus(LdapServerStatus.STOPPED);
        }
    }

    public static void startTerminateListenerThread(final LdapServer server, final ILaunch launch) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

                    public void handleDebugEvents(DebugEvent[] events) {
                        DebugEvent[] debugEventArray = events;
                        int n = events.length;
                        int n2 = 0;
                        while (n2 < n) {
                            RuntimeProcess runtimeProcess;
                            ILaunch debugEventLaunch;
                            Object source;
                            DebugEvent debugEvent = debugEventArray[n2];
                            if (debugEvent.getKind() == 8 && (source = debugEvent.getSource()) instanceof RuntimeProcess && (debugEventLaunch = (runtimeProcess = (RuntimeProcess)source).getLaunch()).equals(launch)) {
                                server.setStatus(LdapServerStatus.STOPPED);
                                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                                return;
                            }
                            ++n2;
                        }
                    }
                });
            }
        };
        thread.start();
    }

    public static void startConsolePrinterThread(LdapServer server, File serverLogsFile) {
        MessageConsole messageConsole = ConsolesManager.getDefault().getMessageConsole(server);
        final MessageConsoleStream messageStream = messageConsole.newMessageStream();
        TailerListenerAdapter l = new TailerListenerAdapter(){

            public void handle(String line) {
                messageStream.println(line);
            }
        };
        Tailer tailer = Tailer.create((File)serverLogsFile, (TailerListener)l, (long)1000L, (boolean)true);
        server.putCustomObject(CONSOLE_PRINTER_CUSTOM_OBJECT, tailer);
    }

    public static void stopConsolePrinterThread(LdapServer server) {
        Tailer tailer = (Tailer)server.removeCustomObject(CONSOLE_PRINTER_CUSTOM_OBJECT);
        if (tailer != null) {
            tailer.stop();
        }
    }

    public static void terminateLaunchConfiguration(LdapServer server) throws Exception {
        ILaunch launch = (ILaunch)server.removeCustomObject(LAUNCH_CONFIGURATION_CUSTOM_OBJECT);
        if (launch != null) {
            if (!launch.isTerminated()) {
                launch.terminate();
            }
        } else {
            throw new Exception(Messages.getString("LdapServersUtils.AssociatedLaunchConfigurationCouldNotBeFoundOrTerminated"));
        }
    }

    private static void verifyAndCopyLibraries(Bundle bundle, IPath sourceLibrariesPath, IPath destinationLibrariesPath, String[] libraries) {
        File destinationLibraries = destinationLibrariesPath.toFile();
        if (!destinationLibraries.exists()) {
            destinationLibraries.mkdir();
        }
        String[] stringArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            boolean newerFileExists;
            String library = stringArray[n2];
            File destinationLibraryFile = destinationLibrariesPath.append(library).toFile();
            boolean bl = newerFileExists = bundle.getLastModified() > destinationLibraryFile.lastModified();
            if (!destinationLibraryFile.exists() || newerFileExists) {
                try {
                    LdapServersUtils.copyResource(bundle, sourceLibrariesPath.append(library), destinationLibraryFile);
                }
                catch (IOException e) {
                    CommonUIUtils.openErrorDialog((String)NLS.bind((String)Messages.getString("LdapServersUtils.ErrorCopyingLibrary"), (Object[])new String[]{library, destinationLibraryFile.getAbsolutePath(), e.getMessage()}));
                }
            }
            ++n2;
        }
    }

    public static void verifyAndCopyLibraries(Bundle bundle, IPath sourceLibrariesPath, IPath destinationLibrariesPath, String[] libraries, StudioProgressMonitor monitor, String monitorTaskName) {
        monitor.subTask(monitorTaskName);
        LdapServersUtils.verifyAndCopyLibraries(bundle, sourceLibrariesPath, destinationLibrariesPath, libraries);
    }

    public static void copyResource(Bundle bundle, IPath resource, File destination) throws IOException {
        URL resourceUrl = FileLocator.find((Bundle)bundle, (IPath)resource, null);
        InputStream resourceInputStream = resourceUrl.openStream();
        FileOutputStream resourceOutputStream = new FileOutputStream(destination);
        LdapServersUtils.copyFile(resourceInputStream, resourceOutputStream);
        resourceInputStream.close();
        resourceOutputStream.close();
    }

    private static void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = inputStream.read(buf)) != -1) {
            outputStream.write(buf, 0, i);
        }
    }
}

