/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation;

import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.manipulator.metadata.annotation.FieldMetadataCollector;
import org.apache.felix.ipojo.manipulator.metadata.annotation.MethodMetadataCollector;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassMetadataCollector
extends ClassVisitor {
    private BindingRegistry registry;
    private Reporter reporter;
    private ComponentWorkbench workbench;
    private ClassNode node;
    private Element componentMetadata;
    private Element instanceMetadata;

    public ClassMetadataCollector(BindingRegistry registry, Reporter reporter) {
        super(589824);
        this.registry = registry;
        this.reporter = reporter;
        this.node = new ClassNode();
    }

    public Element getComponentMetadata() {
        return this.componentMetadata;
    }

    public Element getInstanceMetadata() {
        return this.instanceMetadata;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.node.visit(version, access, name, signature, superName, interfaces);
        this.workbench = new ComponentWorkbench(this.registry, this.node);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (Type.getType(desc).getClassName().equals("org.apache.felix.ipojo.configuration.Configuration")) {
            this.workbench.ignore(true);
            return null;
        }
        return this.registry.selection(this.workbench).type(this, this.node).annotatedWith(desc).get();
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return new FieldMetadataCollector(this.workbench, new FieldNode(access, name, desc, signature, value));
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new MethodMetadataCollector(this.workbench, new MethodNode(access, name, desc, signature, exceptions), this.reporter);
    }

    @Override
    public void visitEnd() {
        if (!(this.is(8192) || this.is(512) || this.is(1024))) {
            if (this.workbench.getRoot() == null) {
                if (this.workbench.ignore()) {
                    return;
                }
                if (!this.workbench.getElements().isEmpty()) {
                    this.reporter.warn("Class %s has not been marked as a component type (no @Component, @Handler, ...). It will be ignored by the iPOJO manipulator.", this.workbench.getType().getClassName());
                    return;
                }
                return;
            }
            this.componentMetadata = this.workbench.build();
            this.instanceMetadata = this.workbench.getInstance();
            if (this.componentMetadata != null && this.componentMetadata.containsAttribute("name") && this.instanceMetadata != null) {
                this.instanceMetadata.addAttribute(new Attribute("component", this.componentMetadata.getAttribute("name")));
            }
        }
    }

    private boolean is(int flags) {
        return (this.node.access & flags) == flags;
    }
}

