/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.maven.osgicheck.impl.checks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.maven.osgicheck.impl.Check;
import org.apache.felix.maven.osgicheck.impl.CheckContext;
import org.apache.felix.maven.osgicheck.impl.featureutil.ManifestUtil;
import org.apache.felix.maven.osgicheck.impl.featureutil.PackageInfo;
import org.apache.maven.plugin.MojoExecutionException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class ConsumerProviderTypeCheck
implements Check {
    @Override
    public String getName() {
        return "exportannotation";
    }

    private boolean include(File f) {
        return f.isFile() && f.getName().endsWith(".class");
    }

    private boolean exclude(File f) {
        return f.getName().equals("package-info.class") || f.getName().contains("$");
    }

    @Override
    public void check(CheckContext ctx) throws MojoExecutionException {
        ctx.getLog().info((CharSequence)"Checking exported packages for provider/consumer type");
        List<PackageInfo> exp = ManifestUtil.extractExportedPackages(ctx.getManifest());
        for (PackageInfo p : exp) {
            File packageDir = new File(ctx.getRootDir(), p.getName().replace(".", File.separator));
            if (!packageDir.exists()) {
                ctx.reportError("Package directory " + packageDir + " does not exist!");
                continue;
            }
            ctx.getLog().info((CharSequence)("Examining package " + p.getName() + "..."));
            for (File f : packageDir.listFiles()) {
                if (!this.include(f) || this.exclude(f)) continue;
                String className = f.getName().substring(0, f.getName().length() - 6);
                this.processClass(ctx, f, className);
            }
        }
    }

    private void processClass(CheckContext ctx, File classFile, String className) {
        ctx.getLog().debug((CharSequence)("Processing class " + className));
        try (FileInputStream input = new FileInputStream(classFile);){
            ClassReader classReader = new ClassReader((InputStream)input);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 7);
            if ((classNode.access & 0x200) == 0) {
                ctx.getLog().debug((CharSequence)("Skipping non interface class " + className));
                return;
            }
            List<String> annotations = this.extractAnnotation(classNode);
            for (String s : annotations) {
                ctx.getLog().debug((CharSequence)("Found annotation " + s));
            }
            int count = 0;
            if (annotations.contains("org.osgi.annotation.versioning.ProviderType")) {
                ++count;
            }
            if (annotations.contains("org.osgi.annotation.versioning.ConsumerType")) {
                ++count;
            }
            if (count == 0) {
                ctx.reportError("Class " + className + " does neither declare ConsumerType nor ProducerType");
            } else if (count == 2) {
                ctx.reportError("Class " + className + " declares ConsumerType and ProducerType");
            }
        }
        catch (IOException | IllegalArgumentException ioe) {
            ctx.reportError("Unable to scan annotations " + ioe.getMessage());
        }
    }

    private final List<String> extractAnnotation(ClassNode classNode) {
        ArrayList<String> descriptions = new ArrayList<String>();
        for (AnnotationNode n : this.getAllAnnotations(classNode.invisibleAnnotations)) {
            this.parseAnnotation(descriptions, n);
        }
        for (AnnotationNode n : this.getAllAnnotations(classNode.visibleAnnotations)) {
            this.parseAnnotation(descriptions, n);
        }
        return descriptions;
    }

    private List<AnnotationNode> getAllAnnotations(List annotationList) {
        ArrayList<AnnotationNode> resultList = new ArrayList<AnnotationNode>();
        if (annotationList != null) {
            resultList.addAll(annotationList);
        }
        return resultList;
    }

    private void parseAnnotation(List<String> descriptions, AnnotationNode annotation) {
        String name = annotation.desc.substring(1, annotation.desc.length() - 1).replace('/', '.');
        descriptions.add(name);
    }
}

