/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.MessageException;
import flex.messaging.messages.Message;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.List;

public class MessageBody
implements Serializable {
    private static final int ERR_MSG_INVALID_REQUEST_TYPE = 10037;
    static final long serialVersionUID = 3874002169129668459L;
    private String targetURI = "";
    private String responseURI = "";
    protected Object data;

    public MessageBody() {
    }

    public MessageBody(String targetURI, String responseURI, Object data) {
        this.setTargetURI(targetURI);
        this.setResponseURI(responseURI);
        this.data = data;
    }

    public String getTargetURI() {
        return this.targetURI;
    }

    public void setTargetURI(String uri) {
        if (uri == null) {
            uri = "";
        }
        this.targetURI = uri;
    }

    public void setReplyMethod(String methodName) {
        if (this.targetURI.endsWith("/onStatus") || this.targetURI.endsWith("/onResult")) {
            this.targetURI = this.targetURI.substring(0, this.targetURI.lastIndexOf(47));
        }
        this.targetURI = this.targetURI + methodName;
    }

    public String getReplyMethod() {
        return this.targetURI.substring(this.targetURI.lastIndexOf(47) + 1, this.targetURI.length());
    }

    public String getResponseURI() {
        return this.responseURI;
    }

    public void setResponseURI(String uri) {
        if (uri == null) {
            uri = "";
        }
        this.responseURI = uri;
    }

    public Object getData() {
        return this.data;
    }

    public Message getDataAsMessage() {
        if (this.data instanceof List) {
            this.data = ((List)this.data).get(0);
        } else if (this.data.getClass().isArray()) {
            this.data = Array.get(this.data, 0);
        }
        if (this.data instanceof Message) {
            return (Message)this.data;
        }
        MessageException me = new MessageException();
        me.setMessage(10037, new Object[]{this.data.getClass().getName()});
        throw me;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

