/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.fxg.dom.richtext;

import java.util.Collection;
import org.apache.flex.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.flex.compiler.internal.fxg.dom.richtext.AbstractRichTextLeafNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.TextHelper;
import org.apache.flex.compiler.internal.fxg.dom.types.Direction;
import org.apache.flex.compiler.internal.fxg.dom.types.JustificationRule;
import org.apache.flex.compiler.internal.fxg.dom.types.JustificationStyle;
import org.apache.flex.compiler.internal.fxg.dom.types.LeadingModel;
import org.apache.flex.compiler.internal.fxg.dom.types.TextAlign;
import org.apache.flex.compiler.internal.fxg.dom.types.TextJustify;
import org.apache.flex.compiler.problems.ICompilerProblem;

public abstract class AbstractRichParagraphNode
extends AbstractRichTextLeafNode {
    protected static final double PARAGRAPH_INDENT_MIN_INCLUSIVE = 0.0;
    protected static final double PARAGRAPH_INDENT_MAX_INCLUSIVE = 1000.0;
    protected static final double PARAGRAPH_SPACE_MIN_INCLUSIVE = 0.0;
    protected static final double PARAGRAPH_SPACE_MAX_INCLUSIVE = 1000.0;
    protected static final double TEXTINDENT_MIN_INCLUSIVE = -1000.0;
    protected static final double TEXTINDENT_MAX_INCLUSIVE = 1000.0;
    public TextAlign textAlign = TextAlign.START;
    public TextAlign textAlignLast = TextAlign.START;
    public double textIndent = 0.0;
    public double paragraphStartIndent = 0.0;
    public double paragraphEndIndent = 0.0;
    public double paragraphSpaceBefore = 0.0;
    public double paragraphSpaceAfter = 0.0;
    public Direction direction = Direction.LTR;
    public JustificationRule justificationRule = JustificationRule.AUTO;
    public JustificationStyle justificationStyle = JustificationStyle.PRIORITIZELEASTADJUSTMENT;
    public TextJustify textJustify = TextJustify.INTERWORD;
    public LeadingModel leadingModel = LeadingModel.AUTO;
    public String tabStops = "";

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("textAlign".equals(name)) {
            this.textAlign = TextHelper.getTextAlign(this, value, this.textAlign, problems);
        } else if ("textAlignLast".equals(name)) {
            this.textAlignLast = TextHelper.getTextAlign(this, value, this.textAlignLast, problems);
        } else if ("textIndent".equals(name)) {
            this.textIndent = DOMParserHelper.parseDouble(this, value, name, -1000.0, 1000.0, this.textIndent, problems);
        } else if ("paragraphStartIndent".equals(name)) {
            this.paragraphStartIndent = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphStartIndent, problems);
        } else if ("paragraphEndIndent".equals(name)) {
            this.paragraphEndIndent = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphEndIndent, problems);
        } else if ("paragraphSpaceBefore".equals(name)) {
            this.paragraphSpaceBefore = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphSpaceBefore, problems);
        } else if ("paragraphSpaceAfter".equals(name)) {
            this.paragraphSpaceAfter = DOMParserHelper.parseDouble(this, value, name, 0.0, 1000.0, this.paragraphSpaceAfter, problems);
        } else if ("direction".equals(name)) {
            this.direction = TextHelper.getDirection(this, value, this.direction, problems);
        } else if ("justificationRule".equals(name)) {
            this.justificationRule = TextHelper.getJustificationRule(this, value, this.justificationRule, problems);
        } else if ("justificationStyle".equals(name)) {
            this.justificationStyle = TextHelper.getJustificationStyle(this, value, this.justificationStyle, problems);
        } else if ("textJustify".equals(name)) {
            this.textJustify = TextHelper.getTextJustify(this, value, this.textJustify, problems);
        } else if ("leadingModel".equals(name)) {
            this.leadingModel = TextHelper.getLeadingModel(this, value, this.leadingModel, problems);
        } else if ("tabStops".equals(name)) {
            this.tabStops = TextHelper.parseTabStops(this, value, this.tabStops, problems);
        } else {
            super.setAttribute(name, value, problems);
            return;
        }
        this.rememberAttribute(name, value);
    }
}

