/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.TimestampData;

@Internal
public class TimestampDataSerializer
extends TypeSerializer<TimestampData> {
    private static final long serialVersionUID = 1L;
    private final int precision;

    public TimestampDataSerializer(int precision) {
        this.precision = precision;
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public TypeSerializer<TimestampData> duplicate() {
        return new TimestampDataSerializer(this.precision);
    }

    @Override
    public TimestampData createInstance() {
        return TimestampData.fromEpochMillis(0L);
    }

    @Override
    public TimestampData copy(TimestampData from) {
        return from;
    }

    @Override
    public TimestampData copy(TimestampData from, TimestampData reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return TimestampData.isCompact(this.precision) ? 8 : 12;
    }

    @Override
    public void serialize(TimestampData record, DataOutputView target) throws IOException {
        if (TimestampData.isCompact(this.precision)) {
            assert (record.getNanoOfMillisecond() == 0);
            target.writeLong(record.getMillisecond());
        } else {
            target.writeLong(record.getMillisecond());
            target.writeInt(record.getNanoOfMillisecond());
        }
    }

    @Override
    public TimestampData deserialize(DataInputView source) throws IOException {
        if (TimestampData.isCompact(this.precision)) {
            long val = source.readLong();
            return TimestampData.fromEpochMillis(val);
        }
        long longVal = source.readLong();
        int intVal = source.readInt();
        return TimestampData.fromEpochMillis(longVal, intVal);
    }

    @Override
    public TimestampData deserialize(TimestampData reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        if (TimestampData.isCompact(this.precision)) {
            target.writeLong(source.readLong());
        } else {
            target.writeLong(source.readLong());
            target.writeInt(source.readInt());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimestampDataSerializer that = (TimestampDataSerializer)obj;
        return this.precision == that.precision;
    }

    @Override
    public int hashCode() {
        return this.precision;
    }

    @Override
    public TypeSerializerSnapshot<TimestampData> snapshotConfiguration() {
        return new TimestampDataSerializerSnapshot(this.precision);
    }

    public static final class TimestampDataSerializerSnapshot
    implements TypeSerializerSnapshot<TimestampData> {
        private static final int CURRENT_VERSION = 1;
        private int previousPrecision;

        public TimestampDataSerializerSnapshot() {
        }

        TimestampDataSerializerSnapshot(int precision) {
            this.previousPrecision = precision;
        }

        @Override
        public int getCurrentVersion() {
            return 1;
        }

        @Override
        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.previousPrecision);
        }

        @Override
        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.previousPrecision = in.readInt();
        }

        @Override
        public TypeSerializer<TimestampData> restoreSerializer() {
            return new TimestampDataSerializer(this.previousPrecision);
        }

        @Override
        public TypeSerializerSchemaCompatibility<TimestampData> resolveSchemaCompatibility(TypeSerializer<TimestampData> newSerializer) {
            if (!(newSerializer instanceof TimestampDataSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            TimestampDataSerializer timestampDataSerializer = (TimestampDataSerializer)newSerializer;
            if (this.previousPrecision != timestampDataSerializer.precision) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

