/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;

public class IndexCreationData
implements DataSerializableFixedID {
    private String name = null;
    private IndexType indexType = null;
    private String fromClause = null;
    private String expression = null;
    private String importStr = null;
    private PartitionedIndex partitionedIndex = null;
    private boolean loadEntries = false;

    public IndexCreationData() {
    }

    public IndexCreationData(String name) {
        this.name = name;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexData(IndexType type, String fromClause, String expression, String importStr) {
        this.indexType = type;
        this.fromClause = fromClause;
        this.expression = expression;
        this.importStr = importStr;
    }

    public void setIndexData(IndexType type, String fromClause, String expression, String importStr, boolean loadEntries) {
        this.indexType = type;
        this.fromClause = fromClause;
        this.expression = expression;
        this.importStr = importStr;
        this.loadEntries = loadEntries;
    }

    public void setPartitionedIndex(PartitionedIndex index) {
        this.partitionedIndex = index;
    }

    public PartitionedIndex getPartitionedIndex() {
        return this.partitionedIndex;
    }

    public String getIndexFromClause() {
        return this.fromClause;
    }

    public String getIndexExpression() {
        return this.expression;
    }

    public String getIndexImportString() {
        return this.importStr;
    }

    public String getIndexName() {
        return this.name;
    }

    public boolean loadEntries() {
        return this.loadEntries;
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return 2163;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.expression);
        out.writeUTF(this.fromClause);
        out.writeBoolean(this.loadEntries);
        if (IndexType.PRIMARY_KEY == this.indexType) {
            out.writeByte(0);
        } else if (IndexType.HASH == this.indexType) {
            out.writeByte(1);
        } else {
            out.writeByte(2);
        }
        if (this.importStr != null) {
            out.writeBoolean(true);
            out.writeUTF(this.importStr);
        } else {
            out.writeBoolean(false);
        }
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.expression = in.readUTF();
        this.fromClause = in.readUTF();
        this.loadEntries = in.readBoolean();
        byte byteIndexType = in.readByte();
        this.indexType = 0 == byteIndexType ? IndexType.PRIMARY_KEY : (1 == byteIndexType ? IndexType.HASH : IndexType.FUNCTIONAL);
        boolean isImportStr = in.readBoolean();
        if (isImportStr) {
            this.importStr = in.readUTF();
        }
    }
}

