/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;

public class InternalRole
implements Role {
    private final String name;
    @MakeNotStatic
    private static final Map roles = new HashMap();

    InternalRole(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Role o) {
        if (o == null || !(o instanceof InternalRole)) {
            throw new ClassCastException("InternalRole.compareTo(): comparison between different classes");
        }
        InternalRole other = (InternalRole)o;
        return this.name.compareTo(other.name);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof InternalRole)) {
            return false;
        }
        InternalRole that = (InternalRole)other;
        return StringUtils.equals((CharSequence)this.name, (CharSequence)that.name);
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalRole getRole(String name) {
        Map map = roles;
        synchronized (map) {
            InternalRole role = (InternalRole)roles.get(name);
            if (role == null) {
                role = new InternalRole(name);
                roles.put(name, role);
            }
            return role;
        }
    }

    @Override
    public boolean isPresent() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys == null) {
            throw new IllegalStateException("isPresent requires a connection to the distributed system.");
        }
        DistributionManager dm = sys.getDistributionManager();
        return dm.isRolePresent(this);
    }

    @Override
    public int getCount() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys == null) {
            throw new IllegalStateException("getCount requires a connection to the distributed system.");
        }
        DistributionManager dm = sys.getDistributionManager();
        return dm.getRoleCount(this);
    }

    public String toString() {
        return this.name;
    }
}

