/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.ByteBufferSharing;
import org.apache.geode.internal.net.NioFilter;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.tcp.ByteBufferInputStream;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.MsgDestreamer;
import org.apache.geode.internal.tcp.VersionedByteBufferInputStream;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class MsgReader {
    private static final Logger logger = LogService.getLogger();
    protected final Connection conn;
    protected final Header header = new Header();
    private final NioFilter ioFilter;
    private ByteBuffer peerNetData;
    private final ByteBufferInputStream byteBufferInputStream;

    MsgReader(Connection conn, NioFilter nioFilter, Version version) {
        this.conn = conn;
        this.ioFilter = nioFilter;
        this.byteBufferInputStream = version == null ? new ByteBufferInputStream() : new VersionedByteBufferInputStream(version);
    }

    Header readHeader() throws IOException {
        Throwable throwable = null;
        try (ByteBufferSharing sharedBuffer = this.readAtLeast(7);){
            ByteBuffer unwrappedBuffer = sharedBuffer.getBuffer();
            Assert.assertTrue(unwrappedBuffer.remaining() >= 7);
            try {
                boolean directAck;
                int nioMessageLength = unwrappedBuffer.getInt();
                Connection.calcHdrVersion(nioMessageLength);
                nioMessageLength = Connection.calcMsgByteSize(nioMessageLength);
                byte nioMessageType = unwrappedBuffer.get();
                short nioMsgId = unwrappedBuffer.getShort();
                boolean bl = directAck = (nioMessageType & 0x20) != 0;
                if (directAck) {
                    nioMessageType = (byte)(nioMessageType & 0xFFFFFFDF);
                }
                this.header.setFields(nioMessageLength, nioMessageType, nioMsgId);
                Header header = this.header;
                return header;
            }
            catch (BufferUnderflowException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    DistributionMessage readMessage(Header header) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void readChunk(Header header, MsgDestreamer md) throws IOException {
        try (ByteBufferSharing sharedBuffer = this.readAtLeast(header.messageLength);){
            ByteBuffer unwrappedBuffer = sharedBuffer.getBuffer();
            this.getStats().incMessagesBeingReceived(md.size() == 0, header.messageLength);
            md.addChunk(unwrappedBuffer, header.messageLength);
            unwrappedBuffer.position(unwrappedBuffer.position() + header.messageLength);
        }
    }

    private ByteBufferSharing readAtLeast(int bytes) throws IOException {
        this.peerNetData = this.ioFilter.ensureWrappedCapacity(bytes, this.peerNetData, BufferPool.BufferType.TRACKED_RECEIVER);
        return this.ioFilter.readAtLeast(this.conn.getSocket().getChannel(), bytes, this.peerNetData);
    }

    public void close() {
        if (this.peerNetData != null) {
            this.conn.getBufferPool().releaseReceiveBuffer(this.peerNetData);
        }
    }

    private DMStats getStats() {
        return this.conn.getConduit().getStats();
    }

    public static class Header {
        private int messageLength;
        private byte messageType;
        private short messageId;

        public void setFields(int nioMessageLength, byte nioMessageType, short nioMsgId) {
            this.messageLength = nioMessageLength;
            this.messageType = nioMessageType;
            this.messageId = nioMsgId;
        }

        int getMessageLength() {
            return this.messageLength;
        }

        byte getMessageType() {
            return this.messageType;
        }

        short getMessageId() {
            return this.messageId;
        }
    }
}

