/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geode.kafka.GeodeConnectorConfig;
import org.apache.geode.kafka.Version;
import org.apache.geode.kafka.source.GeodeKafkaSourceTask;
import org.apache.geode.kafka.source.GeodeSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.util.ConnectorUtils;

public class GeodeKafkaSource
extends SourceConnector {
    private Map<String, String> sharedProps;

    public Class<? extends Task> taskClass() {
        return GeodeKafkaSourceTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>();
        List<String> bindings = GeodeConnectorConfig.parseStringByComma(this.sharedProps.get("region-to-topics"));
        List bindingsPerTask = ConnectorUtils.groupPartitions(bindings, (int)maxTasks);
        for (int i = 0; i < maxTasks; ++i) {
            HashMap<String, String> taskProps = new HashMap<String, String>(this.sharedProps);
            taskProps.put("GEODE_TASK_ID", "" + i);
            taskProps.put("cqsToRegister", GeodeConnectorConfig.reconstructString((Collection)bindingsPerTask.get(i)));
            taskConfigs.add(taskProps);
        }
        return taskConfigs;
    }

    public ConfigDef config() {
        return GeodeSourceConnectorConfig.SOURCE_CONFIG_DEF;
    }

    public void start(Map<String, String> props) {
        this.sharedProps = props;
    }

    public void stop() {
    }

    public String version() {
        return Version.getVersion();
    }
}

