/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.lang.reflect.Modifier;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.groovy.ast.tools.MethodNodeUtils;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;

public class VariableScopeVisitor
extends ClassCodeVisitorSupport {
    private ClassNode currentClass;
    private VariableScope currentScope;
    private boolean inConstructor;
    private boolean inSpecialConstructorCall;
    private final SourceUnit source;
    private final boolean recurseInnerClasses;
    private final Deque<StateStackElement> stateStack = new LinkedList<StateStackElement>();

    public VariableScopeVisitor(SourceUnit source, boolean recurseInnerClasses) {
        this.source = source;
        this.currentScope = new VariableScope();
        this.recurseInnerClasses = recurseInnerClasses;
    }

    public VariableScopeVisitor(SourceUnit source) {
        this(source, false);
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private void pushState(boolean isStatic) {
        this.stateStack.push(new StateStackElement(this.currentClass, this.currentScope, this.inConstructor));
        this.currentScope = new VariableScope(this.currentScope);
        this.currentScope.setInStaticContext(isStatic);
    }

    private void pushState() {
        this.pushState(this.currentScope.isInStaticContext());
    }

    private void popState() {
        StateStackElement state = this.stateStack.pop();
        this.currentClass = state.clazz;
        this.currentScope = state.scope;
        this.inConstructor = state.inConstructor;
    }

    private void declare(VariableExpression variable) {
        variable.setInStaticContext(this.currentScope.isInStaticContext());
        this.declare(variable, variable);
        variable.setAccessedVariable(variable);
    }

    private void declare(Variable variable, ASTNode context) {
        String scopeType = "scope";
        String variableType = "variable";
        if (context.getClass() == FieldNode.class) {
            scopeType = "class";
            variableType = "field";
        } else if (context.getClass() == PropertyNode.class) {
            scopeType = "class";
            variableType = "property";
        }
        StringBuilder msg = new StringBuilder();
        msg.append("The current ").append(scopeType);
        msg.append(" already contains a ").append(variableType);
        msg.append(" of the name ").append(variable.getName());
        if (this.currentScope.getDeclaredVariable(variable.getName()) != null) {
            this.addError(msg.toString(), context);
            return;
        }
        for (VariableScope scope = this.currentScope.getParent(); scope != null && (scope.getClassScope() == null || VariableScopeVisitor.isAnonymous(scope.getClassScope())); scope = scope.getParent()) {
            if (scope.getDeclaredVariable(variable.getName()) == null) continue;
            this.addError(msg.toString(), context);
            break;
        }
        this.currentScope.putDeclaredVariable(variable);
    }

    private Variable findClassMember(ClassNode node, String name) {
        boolean abstractType = node.isAbstract();
        for (ClassNode cn = node; cn != null && !cn.equals(ClassHelper.OBJECT_TYPE); cn = cn.getSuperClass()) {
            FieldNode fn;
            PropertyNode pn3;
            for (FieldNode fn2 : cn.getFields()) {
                if (!name.equals(fn2.getName())) continue;
                return fn2;
            }
            for (PropertyNode pn2 : cn.getProperties()) {
                if (!name.equals(pn2.getName())) continue;
                return pn2;
            }
            for (MethodNode mn : cn.getMethods()) {
                if (!abstractType && mn.isAbstract() || !name.equals(MethodNodeUtils.getPropertyName(mn))) continue;
                for (PropertyNode pn3 : GeneralUtils.getAllProperties(cn.getSuperClass())) {
                    if (!name.equals(pn3.getName())) continue;
                    return pn3;
                }
                fn = new FieldNode(name, mn.getModifiers() & 0xF, ClassHelper.DYNAMIC_TYPE, cn, null);
                fn.setHasNoRealSourcePosition(true);
                fn.setDeclaringClass(cn);
                fn.setSynthetic(true);
                pn3 = new PropertyNode(fn, fn.getModifiers(), null, null);
                pn3.setDeclaringClass(cn);
                return pn3;
            }
            for (ClassNode in : cn.getAllInterfaces()) {
                fn = in.getDeclaredField(name);
                if (fn != null) {
                    return fn;
                }
                pn3 = in.getProperty(name);
                if (pn3 == null) continue;
                return pn3;
            }
        }
        return null;
    }

    private Variable findVariableDeclaration(String name) {
        if ("super".equals(name) || "this".equals(name)) {
            return null;
        }
        Variable variable = null;
        VariableScope scope = this.currentScope;
        boolean crossingStaticContext = false;
        while (true) {
            crossingStaticContext = crossingStaticContext || scope.isInStaticContext();
            Variable var = scope.getDeclaredVariable(name);
            if (var != null) {
                variable = var;
                break;
            }
            var = scope.getReferencedLocalVariable(name);
            if (var != null) {
                variable = var;
                break;
            }
            var = scope.getReferencedClassVariable(name);
            if (var != null) {
                variable = var;
                break;
            }
            ClassNode node = scope.getClassScope();
            if (node != null) {
                boolean requireStatic;
                Variable member = this.findClassMember(node, name);
                boolean bl = requireStatic = crossingStaticContext || this.inSpecialConstructorCall;
                while (member == null && node.getOuterClass() != null && !VariableScopeVisitor.isAnonymous(node)) {
                    requireStatic = requireStatic || Modifier.isStatic(node.getModifiers());
                    node = node.getOuterClass();
                    member = this.findClassMember(node, name);
                }
                if (member != null && (requireStatic ? member.isInStaticContext() : !node.isScript())) {
                    variable = member;
                }
                if (!VariableScopeVisitor.isAnonymous(scope.getClassScope())) break;
            }
            scope = scope.getParent();
        }
        if (variable == null) {
            variable = new DynamicVariable(name, crossingStaticContext);
        }
        boolean isClassVariable = scope.isClassScope() && !scope.isReferencedLocalVariable(name) || scope.isReferencedClassVariable(name) && scope.getDeclaredVariable(name) == null;
        VariableScope end = scope;
        for (scope = this.currentScope; scope != end; scope = scope.getParent()) {
            if (isClassVariable) {
                scope.putReferencedClassVariable(variable);
                continue;
            }
            scope.putReferencedLocalVariable(variable);
        }
        return variable;
    }

    private static boolean isAnonymous(ClassNode node) {
        return !node.isEnum() && node instanceof InnerClassNode && ((InnerClassNode)node).isAnonymous();
    }

    private void checkPropertyOnExplicitThis(PropertyExpression pe) {
        if (!this.currentScope.isInStaticContext()) {
            return;
        }
        Expression object = pe.getObjectExpression();
        if (!(object instanceof VariableExpression)) {
            return;
        }
        VariableExpression ve = (VariableExpression)object;
        if (!ve.getName().equals("this")) {
            return;
        }
        String name = pe.getPropertyAsString();
        if (name == null || name.equals("class")) {
            return;
        }
        Variable member = this.findClassMember(this.currentClass, name);
        if (member == null) {
            return;
        }
        this.checkVariableContextAccess(member, pe);
    }

    private void checkVariableContextAccess(Variable variable, Expression expression) {
        if (variable.isInStaticContext()) {
            if (this.inConstructor && this.currentClass.isEnum() && variable instanceof FieldNode && this.currentClass.equals(((FieldNode)variable).getDeclaringClass()) && (!Modifier.isFinal(variable.getModifiers()) || !ClassHelper.isStaticConstantInitializerType(variable.getOriginType()) && !"String".equals(variable.getOriginType().getName()))) {
                this.addError("Cannot refer to the static enum field '" + variable.getName() + "' within an initializer", expression);
            }
            return;
        }
        if (!this.currentScope.isInStaticContext()) {
            return;
        }
        this.addError(variable.getName() + " is declared in a dynamic context, but you tried to access it from a static context.", expression);
        this.currentScope.putDeclaredVariable(new DynamicVariable(variable.getName(), this.currentScope.isInStaticContext()));
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        this.pushState();
        block.setVariableScope(this.currentScope);
        super.visitBlockStatement(block);
        this.popState();
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        this.pushState();
        forLoop.setVariableScope(this.currentScope);
        Parameter p = forLoop.getVariable();
        p.setInStaticContext(this.currentScope.isInStaticContext());
        if (p != ForStatement.FOR_LOOP_DUMMY) {
            this.declare(p, forLoop);
        }
        super.visitForLoop(forLoop);
        this.popState();
    }

    @Override
    public void visitIfElse(IfStatement ifElse) {
        ifElse.getBooleanExpression().visit(this);
        this.pushState();
        ifElse.getIfBlock().visit(this);
        this.popState();
        this.pushState();
        ifElse.getElseBlock().visit(this);
        this.popState();
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.visitAnnotations(expression);
        expression.getRightExpression().visit(this);
        if (expression.isMultipleAssignmentDeclaration()) {
            TupleExpression list = expression.getTupleExpression();
            for (Expression e : list.getExpressions()) {
                this.declare((VariableExpression)e);
            }
        } else {
            this.declare(expression.getVariableExpression());
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpression be) {
        super.visitBinaryExpression(be);
        switch (be.getOperation().getType()) {
            case 100: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 285: 
            case 286: 
            case 287: 
            case 350: 
            case 351: 
            case 352: {
                this.checkFinalFieldAccess(be.getLeftExpression());
                break;
            }
        }
    }

    private void checkFinalFieldAccess(Expression expression) {
        if (!(expression instanceof VariableExpression) && !(expression instanceof TupleExpression)) {
            return;
        }
        if (expression instanceof TupleExpression) {
            TupleExpression list = (TupleExpression)expression;
            for (Expression e : list.getExpressions()) {
                this.checkForFinal(expression, (VariableExpression)e);
            }
        } else {
            this.checkForFinal(expression, (VariableExpression)expression);
        }
    }

    private void checkForFinal(Expression expression, VariableExpression ve) {
        Variable v = ve.getAccessedVariable();
        if (v != null) {
            boolean isFinal = Modifier.isFinal(v.getModifiers());
            boolean isParameter = v instanceof Parameter;
            if (isFinal && isParameter) {
                this.addError("Cannot assign a value to final variable '" + v.getName() + "'", expression);
            }
        }
    }

    @Override
    public void visitVariableExpression(VariableExpression expression) {
        String name = expression.getName();
        Variable v = this.findVariableDeclaration(name);
        if (v == null) {
            return;
        }
        expression.setAccessedVariable(v);
        this.checkVariableContextAccess(v, expression);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression expression) {
        expression.getObjectExpression().visit(this);
        expression.getProperty().visit(this);
        this.checkPropertyOnExplicitThis(expression);
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        this.pushState();
        expression.setVariableScope(this.currentScope);
        if (expression.isParameterSpecified()) {
            for (Parameter parameter : expression.getParameters()) {
                parameter.setInStaticContext(this.currentScope.isInStaticContext());
                if (parameter.hasInitialExpression()) {
                    parameter.getInitialExpression().visit(this);
                }
                this.declare(parameter, expression);
            }
        } else if (expression.getParameters() != null) {
            Parameter var = new Parameter(ClassHelper.OBJECT_TYPE, "it");
            var.setInStaticContext(this.currentScope.isInStaticContext());
            this.currentScope.putDeclaredVariable(var);
        }
        super.visitClosureExpression(expression);
        this.markClosureSharedVariables();
        this.popState();
    }

    private void markClosureSharedVariables() {
        VariableScope scope = this.currentScope;
        Iterator<Variable> it = scope.getReferencedLocalVariablesIterator();
        while (it.hasNext()) {
            it.next().setClosureSharedVariable(true);
        }
    }

    @Override
    public void visitCatchStatement(CatchStatement statement) {
        this.pushState();
        Parameter p = statement.getVariable();
        p.setInStaticContext(this.currentScope.isInStaticContext());
        this.declare(p, statement);
        super.visitCatchStatement(statement);
        this.popState();
    }

    @Override
    public void visitFieldExpression(FieldExpression expression) {
        String name = expression.getFieldName();
        Variable v = this.findVariableDeclaration(name);
        this.checkVariableContextAccess(v, expression);
    }

    @Override
    public void visitClass(ClassNode node) {
        if (VariableScopeVisitor.isAnonymous(node)) {
            return;
        }
        this.pushState();
        this.prepareVisit(node);
        super.visitClass(node);
        if (this.recurseInnerClasses) {
            Iterator<InnerClassNode> innerClasses = node.getInnerClasses();
            while (innerClasses.hasNext()) {
                this.visitClass(innerClasses.next());
            }
        }
        this.popState();
    }

    public void prepareVisit(ClassNode node) {
        this.currentClass = node;
        this.currentScope.setClassScope(node);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        Parameter[] parameters;
        this.pushState(node.isStatic());
        this.inConstructor = isConstructor;
        node.setVariableScope(this.currentScope);
        this.visitAnnotations(node);
        for (Parameter parameter : parameters = node.getParameters()) {
            this.visitAnnotations(parameter);
        }
        for (Parameter parameter : parameters) {
            if (parameter.hasInitialExpression()) {
                parameter.getInitialExpression().visit(this);
            }
            this.declare(parameter, node);
        }
        this.visitClassCodeContainer(node.getCode());
        this.popState();
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        if (call.isImplicitThis() && call.getMethod() instanceof ConstantExpression) {
            ConstantExpression methodNameConstant = (ConstantExpression)call.getMethod();
            String methodName = methodNameConstant.getText();
            if (methodName == null) {
                throw new GroovyBugError("method name is null");
            }
            Variable v = this.findVariableDeclaration(methodName);
            if (v != null && !(v instanceof DynamicVariable)) {
                this.checkVariableContextAccess(v, call);
            }
            if (v instanceof VariableExpression || v instanceof Parameter) {
                VariableExpression object = new VariableExpression(v);
                object.setSourcePosition(methodNameConstant);
                call.setObjectExpression(object);
                ConstantExpression method = new ConstantExpression("call");
                method.setSourcePosition(methodNameConstant);
                call.setImplicitThis(false);
                call.setMethod(method);
            }
        }
        super.visitMethodCallExpression(call);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        boolean specialCtorFlag = this.inSpecialConstructorCall;
        this.inSpecialConstructorCall |= call.isSpecialCall();
        super.visitConstructorCallExpression(call);
        this.inSpecialConstructorCall = specialCtorFlag;
        if (!call.isUsingAnonymousInnerClass()) {
            return;
        }
        this.pushState();
        InnerClassNode innerClass = (InnerClassNode)call.getType();
        innerClass.setVariableScope(this.currentScope);
        this.currentScope.setClassScope(innerClass);
        this.currentScope.setInStaticContext(false);
        for (MethodNode method : innerClass.getMethods()) {
            Parameter[] parameters;
            this.visitAnnotations(method);
            for (Parameter p : parameters = method.getParameters()) {
                this.visitAnnotations(p);
            }
            if (parameters.length == 0) {
                parameters = null;
            }
            ClosureExpression cl = new ClosureExpression(parameters, method.getCode());
            this.visitClosureExpression(cl);
        }
        for (FieldNode field : innerClass.getFields()) {
            this.visitAnnotations(field);
            Expression expression = field.getInitialExpression();
            if (expression == null || expression.isSynthetic() && expression instanceof VariableExpression && ((VariableExpression)expression).getAccessedVariable() instanceof Parameter) continue;
            this.pushState(field.isStatic());
            expression.visit(this);
            this.popState();
        }
        for (Statement statement : innerClass.getObjectInitializerStatements()) {
            statement.visit(this);
        }
        this.markClosureSharedVariables();
        this.popState();
    }

    @Override
    public void visitProperty(PropertyNode node) {
        this.pushState(node.isStatic());
        super.visitProperty(node);
        this.popState();
    }

    @Override
    public void visitField(FieldNode node) {
        this.pushState(node.isStatic());
        super.visitField(node);
        this.popState();
    }

    private static class StateStackElement {
        final ClassNode clazz;
        final VariableScope scope;
        final boolean inConstructor;

        StateStackElement(ClassNode currentClass, VariableScope currentScope, boolean inConstructor) {
            this.clazz = currentClass;
            this.scope = currentScope;
            this.inConstructor = inConstructor;
        }
    }
}

